/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.encoding;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.util.ResourceLoader;

public abstract class Encoding
implements COSObjectable {
    protected Map codeToName = new HashMap();
    protected Map nameToCode = new HashMap();
    private static final Map NAME_TO_CHARACTER = new HashMap();
    private static final Map CHARACTER_TO_NAME = new HashMap();

    protected void addCharacterEncoding(int code, COSName name) {
        Integer intCode = new Integer(code);
        this.codeToName.put(intCode, name);
        this.nameToCode.put(name, intCode);
    }

    public int getCode(COSName name) throws IOException {
        Integer code = (Integer)this.nameToCode.get(name);
        if (code == null) {
            throw new IOException("No character code for character name '" + name.getName() + "'");
        }
        return code;
    }

    public COSName getName(int code) throws IOException {
        COSName name = (COSName)this.codeToName.get(new Integer(code));
        if (name == null) {
            name = COSName.getPDFName("space");
        }
        return name;
    }

    public COSName getNameFromCharacter(char c) throws IOException {
        COSName name = (COSName)CHARACTER_TO_NAME.get("" + c);
        if (name == null) {
            throw new IOException("No name for character '" + c + "'");
        }
        return name;
    }

    public String getCharacter(int code) throws IOException {
        String character = Encoding.getCharacter(this.getName(code));
        return character;
    }

    public static String getCharacter(COSName name) {
        String character = (String)NAME_TO_CHARACTER.get(name);
        if (character == null) {
            character = name.getName();
        }
        return character;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        BufferedReader glyphStream = null;
        try {
            InputStream resource = ResourceLoader.loadResource("Resources/glyphlist.txt");
            glyphStream = new BufferedReader(new InputStreamReader(resource));
            String line = null;
            while ((line = glyphStream.readLine()) != null) {
                int semicolonIndex;
                if ((line = line.trim()).startsWith("#") || (semicolonIndex = line.indexOf(59)) < 0) continue;
                try {
                    String characterName = line.substring(0, semicolonIndex);
                    String unicodeValue = line.substring(semicolonIndex + 1, line.length());
                    StringTokenizer tokenizer = new StringTokenizer(unicodeValue, " ", false);
                    String value = "";
                    while (tokenizer.hasMoreTokens()) {
                        int characterCode = Integer.parseInt(tokenizer.nextToken(), 16);
                        value = value + (char)characterCode;
                    }
                    NAME_TO_CHARACTER.put(COSName.getPDFName(characterName), value);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            if (glyphStream != null) {
                try {
                    glyphStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        NAME_TO_CHARACTER.put(COSName.getPDFName(".notdef"), "");
        NAME_TO_CHARACTER.put(COSName.getPDFName("fi"), "fi");
        NAME_TO_CHARACTER.put(COSName.getPDFName("fl"), "fl");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ffi"), "ffi");
        NAME_TO_CHARACTER.put(COSName.getPDFName("ff"), "ff");
        NAME_TO_CHARACTER.put(COSName.getPDFName("pi"), "pi");
        for (Object key : NAME_TO_CHARACTER.keySet()) {
            Object value = NAME_TO_CHARACTER.get(key);
            CHARACTER_TO_NAME.put(value, key);
        }
    }
}

