/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.DefaultSoapUICore;
import com.eviware.soapui.SoapUI;
import com.eviware.soapui.SoapUICore;
import com.eviware.soapui.StandaloneSoapUICore;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public abstract class AbstractSoapUIRunner {
    private boolean groovyLogInitialized;
    private String projectFile;
    protected final Logger log = Logger.getLogger(this.getClass());
    private String settingsFile;
    private String soapUISettingsPassword;
    private boolean enableUI;
    private String outputFolder;
    private String[] projectProperties;

    public AbstractSoapUIRunner(String title) {
        if (title != null) {
            System.out.println(title);
        }
    }

    protected void initGroovyLog() {
        if (!this.groovyLogInitialized) {
            Logger logger = Logger.getLogger((String)"groovy.log");
            ConsoleAppender appender = new ConsoleAppender();
            appender.setWriter((Writer)new OutputStreamWriter(System.out));
            appender.setLayout((Layout)new PatternLayout("%d{ABSOLUTE} %-5p [%c{1}] %m%n"));
            logger.addAppender((Appender)appender);
            this.groovyLogInitialized = true;
        }
    }

    public int runFromCommandLine(String[] args) {
        try {
            if (this.initFromCommandLine(args, true) && this.run()) {
                return 0;
            }
        }
        catch (Throwable e) {
            this.log.error((Object)e);
            SoapUI.logError(e);
        }
        return -1;
    }

    public boolean initFromCommandLine(String[] args, boolean printHelp) throws Exception {
        SoapUIOptions options = this.initCommandLineOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse((Options)options, args);
        if (options.requiresProject()) {
            args = cmd.getArgs();
            if (args.length != 1) {
                if (printHelp) {
                    HelpFormatter formatter = new HelpFormatter();
                    formatter.printHelp(options.getRunnerName() + " [options] <soapui-project-file>", (Options)options);
                }
                System.err.println("Missing soapUI project file..");
                return false;
            }
            this.setProjectFile(args[0]);
        }
        return this.processCommandLine(cmd);
    }

    public final boolean run() throws Exception {
        SoapUI.setSoapUICore(this.createSoapUICore());
        SoapUI.initGCTimer();
        return this.runRunner();
    }

    protected SoapUICore createSoapUICore() {
        if (this.enableUI) {
            StandaloneSoapUICore core = new StandaloneSoapUICore(this.settingsFile);
            this.log.info((Object)"Enabling UI Components");
            core.prepareUI();
            UISupport.setMainFrame(null);
            return core;
        }
        return new DefaultSoapUICore(null, this.settingsFile, this.soapUISettingsPassword);
    }

    protected abstract boolean processCommandLine(CommandLine var1);

    protected abstract SoapUIOptions initCommandLineOptions();

    protected abstract boolean runRunner() throws Exception;

    protected String getCommandLineOptionSubstSpace(CommandLine cmd, String key) {
        return cmd.getOptionValue(key).replaceAll("%20", " ");
    }

    public String getProjectFile() {
        return this.projectFile;
    }

    public String getSettingsFile() {
        return this.settingsFile;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public String getAbsoluteOutputFolder(ModelItem modelItem) {
        String folder = this.outputFolder;
        if (StringUtils.isNullOrEmpty(folder)) {
            folder = PathUtils.getExpandedResourceRoot(modelItem);
        } else if (PathUtils.isRelativePath(folder)) {
            folder = PathUtils.resolveResourcePath(folder, modelItem);
        }
        return folder;
    }

    public String getModelItemOutputFolder(ModelItem modelItem) {
        ArrayList<ModelItem> chain = new ArrayList<ModelItem>();
        ModelItem p = modelItem;
        while (!(p instanceof Project)) {
            chain.add(0, p);
            p = p.getParent();
        }
        File dir = new File(this.getAbsoluteOutputFolder(modelItem));
        dir.mkdir();
        for (ModelItem item : chain) {
            dir = new File(dir, StringUtils.createFileName(item.getName(), '-'));
            dir.mkdir();
        }
        return dir.getAbsolutePath();
    }

    protected void ensureOutputFolder(ModelItem modelItem) {
        this.ensureFolder(this.getAbsoluteOutputFolder(modelItem));
    }

    public void ensureFolder(String path) {
        if (path == null) {
            return;
        }
        File folder = new File(path);
        if (!folder.exists() || !folder.isDirectory()) {
            folder.mkdirs();
        }
    }

    public void setProjectFile(String projectFile) {
        this.projectFile = projectFile;
    }

    public void setSettingsFile(String settingsFile) {
        this.settingsFile = settingsFile;
    }

    public void setEnableUI(boolean enableUI) {
        this.enableUI = enableUI;
    }

    public String getSoapUISettingsPassword() {
        return this.soapUISettingsPassword;
    }

    public void setSoapUISettingsPassword(String soapUISettingsPassword) {
        this.soapUISettingsPassword = soapUISettingsPassword;
    }

    public void setSystemProperties(String[] optionValues) {
        for (String option : optionValues) {
            int ix = option.indexOf(61);
            if (ix == -1) continue;
            System.setProperty(option.substring(0, ix), option.substring(ix + 1));
        }
    }

    public void setGlobalProperties(String[] optionValues) {
        for (String option : optionValues) {
            int ix = option.indexOf(61);
            if (ix == -1) continue;
            String name = option.substring(0, ix);
            String value = option.substring(ix + 1);
            this.log.info((Object)("Setting global property [" + name + "] to [" + value + "]"));
            PropertyExpansionUtils.getGlobalProperties().setPropertyValue(name, value);
        }
    }

    public void setProjectProperties(String[] projectProperties) {
        this.projectProperties = projectProperties;
    }

    public Logger getLog() {
        return this.log;
    }

    public String[] getProjectProperties() {
        return this.projectProperties;
    }

    protected void initProjectProperties(WsdlProject project) {
        if (this.projectProperties != null) {
            for (String option : this.projectProperties) {
                int ix = option.indexOf(61);
                if (ix == -1) continue;
                String name = option.substring(0, ix);
                String value = option.substring(ix + 1);
                this.log.info((Object)("Setting project property [" + name + "] to [" + value + "]"));
                project.setPropertyValue(name, value);
            }
        }
    }

    protected boolean isEnableUI() {
        return this.enableUI;
    }

    public static class SoapUIOptions
    extends Options {
        private final String runnerName;

        public SoapUIOptions(String runnerName) {
            this.runnerName = runnerName;
        }

        public String getRunnerName() {
            return this.runnerName;
        }

        public boolean requiresProject() {
            return true;
        }
    }
}

