/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.JXEditTextArea;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class SaveXmlTextAreaAction
extends AbstractAction {
    private final JXEditTextArea textArea;
    private String dialogTitle;
    private static final Logger log = Logger.getLogger(SaveXmlTextAreaAction.class);

    public SaveXmlTextAreaAction(JXEditTextArea textArea, String dialogTitle) {
        super("Save as..");
        this.textArea = textArea;
        this.dialogTitle = dialogTitle;
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu S"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        File file = UISupport.getFileDialogs().saveAs(this, this.dialogTitle, ".xml", "XML Files (*.xml)", null);
        if (file == null) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            try {
                XmlObject xml = XmlObject.Factory.parse((String)this.textArea.getText());
                xml.save(file);
            }
            catch (XmlException e1) {
                writer = new FileWriter(file);
                writer.write(this.textArea.getText());
                writer.close();
            }
            log.info((Object)("XML written to [" + file.getAbsolutePath() + "]"));
        }
        catch (IOException e1) {
            UISupport.showErrorMessage("Error saving xml to file: " + e1.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e1) {
                    SoapUI.logError(e1);
                }
            }
        }
    }
}

