/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.swing;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.JXEditTextArea;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class JXEditAreaPopupMenu
extends JPopupMenu
implements PopupMenuListener {
    private final JXEditTextArea textComponent;
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private ClearAction clearAction;
    private SelectAllAction selectAllAction;
    private UndoAction undoAction;
    private RedoAction redoAction;

    public static JXEditAreaPopupMenu add(JXEditTextArea textComponent) {
        if (textComponent.getRightClickPopup() instanceof JXEditAreaPopupMenu) {
            return (JXEditAreaPopupMenu)textComponent.getRightClickPopup();
        }
        JXEditAreaPopupMenu popupMenu = new JXEditAreaPopupMenu(textComponent);
        textComponent.setRightClickPopup(popupMenu);
        return popupMenu;
    }

    private JXEditAreaPopupMenu(JXEditTextArea textComponent) {
        super("Edit");
        this.textComponent = textComponent;
        this.undoAction = new UndoAction();
        this.add(this.undoAction);
        this.redoAction = new RedoAction();
        this.add(this.redoAction);
        this.addSeparator();
        this.cutAction = new CutAction();
        this.add(this.cutAction);
        this.copyAction = new CopyAction();
        this.add(this.copyAction);
        this.pasteAction = new PasteAction();
        this.add(this.pasteAction);
        this.clearAction = new ClearAction();
        this.add(this.clearAction);
        this.addSeparator();
        this.selectAllAction = new SelectAllAction();
        this.add(this.selectAllAction);
        this.addPopupMenuListener(this);
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.undoAction.setEnabled(this.textComponent.canUndo());
        this.redoAction.setEnabled(this.textComponent.canRedo());
        this.cutAction.setEnabled(this.textComponent.getSelectionEnd() != this.textComponent.getSelectionStart());
        this.copyAction.setEnabled(this.cutAction.isEnabled());
        this.clearAction.setEnabled(this.cutAction.isEnabled());
        this.selectAllAction.setEnabled(this.textComponent.getText().length() > 0);
    }

    private final class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu Y"));
        }

        public void actionPerformed(ActionEvent e) {
            JXEditAreaPopupMenu.this.textComponent.redo();
        }
    }

    private final class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu Z"));
        }

        public void actionPerformed(ActionEvent e) {
            JXEditAreaPopupMenu.this.textComponent.undo();
        }
    }

    private final class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            super("Select All");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu A"));
        }

        public void actionPerformed(ActionEvent e) {
            JXEditAreaPopupMenu.this.textComponent.selectAll();
        }
    }

    private final class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super("Clear");
        }

        public void actionPerformed(ActionEvent e) {
            JXEditAreaPopupMenu.this.textComponent.setText("");
        }
    }

    private final class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super("Paste");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu V"));
        }

        public void actionPerformed(ActionEvent e) {
            JXEditAreaPopupMenu.this.textComponent.paste();
        }
    }

    private final class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu C"));
        }

        public void actionPerformed(ActionEvent e) {
            JXEditAreaPopupMenu.this.textComponent.copy();
        }
    }

    private final class CutAction
    extends AbstractAction {
        public CutAction() {
            super("Cut");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu X"));
        }

        public void actionPerformed(ActionEvent e) {
            JXEditAreaPopupMenu.this.textComponent.cut();
        }
    }
}

