/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.swing;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class AutoscrollSupport
implements Autoscroll {
    private static final int AUTOSCROLL_MARGIN = 12;
    Component comp;
    Insets insets;
    Insets scrollUnits;

    public AutoscrollSupport(Component comp, Insets insets) {
        this(comp, insets, insets);
    }

    public AutoscrollSupport(Component comp, Insets insets, Insets scrollUnits) {
        this.comp = comp;
        this.insets = insets;
        this.scrollUnits = scrollUnits;
    }

    public AutoscrollSupport(Component comp) {
        this(comp, new Insets(12, 12, 12, 12));
    }

    public void autoscroll(Point cursorLoc) {
        JViewport viewport = this.getViewport();
        if (viewport == null) {
            return;
        }
        Point viewPos = viewport.getViewPosition();
        int viewHeight = viewport.getExtentSize().height;
        int viewWidth = viewport.getExtentSize().width;
        if (cursorLoc.y - viewPos.y < this.insets.top) {
            viewport.setViewPosition(new Point(viewPos.x, Math.max(viewPos.y - this.scrollUnits.top, 0)));
        } else if (viewPos.y + viewHeight - cursorLoc.y < this.insets.bottom) {
            viewport.setViewPosition(new Point(viewPos.x, Math.min(viewPos.y + this.scrollUnits.bottom, this.comp.getHeight() - viewHeight)));
        } else if (cursorLoc.x - viewPos.x < this.insets.left) {
            viewport.setViewPosition(new Point(Math.max(viewPos.x - this.scrollUnits.left, 0), viewPos.y));
        } else if (viewPos.x + viewWidth - cursorLoc.x < this.insets.right) {
            viewport.setViewPosition(new Point(Math.min(viewPos.x + this.scrollUnits.right, this.comp.getWidth() - viewWidth), viewPos.y));
        }
    }

    public Insets getAutoscrollInsets() {
        Rectangle raOuter = this.comp.getBounds();
        Rectangle raInner = this.comp.getParent().getBounds();
        return new Insets(raInner.y - raOuter.y + 12, raInner.x - raOuter.x + this.comp.getWidth(), raOuter.height - raInner.height - raInner.y + raOuter.y + 12, raOuter.width - raInner.width - raInner.x + raOuter.x + 12);
    }

    JViewport getViewport() {
        return (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.comp);
    }
}

