/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.views.xml.source;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.LineNumbersPanel;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.PreviewCorner;
import com.eviware.soapui.support.editor.EditorLocation;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.editor.xml.XmlEditor;
import com.eviware.soapui.support.editor.xml.XmlLocation;
import com.eviware.soapui.support.editor.xml.support.ValidationError;
import com.eviware.soapui.support.swing.SoapUISplitPaneUI;
import com.eviware.soapui.support.xml.JXEditTextArea;
import com.eviware.soapui.support.xml.actions.FormatXmlAction;
import com.eviware.soapui.support.xml.actions.InsertBase64FileTextAreaAction;
import com.eviware.soapui.support.xml.actions.LoadXmlTextAreaAction;
import com.eviware.soapui.support.xml.actions.SaveXmlTextAreaAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSourceEditorView<T extends ModelItem>
extends AbstractXmlEditorView<XmlDocument>
implements PropertyChangeListener {
    private JXEditTextArea editArea;
    private ValidateMessageXmlAction validateXmlAction;
    private JSplitPane splitter;
    private JScrollPane errorScrollPane;
    private DefaultListModel errorListModel;
    private FormatXmlAction formatXmlAction;
    private SaveXmlTextAreaAction saveXmlTextAreaAction;
    private boolean updating;
    private JPopupMenu editorPopup;
    public boolean isLocating;
    private JScrollPane editorScrollPane;
    private LoadXmlTextAreaAction loadXmlTextAreaAction;
    private JPopupMenu inputPopup;
    private LineNumbersPanel lineNumbersPanel;
    private JCheckBoxMenuItem toggleLineNumbersMenuItem;
    private PreviewCorner previewCorner;
    private final T modelItem;
    private InsertBase64FileTextAreaAction insertBase64FileTextAreaAction;

    public XmlSourceEditorView(XmlEditor<XmlDocument> xmlEditor, T modelItem) {
        super("XML", xmlEditor, "Source");
        this.modelItem = modelItem;
    }

    protected void buildUI() {
        this.editArea = JXEditTextArea.createXmlEditor(false);
        this.editArea.setMinimumSize(new Dimension(50, 50));
        this.editArea.setCaretPosition(0);
        this.editArea.setDiscardEditsOnSet(false);
        this.editArea.setEnabled(false);
        this.editArea.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, Color.WHITE));
        this.errorListModel = new DefaultListModel();
        JList list = new JList(this.errorListModel);
        list.addMouseListener(new ValidationListMouseAdapter(list, this.editArea));
        this.errorScrollPane = new JScrollPane(list);
        this.errorScrollPane.setVisible(false);
        this.splitter = new JSplitPane(0){

            public void requestFocus() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        XmlSourceEditorView.this.editArea.requestFocusInWindow();
                    }
                });
            }

            public boolean hasFocus() {
                return XmlSourceEditorView.this.editArea.hasFocus();
            }
        };
        this.splitter.setUI(new SoapUISplitPaneUI());
        this.splitter.setDividerSize(0);
        this.splitter.setOneTouchExpandable(true);
        this.lineNumbersPanel = new LineNumbersPanel(this.editArea);
        this.lineNumbersPanel.setVisible(SoapUI.getSettings().getBoolean(UISettings.SHOW_XML_LINE_NUMBERS));
        this.editorPopup = new JPopupMenu();
        this.buildPopup(this.editorPopup, this.editArea);
        this.editArea.setRightClickPopup(this.editorPopup);
        this.editArea.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                if (!XmlSourceEditorView.this.updating && XmlSourceEditorView.this.getDocument() != null) {
                    XmlSourceEditorView.this.updating = true;
                    XmlSourceEditorView.this.getDocument().setXml(XmlSourceEditorView.this.editArea.getText());
                    XmlSourceEditorView.this.updating = false;
                }
            }
        });
        this.editArea.getInputHandler().addKeyBinding("A+V", this.validateXmlAction);
        this.editArea.getInputHandler().addKeyBinding("A+F", this.formatXmlAction);
        this.editArea.getInputHandler().addKeyBinding("C+S", this.saveXmlTextAreaAction);
        this.editArea.getInputHandler().addKeyBinding("ALT+L", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XmlSourceEditorView.this.lineNumbersPanel.setVisible(!XmlSourceEditorView.this.lineNumbersPanel.isVisible());
                XmlSourceEditorView.this.toggleLineNumbersMenuItem.setSelected(XmlSourceEditorView.this.lineNumbersPanel.isVisible());
            }
        });
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.editArea, "Center");
        p.add((Component)this.lineNumbersPanel, "West");
        this.editorScrollPane = new JScrollPane(p);
        this.splitter.setTopComponent(this.editorScrollPane);
        this.splitter.setBottomComponent(this.errorScrollPane);
        this.splitter.setDividerLocation(1.0);
        this.splitter.setBorder(null);
        this.previewCorner = UISupport.addPreviewCorner(this.getEditorScrollPane(), true);
    }

    public JScrollPane getEditorScrollPane() {
        return this.editorScrollPane;
    }

    public T getModelItem() {
        return this.modelItem;
    }

    protected void buildPopup(JPopupMenu inputPopup, JXEditTextArea editArea) {
        this.inputPopup = inputPopup;
        this.validateXmlAction = new ValidateMessageXmlAction();
        this.formatXmlAction = new FormatXmlAction(editArea);
        this.saveXmlTextAreaAction = new SaveXmlTextAreaAction(editArea, "Save");
        this.loadXmlTextAreaAction = new LoadXmlTextAreaAction(editArea, "Load");
        this.insertBase64FileTextAreaAction = new InsertBase64FileTextAreaAction(editArea, "Insert File as Base64");
        this.toggleLineNumbersMenuItem = new JCheckBoxMenuItem("Show Line Numbers", this.lineNumbersPanel.isVisible());
        this.toggleLineNumbersMenuItem.setAccelerator(UISupport.getKeyStroke("alt L"));
        this.toggleLineNumbersMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XmlSourceEditorView.this.lineNumbersPanel.setVisible(XmlSourceEditorView.this.toggleLineNumbersMenuItem.isSelected());
            }
        });
        inputPopup.add(this.validateXmlAction);
        inputPopup.add(this.formatXmlAction);
        inputPopup.addSeparator();
        inputPopup.add(editArea.getUndoAction());
        inputPopup.add(editArea.getRedoAction());
        inputPopup.add(editArea.createCopyAction());
        inputPopup.add(editArea.createCutAction());
        inputPopup.add(editArea.createPasteAction());
        inputPopup.addSeparator();
        inputPopup.add(editArea.getFindAndReplaceAction());
        inputPopup.addSeparator();
        inputPopup.add(editArea.getGoToLineAction());
        inputPopup.add(this.toggleLineNumbersMenuItem);
        inputPopup.addSeparator();
        inputPopup.add(this.saveXmlTextAreaAction);
        inputPopup.add(this.loadXmlTextAreaAction);
        inputPopup.add(this.insertBase64FileTextAreaAction);
    }

    @Override
    public void release() {
        super.release();
        this.inputPopup.removeAll();
        this.previewCorner.release();
    }

    public JXEditTextArea getInputArea() {
        this.getComponent();
        return this.editArea;
    }

    @Override
    public void setEditable(boolean enabled) {
        this.getComponent();
        this.editArea.setEditable(enabled);
    }

    protected ValidationError[] validateXml(String xml) {
        try {
            XmlObject.Factory.parse((String)xml, (XmlOptions)new XmlOptions().setLoadLineNumbers());
        }
        catch (XmlException e) {
            ArrayList<AssertionError> result = new ArrayList<AssertionError>();
            if (e.getErrors() != null) {
                for (Object error : e.getErrors()) {
                    if (error instanceof XmlError) {
                        result.add(new AssertionError((XmlError)error));
                        continue;
                    }
                    result.add(new AssertionError(error.toString()));
                }
            }
            if (result.isEmpty()) {
                result.add(new AssertionError(e.toString()));
            }
            return result.toArray(new ValidationError[result.size()]);
        }
        return null;
    }

    public boolean activate(XmlLocation location) {
        super.activate(location);
        if (location != null) {
            this.setLocation(location);
        }
        this.editArea.requestFocus();
        return true;
    }

    @Override
    public JComponent getComponent() {
        if (this.splitter == null) {
            this.buildUI();
        }
        return this.splitter;
    }

    public XmlLocation getEditorLocation() {
        return new XmlLocation(this.getCurrentLine() + 1, this.getCurrentColumn());
    }

    public void setLocation(XmlLocation location) {
        int line = location.getLine() - 1;
        if (location != null && line >= 0) {
            int caretLine = this.editArea.getCaretLine();
            int offset = this.editArea.getLineStartOffset(line);
            try {
                this.editArea.setCaretPosition(offset + location.getColumn());
                int scrollLine = line + (line > caretLine ? 3 : -3);
                if (scrollLine >= this.editArea.getLineCount()) {
                    scrollLine = this.editArea.getLineCount() - 1;
                } else if (scrollLine < 0) {
                    scrollLine = 0;
                }
                this.editArea.scrollTo(scrollLine, location.getColumn());
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
    }

    public int getCurrentLine() {
        if (this.editArea == null) {
            return -1;
        }
        return this.editArea.getCaretLine();
    }

    public int getCurrentColumn() {
        if (this.editArea == null) {
            return -1;
        }
        return this.editArea.getCaretColumn();
    }

    public String getText() {
        if (this.editArea == null) {
            return null;
        }
        return this.editArea.getText();
    }

    public boolean validate() {
        ValidationError[] errors = this.validateXml(PropertyExpander.expandProperties(this.getModelItem(), this.editArea.getText()));
        this.errorListModel.clear();
        if (errors == null || errors.length == 0) {
            this.splitter.setDividerLocation(1.0);
            this.splitter.setDividerSize(0);
            this.errorScrollPane.setVisible(false);
            return true;
        }
        Toolkit.getDefaultToolkit().beep();
        for (int c = 0; c < errors.length; ++c) {
            this.errorListModel.addElement(errors[c]);
        }
        this.errorScrollPane.setVisible(true);
        this.splitter.setDividerLocation(0.8);
        this.splitter.setDividerSize(10);
        return false;
    }

    @Override
    public void setXml(String xml) {
        if (!this.updating) {
            this.updating = true;
            if (xml == null) {
                this.editArea.setText("");
                this.editArea.setEnabled(false);
            } else {
                int caretPosition = this.editArea.getCaretPosition();
                this.editArea.setEnabled(true);
                this.editArea.setText(xml);
                this.editArea.setCaretPosition(caretPosition < xml.length() ? caretPosition : 0);
            }
            this.updating = false;
        }
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return validate ? this.validate() : true;
    }

    @Override
    public void locationChanged(EditorLocation<XmlDocument> location) {
        this.isLocating = true;
        this.setLocation(location);
        this.isLocating = false;
    }

    public JPopupMenu getEditorPopup() {
        return this.editorPopup;
    }

    public boolean hasFocus() {
        return this.editArea.hasFocus();
    }

    public boolean isInspectable() {
        return true;
    }

    public ValidateMessageXmlAction getValidateXmlAction() {
        return this.validateXmlAction;
    }

    public class ValidateMessageXmlAction
    extends AbstractAction {
        public ValidateMessageXmlAction() {
            super("Validate");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt V"));
        }

        public void actionPerformed(ActionEvent e) {
            if (XmlSourceEditorView.this.validate()) {
                UISupport.showInfoMessage("Validation OK");
            }
        }
    }

    private static final class ValidationListMouseAdapter
    extends MouseAdapter {
        private final JList list;
        private final JXEditTextArea textArea;

        public ValidationListMouseAdapter(JList list, JXEditTextArea textArea) {
            this.list = list;
            this.textArea = textArea;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                return;
            }
            int ix = this.list.getSelectedIndex();
            if (ix == -1) {
                return;
            }
            Object obj = this.list.getModel().getElementAt(ix);
            if (obj instanceof ValidationError) {
                ValidationError error = (ValidationError)obj;
                if (error.getLineNumber() >= 0) {
                    this.textArea.setCaretPosition(this.textArea.getLineStartOffset(error.getLineNumber() - 1));
                    this.textArea.requestFocus();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

