/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.support;

import com.eviware.soapui.support.editor.Editor;
import com.eviware.soapui.support.editor.EditorDocument;
import com.eviware.soapui.support.editor.EditorLocation;
import com.eviware.soapui.support.editor.EditorLocationListener;
import com.eviware.soapui.support.editor.EditorView;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEditorView<T extends EditorDocument>
implements EditorView<T> {
    private String title;
    private boolean isActive;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private T xmlDocument;
    private Set<EditorLocationListener<T>> listeners = new HashSet<EditorLocationListener<T>>();
    private Editor<T> editor;
    private JComponent component;
    private final String viewId;

    public AbstractEditorView(String title, Editor<T> editor, String viewId) {
        this.title = title;
        this.editor = editor;
        this.viewId = viewId;
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = this.buildUI();
        }
        return this.component;
    }

    @Override
    public String getViewId() {
        return this.viewId;
    }

    @Override
    public void requestFocus() {
        if (this.component != null) {
            this.component.requestFocusInWindow();
        }
    }

    public abstract JComponent buildUI();

    @Override
    public boolean activate(EditorLocation<T> location) {
        this.isActive = true;
        return true;
    }

    @Override
    public boolean deactivate() {
        this.isActive = false;
        return true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.propertyChangeSupport.firePropertyChange(TITLE_PROPERTY, oldTitle, title);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public T getDocument() {
        return this.xmlDocument;
    }

    @Override
    public void setDocument(T xmlDocument) {
        this.xmlDocument = xmlDocument;
    }

    @Override
    public void release() {
        if (this.xmlDocument != null) {
            this.xmlDocument = null;
        }
    }

    @Override
    public void addLocationListener(EditorLocationListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLocationListener(EditorLocationListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void fireLocationChanged(EditorLocation<T> location) {
        for (EditorLocationListener<T> listener : this.listeners) {
            listener.locationChanged(location);
        }
    }

    @Override
    public EditorLocation<T> getEditorLocation() {
        return null;
    }

    @Override
    public void setLocation(EditorLocation<T> location) {
    }

    @Override
    public void locationChanged(EditorLocation<T> location) {
    }

    @Override
    public Editor<T> getEditor() {
        return this.editor;
    }

    @Override
    public void setEditable(boolean enabled) {
    }
}

