/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.jms.property;

import com.eviware.soapui.impl.wsdl.panels.request.StringToStringMapTableModel;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.inspectors.jms.property.JMSHeaderAndPropertyInspectorModel;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.types.StringToStringMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSHeaderAndPropertyInspector
extends AbstractXmlInspector
implements PropertyChangeListener {
    private StringToStringMapTableModel headersTableModel;
    private final JMSHeaderAndPropertyInspectorModel model;
    private JTable headersTable;
    private JPanel panel;
    public boolean changing;

    protected JMSHeaderAndPropertyInspector(JMSHeaderAndPropertyInspectorModel model) {
        super("JMS (" + (model.getJMSHeadersAndProperties() == null ? "0" : Integer.valueOf(model.getJMSHeadersAndProperties().size())) + ")", "JMS Header and Property for this message", true, "JMS Headers and Properties");
        this.model = model;
        model.addPropertyChangeListener(this);
        model.setInspector(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel != null) {
            return this.panel;
        }
        this.headersTableModel = new StringToStringMapTableModel(this.model.getJMSHeadersAndProperties(), "Key", "Value", !this.model.isReadOnly());
        this.headersTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent arg0) {
                StringToStringMap map = JMSHeaderAndPropertyInspector.this.model.getJMSHeadersAndProperties();
                JMSHeaderAndPropertyInspector.this.setTitle("JMS (" + (map == null ? "0" : Integer.valueOf(map.size())) + ")");
            }
        });
        this.headersTable = new JTable(this.headersTableModel);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)new JScrollPane(this.headersTable), "Center");
        return this.panel;
    }

    public JTable getHeadersTable() {
        return this.headersTable;
    }

    @Override
    public void release() {
        super.release();
        this.model.release();
        this.model.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.changing) {
            this.headersTableModel.setData(this.model.getJMSHeadersAndProperties());
        }
    }

    public JMSHeaderAndPropertyInspectorModel getModel() {
        return this.model;
    }

    public StringToStringMapTableModel getHeadersTableModel() {
        return this.headersTableModel;
    }

    @Override
    public boolean isEnabledFor(EditorView<XmlDocument> view) {
        return !view.getViewId().equals("Raw");
    }
}

