/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.amfheader;

import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFRequest;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.impl.wsdl.teststeps.AMFRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.AMFTestStepResult;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.editor.Editor;
import com.eviware.soapui.support.editor.EditorInspector;
import com.eviware.soapui.support.editor.inspectors.amfheader.AMFHeadersInspector;
import com.eviware.soapui.support.editor.inspectors.amfheader.AMFHeadersInspectorModel;
import com.eviware.soapui.support.editor.registry.RequestInspectorFactory;
import com.eviware.soapui.support.editor.registry.ResponseInspectorFactory;
import com.eviware.soapui.support.types.StringToStringMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMFHeadersInspectorFactory
implements RequestInspectorFactory,
ResponseInspectorFactory {
    public static final String INSPECTOR_ID = "AMF Headers";

    @Override
    public String getInspectorId() {
        return INSPECTOR_ID;
    }

    @Override
    public EditorInspector<?> createRequestInspector(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof AMFRequestTestStep) {
            AMFHeadersInspector inspector = new AMFHeadersInspector(new AMFRequestHeadersModel((AMFRequestTestStep)modelItem));
            inspector.setEnabled(true);
            return inspector;
        }
        if (modelItem instanceof MessageExchangeModelItem && ((MessageExchangeModelItem)modelItem).getMessageExchange() instanceof AMFTestStepResult) {
            AMFHeadersInspector inspector = new AMFHeadersInspector(new MessageExchangeRequestAMFHeadersModel((MessageExchangeModelItem)modelItem));
            inspector.setEnabled(true);
            return inspector;
        }
        return null;
    }

    @Override
    public EditorInspector<?> createResponseInspector(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof AMFRequestTestStep) {
            AMFHeadersInspector inspector = new AMFHeadersInspector(new AMFResponseHeadersModel((AMFRequestTestStep)modelItem));
            inspector.setEnabled(true);
            return inspector;
        }
        if (modelItem instanceof MessageExchangeModelItem && ((MessageExchangeModelItem)modelItem).getMessageExchange() instanceof AMFTestStepResult) {
            AMFHeadersInspector inspector = new AMFHeadersInspector(new MessageExchangeResponseAMFHeadersModel((MessageExchangeModelItem)modelItem));
            inspector.setEnabled(true);
            return inspector;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AMFResponseHeadersModel
    extends AMFHeadersInspectorModel.AbstractHeadersModel<AMFRequestTestStep> {
        AMFRequest request;

        public AMFResponseHeadersModel(AMFRequestTestStep testStep) {
            super(true, testStep, AMFRequestTestStep.AMF_HEADERS_PROPERTY);
            this.request = testStep.getAMFRequest();
            this.request.addPropertyChangeListener("response", this);
        }

        @Override
        public StringToStringMap getHeaders() {
            if (((AMFRequestTestStep)this.getModelItem()).getAMFRequest().getResponse() != null) {
                return ((AMFRequestTestStep)this.getModelItem()).getAMFRequest().getResponse().getResponseAMFHeaders();
            }
            return new StringToStringMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AMFRequestHeadersModel
    extends AMFHeadersInspectorModel.AbstractHeadersModel<AMFRequestTestStep> {
        public AMFRequestHeadersModel(AMFRequestTestStep testStep) {
            super(false, testStep, AMFRequestTestStep.AMF_HEADERS_PROPERTY);
        }

        @Override
        public StringToStringMap getHeaders() {
            return ((AMFRequestTestStep)this.getModelItem()).getAmfHeaders();
        }

        @Override
        public void setHeaders(StringToStringMap headers) {
            ((AMFRequestTestStep)this.getModelItem()).setAmfHeaders(headers);
        }

        @Override
        public void release() {
            ((AMFRequestTestStep)this.getModelItem()).removePropertyChangeListener(AMFRequestTestStep.AMF_HEADERS_PROPERTY, this);
            super.release();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageExchangeResponseAMFHeadersModel
    extends AMFHeadersInspectorModel.AbstractHeadersModel<MessageExchangeModelItem> {
        public MessageExchangeResponseAMFHeadersModel(MessageExchangeModelItem messageExchange) {
            super(true, messageExchange, "messageExchange");
        }

        @Override
        public StringToStringMap getHeaders() {
            if (((MessageExchangeModelItem)this.getModelItem()).getMessageExchange() instanceof AMFTestStepResult) {
                AMFTestStepResult messageExchange = (AMFTestStepResult)((MessageExchangeModelItem)this.getModelItem()).getMessageExchange();
                if (((AMFRequestTestStep)messageExchange.getTestStep()).getAMFRequest().getResponse() != null) {
                    return ((AMFRequestTestStep)messageExchange.getTestStep()).getAMFRequest().getResponse().getResponseAMFHeaders();
                }
                return new StringToStringMap();
            }
            return new StringToStringMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageExchangeRequestAMFHeadersModel
    extends AMFHeadersInspectorModel.AbstractHeadersModel<MessageExchangeModelItem> {
        public MessageExchangeRequestAMFHeadersModel(MessageExchangeModelItem request) {
            super(true, request, "messageExchange");
        }

        @Override
        public StringToStringMap getHeaders() {
            if (((MessageExchangeModelItem)this.getModelItem()).getMessageExchange() instanceof AMFTestStepResult) {
                AMFTestStepResult messageExchange = (AMFTestStepResult)((MessageExchangeModelItem)this.getModelItem()).getMessageExchange();
                return ((AMFRequestTestStep)messageExchange.getTestStep()).getAmfHeaders();
            }
            return new StringToStringMap();
        }
    }
}

