/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.dnd.handlers;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.request.AddRequestToTestCaseAction;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.SoapUIAction;
import com.eviware.soapui.support.dnd.handlers.AbstractBeforeAfterModelItemDropHandler;
import com.eviware.soapui.support.dnd.handlers.DragAndDropSupport;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestToTestCaseDropHandler
extends AbstractBeforeAfterModelItemDropHandler<WsdlRequest, WsdlTestCase> {
    public RequestToTestCaseDropHandler() {
        super(WsdlRequest.class, WsdlTestCase.class);
    }

    @Override
    boolean canCopyAfter(WsdlRequest source, WsdlTestCase target) {
        return true;
    }

    @Override
    boolean canMoveAfter(WsdlRequest source, WsdlTestCase target) {
        return true;
    }

    @Override
    boolean copyAfter(WsdlRequest source, WsdlTestCase target) {
        return this.addRequestToTestCase(source, target, -1);
    }

    private boolean addRequestToTestCase(WsdlRequest source, WsdlTestCase target, int index) {
        SoapUIAction action;
        if (!UISupport.confirm("Add Request [" + source.getName() + "] to TestCase [" + target.getName() + "]", "Add Request to TestCase")) {
            return false;
        }
        WsdlProject targetProject = target.getTestSuite().getProject();
        if (targetProject != source.getOperation().getInterface().getProject()) {
            HashSet<Interface> requiredInterfaces = new HashSet<Interface>();
            requiredInterfaces.add(source.getOperation().getInterface());
            if (!DragAndDropSupport.importRequiredInterfaces(targetProject, requiredInterfaces, "Add Request to TestCase")) {
                return false;
            }
        }
        return ((AddRequestToTestCaseAction)(action = SoapUI.getActionRegistry().getAction("AddRequestToTestCaseAction"))).addRequest(target, source, index) != null;
    }

    @Override
    boolean moveAfter(WsdlRequest source, WsdlTestCase target) {
        return this.addRequestToTestCase(source, target, -1);
    }

    @Override
    String getCopyAfterInfo(WsdlRequest source, WsdlTestCase target) {
        return "Add Request [" + source.getName() + "] to TestCase [" + target.getName() + "]";
    }

    @Override
    String getMoveAfterInfo(WsdlRequest source, WsdlTestCase target) {
        return this.getCopyAfterInfo(source, target);
    }

    @Override
    boolean canCopyBefore(WsdlRequest source, WsdlTestCase target) {
        return true;
    }

    @Override
    boolean canMoveBefore(WsdlRequest source, WsdlTestCase target) {
        return true;
    }

    @Override
    boolean copyBefore(WsdlRequest source, WsdlTestCase target) {
        return this.addRequestToTestCase(source, target, 0);
    }

    @Override
    String getCopyBeforeInfo(WsdlRequest source, WsdlTestCase target) {
        return this.getCopyAfterInfo(source, target);
    }

    @Override
    String getMoveBeforeInfo(WsdlRequest source, WsdlTestCase target) {
        return this.getCopyAfterInfo(source, target);
    }

    @Override
    boolean moveBefore(WsdlRequest source, WsdlTestCase target) {
        return this.addRequestToTestCase(source, target, 0);
    }
}

