/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestStep;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class TestStepComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private final WsdlTestCase testCase;
    private WsdlTestStep selectedStep;
    private int selectedStepIndex = -1;
    private TestStepNameListener testStepNameListener = new TestStepNameListener();
    private InternalTestSuiteListener testSuiteListener;

    public TestStepComboBoxModel(WsdlTestCase testCase) {
        this.testCase = testCase;
        this.testSuiteListener = new InternalTestSuiteListener();
        testCase.getTestSuite().addTestSuiteListener(this.testSuiteListener);
    }

    public void release() {
        this.testCase.getTestSuite().removeTestSuiteListener(this.testSuiteListener);
    }

    public Object getElementAt(int index) {
        return this.testCase.getTestStepAt(index).getName();
    }

    public int getSize() {
        return this.testCase.getTestStepCount();
    }

    public Object getSelectedItem() {
        return this.selectedStep == null ? null : this.selectedStep.getName();
    }

    public void setSelectedItem(Object anItem) {
        if (this.selectedStep != null) {
            this.selectedStep.removePropertyChangeListener(this.testStepNameListener);
        }
        this.selectedStep = this.testCase.getTestStepByName((String)anItem);
        if (this.selectedStep != null) {
            this.selectedStep.addPropertyChangeListener(WsdlTestStep.NAME_PROPERTY, this.testStepNameListener);
            this.selectedStepIndex = this.testCase.getIndexOfTestStep(this.selectedStep);
        } else {
            this.selectedStepIndex = -1;
        }
        this.fireContentsChanged(this, -1, -1);
    }

    public WsdlTestStep getSelectedStep() {
        return this.selectedStep;
    }

    private final class TestStepNameListener
    implements PropertyChangeListener {
        private TestStepNameListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object oldItem = evt.getOldValue();
            int stepIndex = TestStepComboBoxModel.this.testCase.getTestStepIndexByName((String)oldItem);
            if (stepIndex != -1) {
                TestStepComboBoxModel.this.fireContentsChanged(TestStepComboBoxModel.this, stepIndex, stepIndex);
                if (TestStepComboBoxModel.this.selectedStep != null && TestStepComboBoxModel.this.testCase.getIndexOfTestStep(TestStepComboBoxModel.this.selectedStep) == stepIndex) {
                    TestStepComboBoxModel.this.fireContentsChanged(this, -1, -1);
                }
            }
        }
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testStepAdded(TestStep testStep, int index) {
            if (testStep.getTestCase() == TestStepComboBoxModel.this.testCase) {
                TestStepComboBoxModel.this.fireIntervalAdded(TestStepComboBoxModel.this, index, index);
            }
        }

        public void testStepMoved(TestStep testStep, int fromIndex, int offset) {
            if (testStep.getTestCase() == TestStepComboBoxModel.this.testCase) {
                TestStepComboBoxModel.this.fireContentsChanged(TestStepComboBoxModel.this, fromIndex, fromIndex + offset);
            }
        }

        public void testStepRemoved(TestStep testStep, int index) {
            if (testStep.getTestCase() == TestStepComboBoxModel.this.testCase) {
                TestStepComboBoxModel.this.fireIntervalRemoved(TestStepComboBoxModel.this, index, index);
            }
            if (index == TestStepComboBoxModel.this.selectedStepIndex) {
                TestStepComboBoxModel.this.setSelectedItem(null);
            }
        }
    }
}

