/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.PropertyChangeNotifier;
import com.eviware.soapui.support.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPropertiesTable<T>
extends JPanel {
    public static final Object[] BOOLEAN_OPTIONS = new Object[]{Boolean.TRUE, Boolean.FALSE};
    private PropertiesTableModel<T> tableModel;
    private JTable table;
    private TitledBorder titledBorder;
    private String title;

    public JPropertiesTable(String title) {
        this(title, null);
    }

    public JPropertiesTable(String title, T propertyObject) {
        super(new BorderLayout());
        this.title = title;
        this.tableModel = new PropertiesTableModel<T>(propertyObject);
        this.table = new PTable(this.tableModel);
        this.table.getColumnModel().getColumn(0).setHeaderValue("Property");
        this.table.getColumnModel().getColumn(1).setHeaderValue("Value");
        this.table.getColumnModel().getColumn(0).setCellRenderer(new PropertiesTableCellRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new PropertiesTableCellRenderer());
        this.add((Component)new JScrollPane(this.table), "Center");
        this.titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), title);
        this.titledBorder.setTitleFont(this.titledBorder.getTitleFont().deriveFont(0, 11.0f));
        if (title != null) {
            this.setBorder(this.titledBorder);
        }
        this.table.setBackground(Color.WHITE);
        this.setPreferredSize(this.table.getPreferredSize());
    }

    public void setTitle(String title) {
        this.title = title;
        this.titledBorder.setTitle(title);
        this.setBorder(this.titledBorder);
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void removeNotify() {
        this.getTableModel().release();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        this.getTableModel().attach();
        super.addNotify();
    }

    public void setPropertyObject(T propertyObject) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.tableModel.setPropertyObject(propertyObject);
    }

    public PropertiesTableModel<?> getTableModel() {
        return this.tableModel;
    }

    public PropertyDescriptor addProperty(String caption, String name) {
        return this.addProperty(caption, name, false);
    }

    public PropertyDescriptor addProperty(String caption, String name, boolean editable) {
        return this.addProperty(caption, name, editable, null);
    }

    public PropertyDescriptor addProperty(String caption, String name, boolean editable, PropertyFormatter formatter) {
        return this.tableModel.addProperty(caption, name, editable, formatter);
    }

    public PropertyDescriptor addProperty(String caption, String name, Object[] options) {
        return this.tableModel.addProperty(caption, name, options);
    }

    public PropertyDescriptor addPropertyShadow(String caption, String name, boolean editable) {
        return this.tableModel.addPropertyShadow(caption, name, editable);
    }

    private class PTable
    extends JTable {
        public PTable(TableModel tableModel) {
            super(tableModel);
            this.getActionMap().put(TransferHandler.getCopyAction().getValue("Name"), new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    int row = PTable.this.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    StringSelection selection = new StringSelection(PTable.this.getValueAt(row, 1).toString());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
                }
            });
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        }

        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 0) {
                return super.getCellEditor(row, column);
            }
            return JPropertiesTable.this.tableModel.getPropertyDescriptorAt(row).getCellEditor();
        }
    }

    private static class DefaultFormatter
    implements PropertyFormatter {
        private static PropertyFormatter instance;

        private DefaultFormatter() {
        }

        public static PropertyFormatter getInstance() {
            if (instance == null) {
                instance = new DefaultFormatter();
            }
            return instance;
        }

        public Object format(String propertyName, Object value) {
            return value;
        }
    }

    public static interface PropertyFormatter {
        public Object format(String var1, Object var2);
    }

    private static class PropertiesTableCellRenderer
    extends DefaultTableCellRenderer {
        private PropertiesTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DefaultCellEditor cellEditor = (DefaultCellEditor)table.getCellEditor(row, column);
            Component component = cellEditor.getComponent() instanceof JPasswordField && value instanceof String ? (value != null && ((String)value).length() > 0 ? super.getTableCellRendererComponent(table, "**************", isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component instanceof JComponent) {
                PropertyDescriptor descriptor = ((PropertiesTableModel)table.getModel()).getPropertyDescriptorAt(row);
                if (StringUtils.hasContent(descriptor.getDescription())) {
                    ((JComponent)component).setToolTipText(descriptor.getDescription());
                } else if (value != null && StringUtils.hasContent(value.toString()) && !(cellEditor.getComponent() instanceof JPasswordField)) {
                    ((JComponent)component).setToolTipText(value.toString());
                } else {
                    ((JComponent)component).setToolTipText(null);
                }
            }
            return component;
        }
    }

    public static class PropertyDescriptor {
        private final String caption;
        private final String name;
        private boolean editable;
        private PropertyFormatter formatter;
        private Object[] options;
        private DefaultCellEditor cellEditor;
        private String description;

        public PropertyDescriptor(String caption, String name, boolean editable, PropertyFormatter formatter) {
            this.caption = caption;
            this.name = name;
            this.editable = editable;
            this.formatter = formatter;
            JTextField textField = new JTextField();
            textField.setBorder(BorderFactory.createEmptyBorder());
            this.cellEditor = new DefaultCellEditor(textField);
        }

        public PropertyDescriptor(String caption, String name, Object[] options) {
            this.caption = caption;
            this.name = name;
            this.options = options;
            this.editable = true;
            JComboBox<Object> comboBox = new JComboBox<Object>(options);
            if (options.length > 0 && options[0] == null) {
                comboBox.setEditable(true);
                comboBox.removeItemAt(0);
            }
            comboBox.setBorder(null);
            this.cellEditor = new DefaultCellEditor(comboBox);
        }

        public PropertyDescriptor(String caption, String name, boolean editable) {
            this.caption = caption;
            this.name = name;
            this.editable = editable;
            JPasswordField textField = new JPasswordField();
            textField.setBorder(BorderFactory.createEmptyBorder());
            this.cellEditor = new DefaultCellEditor(textField);
        }

        public void setFormatter(PropertyFormatter formatter) {
            this.formatter = formatter;
        }

        public PropertyFormatter getFormatter() {
            return this.formatter == null ? DefaultFormatter.getInstance() : this.formatter;
        }

        public String getCaption() {
            return this.caption;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public Object[] getOptions() {
            return this.options;
        }

        public boolean hasOptions() {
            return this.options != null;
        }

        public String getName() {
            return this.name;
        }

        public TableCellEditor getCellEditor() {
            return this.cellEditor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PropertiesTableModel<T>
    extends AbstractTableModel
    implements PropertyChangeListener {
        private List<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        private T propertyObject;
        private boolean attached;

        public PropertiesTableModel(T propertyObject) {
            this.propertyObject = propertyObject;
        }

        public void attach() {
            if (!this.attached && this.propertyObject instanceof PropertyChangeNotifier) {
                ((PropertyChangeNotifier)this.propertyObject).addPropertyChangeListener(this);
                this.attached = true;
            }
        }

        public void setPropertyObject(T propertyObject) {
            this.release();
            this.propertyObject = propertyObject;
            this.attach();
            this.fireTableDataChanged();
        }

        public PropertyDescriptor addProperty(String caption, String name, boolean editable, PropertyFormatter formatter) {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(caption, name, editable, formatter);
            this.properties.add(propertyDescriptor);
            return propertyDescriptor;
        }

        public PropertyDescriptor addProperty(String caption, String name, Object[] options) {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(caption, name, options);
            this.properties.add(propertyDescriptor);
            return propertyDescriptor;
        }

        @Override
        public int getRowCount() {
            return this.properties.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0 || this.propertyObject == null) {
                return false;
            }
            return this.properties.get(rowIndex).isEditable() && PropertyUtils.isWriteable(this.propertyObject, (String)this.properties.get(rowIndex).getName());
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            try {
                if (this.propertyObject != null && columnIndex == 1 && this.properties.get(rowIndex).isEditable()) {
                    BeanUtils.setProperty(this.propertyObject, (String)this.properties.get(rowIndex).getName(), (Object)aValue);
                }
            }
            catch (IllegalAccessException e) {
                SoapUI.logError(e);
            }
            catch (InvocationTargetException e) {
                SoapUI.logError(e);
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.propertyObject == null) {
                return null;
            }
            try {
                PropertyDescriptor propertyDescriptor = this.properties.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return propertyDescriptor.getCaption();
                    }
                    case 1: {
                        Object value = PropertyUtils.getSimpleProperty(this.propertyObject, (String)propertyDescriptor.getName());
                        return propertyDescriptor.getFormatter().format(propertyDescriptor.getName(), value);
                    }
                }
            }
            catch (IllegalAccessException e) {
                SoapUI.logError(e);
            }
            catch (InvocationTargetException e) {
                SoapUI.logError(e);
            }
            catch (NoSuchMethodException e) {
                SoapUI.logError(e);
            }
            return null;
        }

        public PropertyDescriptor getPropertyDescriptorAt(int row) {
            return this.properties.get(row);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireTableDataChanged();
        }

        public void release() {
            if (this.propertyObject instanceof PropertyChangeNotifier && this.attached) {
                ((PropertyChangeNotifier)this.propertyObject).removePropertyChangeListener(this);
                this.attached = false;
            }
        }

        public PropertyDescriptor addPropertyShadow(String caption, String name, boolean editable) {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(caption, name, editable);
            this.properties.add(propertyDescriptor);
            return propertyDescriptor;
        }
    }
}

