/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.XmlHolder;
import java.io.File;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Node;

public class GroovyUtils {
    protected final PropertyExpansionContext context;

    public GroovyUtils(PropertyExpansionContext context) {
        this.context = context;
    }

    public final String getProjectPath() {
        Project project = ModelSupport.getModelItemProject(this.context.getModelItem());
        String path = project.getPath();
        int ix = path.lastIndexOf(File.separatorChar);
        return ix == -1 ? "" : path.substring(0, ix);
    }

    public final XmlHolder getXmlHolder(String xmlPropertyOrString) throws Exception {
        try {
            return new XmlHolder(XmlObject.Factory.parse((String)xmlPropertyOrString));
        }
        catch (Exception e) {
            return new XmlHolder(this.context, xmlPropertyOrString);
        }
    }

    public final String expand(String property) {
        return PropertyExpander.expandProperties(this.context, property);
    }

    public final void setPropertyValue(String testStep, String property, String value) throws Exception {
        if (!(this.context instanceof TestCaseRunContext)) {
            return;
        }
        TestStep step = ((TestCaseRunContext)this.context).getTestCase().getTestStepByName(testStep);
        if (step == null) {
            throw new Exception("Missing TestStep [" + testStep + "] in TestCase");
        }
        step.setPropertyValue(property, value);
    }

    public final String getXml(Node node) throws XmlException {
        return XmlObject.Factory.parse((Node)node).xmlText();
    }
}

