/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.util;

import com.eviware.soapui.model.ModelItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelItemNames<T extends ModelItem> {
    private List<T> elements;

    public ModelItemNames(List<T> elements) {
        this.elements = new ArrayList<T>(elements);
    }

    public ModelItemNames(T[] elements) {
        this.elements = new ArrayList<T>(Arrays.asList(elements));
    }

    public String[] getNames() {
        ArrayList<String> list = this.getElementNameList();
        return list.toArray(new String[list.size()]);
    }

    private ArrayList<String> getElementNameList() {
        ArrayList<String> elementNames = new ArrayList<String>();
        for (ModelItem element : this.elements) {
            elementNames.add(element.getName());
        }
        return elementNames;
    }

    public T getElement(String name) {
        int index = this.getElementNameList().indexOf(name);
        return (T)((ModelItem)this.elements.get(index));
    }

    public void addElement(T element) {
        this.elements.add(element);
    }

    public int getSize() {
        return this.elements.size();
    }

    public String getNameAt(int i) {
        return ((ModelItem)this.elements.get(i)).getName();
    }
}

