/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.jms;

import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;

public class JMSTimeoutAssertion
extends WsdlMessageAssertion
implements ResponseAssertion,
RequestAssertion {
    public static final String ID = "JMS Timeout";
    public static final String LABEL = "JMS Timeout";

    public JMSTimeoutAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, false, false, false, true);
    }

    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        Boolean temp = (Boolean)context.getProperty("JMS_MESSAGE_RECEIVE");
        Boolean messageReceived = temp != null ? temp : false;
        Long timeout = (Long)context.getProperty("JMS_RECEIVE_TIMEOUT");
        if (messageReceived != null && !messageReceived.booleanValue()) {
            throw new AssertionException(new AssertionError("JMS Message timeout error! Message is not received in " + timeout + " ms."));
        }
        return "JMS Timeout OK";
    }

    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return "JMS Timeout OK";
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super("JMS Timeout", "JMS Timeout", JMSTimeoutAssertion.class, WsdlRequest.class);
        }
    }
}

