/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlObject;

public class SimpleNotContainsAssertion
extends WsdlMessageAssertion
implements RequestAssertion,
ResponseAssertion {
    private String token;
    private boolean ignoreCase;
    private XFormDialog dialog;
    private boolean useRegEx;
    public static final String ID = "Simple NotContains";
    private static final String CONTENT = "Content";
    private static final String IGNORE_CASE = "Ignore Case";
    private static final String USE_REGEX = "Regular Expression";
    public static final String LABEL = "Not Contains";

    public SimpleNotContainsAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, true, true, true, true);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.token = reader.readString("token", null);
        this.ignoreCase = reader.readBoolean("ignoreCase", false);
        this.useRegEx = reader.readBoolean("useRegEx", false);
    }

    public String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return this.assertContent(context, messageExchange.getResponseContent(), "Response");
    }

    private String assertContent(SubmitContext context, String content, String type) throws AssertionException {
        String replToken;
        if (this.token == null) {
            this.token = "";
        }
        if ((replToken = PropertyExpander.expandProperties(context, this.token)).length() > 0) {
            int ix = -1;
            if (this.useRegEx) {
                if (content.matches(replToken)) {
                    ix = 0;
                }
            } else {
                int n = ix = this.ignoreCase ? content.toUpperCase().indexOf(replToken.toUpperCase()) : content.indexOf(replToken);
            }
            if (ix != -1) {
                throw new AssertionException(new AssertionError(type + " contains token [" + replToken + "]"));
            }
        }
        return type + " does not contain token [" + replToken + "]";
    }

    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        StringToStringMap values = new StringToStringMap();
        values.put(CONTENT, this.token);
        values.put(IGNORE_CASE, this.ignoreCase);
        values.put(USE_REGEX, this.useRegEx);
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            this.token = (String)values.get(CONTENT);
            this.ignoreCase = values.getBoolean(IGNORE_CASE);
            this.useRegEx = values.getBoolean(USE_REGEX);
        }
        this.setConfiguration(this.createConfiguration());
        return true;
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("token", this.token);
        builder.add("ignoreCase", this.ignoreCase);
        builder.add("useRegEx", this.useRegEx);
        return builder.finish();
    }

    private void buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("NotContains Assertion");
        XForm mainForm = builder.createForm("Basic");
        mainForm.addTextField(CONTENT, "Content to check for", XForm.FieldType.TEXTAREA).setWidth(40);
        mainForm.addCheckBox(IGNORE_CASE, "Ignore case in comparison");
        mainForm.addCheckBox(USE_REGEX, "Use token as Regular Expression");
        this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("http://www.soapui.org/userguide/functional/response-assertions.html#Simple_NotContains_Assertion"), "Specify options", UISupport.OPTIONS_ICON);
    }

    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return this.assertContent(context, messageExchange.getRequestContent(), "Request");
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.setConfiguration(this.createConfiguration());
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
        this.setConfiguration(this.createConfiguration());
    }

    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<? extends PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this.getAssertable().getModelItem(), this, "token"));
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super(SimpleNotContainsAssertion.ID, SimpleNotContainsAssertion.LABEL, SimpleNotContainsAssertion.class);
        }
    }
}

