/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WsdlTestStepWithProperties
extends WsdlTestStep {
    public static String RESPONSE_AS_XML = "ResponseAsXml";
    private Map<String, TestProperty> properties;
    private List<TestProperty> propertyList = new ArrayList<TestProperty>();
    private Map<String, Set<String>> normalizedPropertyNames = new HashMap<String, Set<String>>();
    private Set<TestPropertyListener> listeners = new HashSet<TestPropertyListener>();

    protected WsdlTestStepWithProperties(WsdlTestCase testCase, TestStepConfig config, boolean hasEditor, boolean forLoadTest) {
        super(testCase, config, hasEditor, forLoadTest);
    }

    @Override
    public String[] getPropertyNames() {
        if (this.properties == null) {
            return new String[0];
        }
        String[] result = new String[this.properties.size()];
        int ix = 0;
        for (TestProperty property : this.properties.values()) {
            result[ix++] = property.getName();
        }
        return result;
    }

    @Override
    public TestProperty getProperty(String name) {
        return this.properties == null || name == null ? null : this.properties.get(this.getPropertyKeyName(name));
    }

    @Override
    public String getPropertyValue(String name) {
        if (this.properties == null) {
            return null;
        }
        TestProperty testStepProperty = this.properties.get(this.getPropertyKeyName(name));
        return testStepProperty == null ? null : testStepProperty.getValue();
    }

    @Override
    public void setPropertyValue(String name, String value) {
        if (this.properties == null) {
            return;
        }
        TestProperty testStepProperty = this.properties.get(this.getPropertyKeyName(name));
        if (testStepProperty != null) {
            testStepProperty.setValue(value);
        }
    }

    protected void addProperty(TestProperty property) {
        this.addProperty(property, false);
    }

    protected void addProperty(TestProperty property, boolean notify) {
        String name;
        String upper;
        if (this.properties == null) {
            this.properties = new HashMap<String, TestProperty>();
        }
        if (!this.normalizedPropertyNames.containsKey(upper = (name = property.getName()).toUpperCase())) {
            this.normalizedPropertyNames.put(upper, new HashSet());
        }
        this.normalizedPropertyNames.get(upper).add(name);
        this.properties.put(name, property);
        this.propertyList.add(property);
        if (notify) {
            this.firePropertyAdded(name);
        }
    }

    private String getPropertyKeyName(String name) {
        if (this.properties.containsKey(name)) {
            return name;
        }
        Set<String> props = this.normalizedPropertyNames.get(name.toUpperCase());
        if (props != null && !props.isEmpty()) {
            return props.iterator().next();
        }
        return name;
    }

    protected TestProperty deleteProperty(String name, boolean notify) {
        TestProperty result;
        if (this.properties != null && (result = this.properties.remove(name = this.getPropertyKeyName(name))) != null) {
            this.normalizedPropertyNames.get(name.toUpperCase()).remove(name);
            this.propertyList.remove(result);
            if (notify) {
                this.firePropertyRemoved(name);
            }
            return result;
        }
        return null;
    }

    public void propertyRenamed(String oldName) {
        if (this.properties == null) {
            return;
        }
        oldName = this.getPropertyKeyName(oldName);
        String upper = oldName.toUpperCase();
        TestProperty testStepProperty = this.properties.get(oldName);
        if (testStepProperty == null) {
            return;
        }
        Set<String> props = this.normalizedPropertyNames.get(upper);
        this.properties.remove(oldName);
        props.remove(oldName);
        String newName = testStepProperty.getName();
        this.properties.put(newName, testStepProperty);
        upper = newName.toUpperCase();
        if (!this.normalizedPropertyNames.containsKey(upper)) {
            this.normalizedPropertyNames.put(upper, new HashSet());
        }
        this.normalizedPropertyNames.get(upper).add(newName);
        this.firePropertyRenamed(oldName, newName);
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePropertyAdded(String name) {
        TestPropertyListener[] array;
        for (TestPropertyListener listener : array = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyAdded(name);
        }
    }

    protected void firePropertyRemoved(String name) {
        TestPropertyListener[] array;
        for (TestPropertyListener listener : array = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRemoved(name);
        }
    }

    protected void firePropertyRenamed(String oldName, String newName) {
        TestPropertyListener[] array;
        for (TestPropertyListener listener : array = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRenamed(oldName, newName);
        }
    }

    public void firePropertyValueChanged(String name, String oldValue, String newValue) {
        TestPropertyListener[] array;
        if (oldValue == null && newValue == null) {
            return;
        }
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        for (TestPropertyListener listener : array = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyValueChanged(name, oldValue, newValue);
        }
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        HashMap<String, TestProperty> result = new HashMap<String, TestProperty>();
        if (this.properties != null) {
            for (String name : this.properties.keySet()) {
                result.put(this.properties.get(name).getName(), this.properties.get(name));
            }
        }
        return result;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties != null && this.properties.containsKey(this.getPropertyKeyName(name));
    }

    public boolean hasProperties() {
        return true;
    }

    @Override
    public TestProperty getPropertyAt(int index) {
        return this.propertyList.get(index);
    }

    @Override
    public int getPropertyCount() {
        return this.propertyList.size();
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return Collections.unmodifiableList(this.propertyList);
    }

    protected void firePropertyMoved(String name, int oldIndex, int newIndex) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyMoved(name, oldIndex, newIndex);
        }
    }

    public void moveProperty(String propertyName, int targetIndex) {
        TestProperty property = this.getProperty(propertyName);
        int ix = this.propertyList.indexOf(property);
        if (ix == targetIndex) {
            return;
        }
        if (targetIndex < 0) {
            targetIndex = 0;
        }
        if (targetIndex < this.properties.size()) {
            this.propertyList.add(targetIndex, this.propertyList.remove(ix));
        } else {
            this.propertyList.add(this.propertyList.remove(ix));
        }
        if (targetIndex > this.properties.size()) {
            targetIndex = this.properties.size();
        }
        this.firePropertyMoved(propertyName, ix, targetIndex);
    }
}

