/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.support;

import com.eviware.soapui.impl.wsdl.support.wss.IncomingWss;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainerListener;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.WssEntry;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class KeystoresComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
WssContainerListener {
    private List<WssCrypto> cryptos = new ArrayList<WssCrypto>();
    private WssCrypto selectedCrypto;
    private final WssContainer container;

    public KeystoresComboBoxModel(WssContainer container, WssCrypto selectedCrypto) {
        this.container = container;
        this.selectedCrypto = selectedCrypto;
        this.cryptos.addAll(container.getCryptoList());
        container.addWssContainerListener(this);
    }

    public String getSelectedItem() {
        return this.selectedCrypto == null ? null : this.selectedCrypto.getLabel();
    }

    public void setSelectedItem(Object anItem) {
        this.selectedCrypto = null;
        for (WssCrypto crypto : this.cryptos) {
            if (!crypto.getLabel().equals(anItem)) continue;
            this.selectedCrypto = crypto;
        }
    }

    public Object getElementAt(int index) {
        return this.cryptos.get(index).getLabel();
    }

    public int getSize() {
        return this.cryptos == null ? 0 : this.cryptos.size();
    }

    public void cryptoAdded(WssCrypto crypto) {
        this.cryptos.add(crypto);
        this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
    }

    public void cryptoRemoved(WssCrypto crypto) {
        int index = this.cryptos.indexOf(crypto);
        this.cryptos.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void incomingWssAdded(IncomingWss incomingWss) {
    }

    public void incomingWssRemoved(IncomingWss incomingWss) {
    }

    public void outgoingWssAdded(OutgoingWss outgoingWss) {
    }

    public void outgoingWssEntryAdded(WssEntry entry) {
    }

    public void outgoingWssEntryRemoved(WssEntry entry) {
    }

    public void outgoingWssRemoved(OutgoingWss outgoingWss) {
    }

    public void cryptoUpdated(WssCrypto crypto) {
    }

    public void release() {
        this.container.removeWssContainerListener(this);
        this.cryptos = null;
        this.selectedCrypto = null;
    }
}

