/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.entries;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.WSSEntryConfig;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.entries.WssContainerListenerAdapter;
import com.eviware.soapui.impl.wsdl.support.wss.entries.WssEntryBase;
import com.eviware.soapui.impl.wsdl.support.wss.support.KeystoresComboBoxModel;
import com.eviware.soapui.impl.wsdl.support.wss.support.WSPartsTable;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.soapui.support.xml.XmlUtils;
import com.jgoodies.binding.PresentationModel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.w3c.dom.Document;

public class AddSignatureEntry
extends WssEntryBase {
    private static final String DEFAULT_OPTION = "<default>";
    public static final String TYPE = "Signature";
    private String crypto;
    private int keyIdentifierType = 0;
    private String signatureAlgorithm;
    private boolean useSingleCert;
    private String signatureCanonicalization;
    private List<StringToStringMap> parts = new ArrayList<StringToStringMap>();
    private WssEntryBase.KeyAliasComboBoxModel keyAliasComboBoxModel;
    private InternalWssContainerListener wssContainerListener;

    public void init(WSSEntryConfig config, OutgoingWss container) {
        super.init(config, container, TYPE);
    }

    protected JComponent buildUI() {
        SimpleBindingForm form = new SimpleBindingForm(new PresentationModel((Object)this));
        form.addSpace(5);
        this.wssContainerListener = new InternalWssContainerListener();
        this.getWssContainer().addWssContainerListener(this.wssContainerListener);
        form.appendComboBox("crypto", "Keystore", new KeystoresComboBoxModel(this.getWssContainer(), this.getWssContainer().getCryptoByName(this.crypto)), "Selects the Keystore containing the key to use for signing").addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AddSignatureEntry.this.keyAliasComboBoxModel.update(AddSignatureEntry.this.getWssContainer().getCryptoByName(AddSignatureEntry.this.crypto));
            }
        });
        this.keyAliasComboBoxModel = new WssEntryBase.KeyAliasComboBoxModel(this, this.getWssContainer().getCryptoByName(this.crypto));
        form.appendComboBox("username", "Alias", this.keyAliasComboBoxModel, "The alias for the key to use for encryption");
        form.appendPasswordField("password", "Password", "The certificate password");
        form.appendComboBox("keyIdentifierType", "Key Identifier Type", new Integer[]{0, 1, 2, 3, 4}, "Sets which key identifier to use").setRenderer(new WssEntryBase.KeyIdentifierTypeRenderer(this));
        form.appendComboBox("signatureAlgorithm", "Signature Algorithm", new String[]{DEFAULT_OPTION, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/2000/09/xmldsig#hmac-sha1", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512", "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160", "http://www.w3.org/2001/04/xmldsig-more#hmac-md5", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#rsa-md5", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160"}, "Set the name of the signature encryption algorithm to use");
        form.appendComboBox("signatureCanonicalization", "Signature Canonicalization", new String[]{DEFAULT_OPTION, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "http://www.w3.org/2001/10/xml-exc-c14n#", "http://www.w3.org/2001/10/xml-exc-c14n#WithComments"}, "Set the canonicalization method to use.");
        form.appendCheckBox("useSingleCert", "Use Single Certificate", "Use single certificate for signing");
        form.append("Parts", new WSPartsTable(this.parts, this));
        return new JScrollPane(form.getPanel());
    }

    public void release() {
        if (this.wssContainerListener != null) {
            this.getWssContainer().removeWssContainerListener(this.wssContainerListener);
        }
    }

    protected void load(XmlObjectConfigurationReader reader) {
        this.crypto = reader.readString("crypto", null);
        this.keyIdentifierType = reader.readInt("keyIdentifierType", 0);
        this.signatureAlgorithm = reader.readString("signatureAlgorithm", null);
        this.signatureCanonicalization = reader.readString("signatureCanonicalization", null);
        this.useSingleCert = reader.readBoolean("useSingleCert", false);
        this.parts = this.readParts(reader, "signaturePart");
    }

    protected void save(XmlObjectConfigurationBuilder builder) {
        builder.add("crypto", this.crypto);
        builder.add("keyIdentifierType", this.keyIdentifierType);
        builder.add("signatureAlgorithm", this.signatureAlgorithm);
        builder.add("signatureCanonicalization", this.signatureCanonicalization);
        builder.add("useSingleCert", this.useSingleCert);
        this.saveParts(builder, this.parts, "signaturePart");
    }

    public void process(WSSecHeader secHeader, Document doc, PropertyExpansionContext context) {
        block9: {
            StringWriter writer = null;
            try {
                WssCrypto wssCrypto = this.getWssContainer().getCryptoByName(this.crypto);
                if (wssCrypto == null) {
                    throw new Exception("Missing crypto [" + this.crypto + "] for signature entry");
                }
                WSSecSignature wssSign = new WSSecSignature();
                wssSign.setUserInfo(context.expand(this.getUsername()), context.expand(this.getPassword()));
                if (this.keyIdentifierType != 0) {
                    wssSign.setKeyIdentifierType(this.keyIdentifierType);
                }
                if (StringUtils.hasContent(this.signatureAlgorithm)) {
                    wssSign.setSignatureAlgorithm(this.signatureAlgorithm);
                }
                if (StringUtils.hasContent(this.signatureCanonicalization)) {
                    wssSign.setSigCanonicalization(this.signatureCanonicalization);
                }
                wssSign.setUseSingleCertificate(this.useSingleCert);
                Vector<WSEncryptionPart> wsParts = this.createWSParts(this.parts);
                if (!wsParts.isEmpty()) {
                    wssSign.setParts(wsParts);
                }
                writer = new StringWriter();
                XmlUtils.serialize(doc, (Writer)writer);
                wssSign.build(doc, wssCrypto.getCrypto(), secHeader);
            }
            catch (Exception e) {
                SoapUI.logError(e);
                if (writer == null || writer.getBuffer().length() <= 0) break block9;
                try {
                    doc.replaceChild(doc.importNode(XmlUtils.parseXml(writer.toString()).getDocumentElement(), true), doc.getDocumentElement());
                }
                catch (Exception e1) {
                    SoapUI.logError(e1);
                }
            }
        }
    }

    protected void addPropertyExpansions(PropertyExpansionsResult result) {
        super.addPropertyExpansions(result);
    }

    public String getCrypto() {
        return this.crypto;
    }

    public void setCrypto(String crypto) {
        this.crypto = crypto;
        this.saveConfig();
    }

    public int getKeyIdentifierType() {
        return this.keyIdentifierType;
    }

    public void setKeyIdentifierType(int keyIdentifierType) {
        this.keyIdentifierType = keyIdentifierType;
        this.saveConfig();
    }

    public String getSignatureAlgorithm() {
        return StringUtils.isNullOrEmpty(this.signatureAlgorithm) ? DEFAULT_OPTION : this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        if (DEFAULT_OPTION.equals(signatureAlgorithm)) {
            signatureAlgorithm = null;
        }
        this.signatureAlgorithm = signatureAlgorithm;
        this.saveConfig();
    }

    public String getSignatureCanonicalization() {
        return StringUtils.isNullOrEmpty(this.signatureCanonicalization) ? DEFAULT_OPTION : this.signatureCanonicalization;
    }

    public void setSignatureCanonicalization(String signatureCanonicalization) {
        if (DEFAULT_OPTION.equals(signatureCanonicalization)) {
            signatureCanonicalization = null;
        }
        this.signatureCanonicalization = signatureCanonicalization;
        this.saveConfig();
    }

    public boolean isUseSingleCert() {
        return this.useSingleCert;
    }

    public void setUseSingleCert(boolean useSingleCert) {
        this.useSingleCert = useSingleCert;
        this.saveConfig();
    }

    private final class InternalWssContainerListener
    extends WssContainerListenerAdapter {
        private InternalWssContainerListener() {
        }

        public void cryptoUpdated(WssCrypto crypto) {
            if (crypto.getLabel().equals(AddSignatureEntry.this.getCrypto())) {
                AddSignatureEntry.this.keyAliasComboBoxModel.update(crypto);
            }
        }
    }
}

