/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.soap;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.soap.AbstractSoapVersion;
import com.eviware.soapui.support.StringUtils;
import java.io.IOException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3.x2003.x05.soapEnvelope.EnvelopeDocument;
import org.w3.x2003.x05.soapEnvelope.FaultDocument;

public class SoapVersion12
extends AbstractSoapVersion {
    private static final QName envelopeQName = new QName("http://www.w3.org/2003/05/soap-envelope", "Envelope");
    private static final QName bodyQName = new QName("http://www.w3.org/2003/05/soap-envelope", "Body");
    private static final QName faultQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
    private static final QName headerQName = new QName("http://www.w3.org/2003/05/soap-envelope", "Header");
    public static final SoapVersion12 instance = new SoapVersion12();
    private SchemaTypeLoader soapSchema;
    private XmlObject soapSchemaXml;
    private XmlObject soapEncodingXml;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SoapVersion12() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SoapUI.class.getClassLoader());
        try {
            this.soapSchemaXml = XmlObject.Factory.parse((URL)SoapUI.class.getResource("/com/eviware/soapui/resources/xsds/soapEnvelope12.xsd"));
            this.soapSchema = XmlBeans.loadXsd((XmlObject[])new XmlObject[]{this.soapSchemaXml});
            this.soapEncodingXml = XmlObject.Factory.parse((URL)SoapUI.class.getResource("/com/eviware/soapui/resources/xsds/soapEncoding12.xsd"));
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public String getEncodingNamespace() {
        return "http://www.w3.org/2003/05/soap-encoding";
    }

    public XmlObject getSoapEncodingSchema() throws XmlException, IOException {
        return this.soapEncodingXml;
    }

    public XmlObject getSoapEnvelopeSchema() throws XmlException, IOException {
        return this.soapSchemaXml;
    }

    public String getEnvelopeNamespace() {
        return "http://www.w3.org/2003/05/soap-envelope";
    }

    public SchemaType getEnvelopeType() {
        return EnvelopeDocument.type;
    }

    public String toString() {
        return "SOAP 1.2";
    }

    public String getContentTypeHttpHeader(String encoding, String soapAction) {
        String result = this.getContentType();
        if (encoding != null && encoding.trim().length() > 0) {
            result = result + ";charset=" + encoding;
        }
        if (StringUtils.hasContent(soapAction)) {
            result = result + ";action=" + StringUtils.quote(soapAction);
        }
        return result;
    }

    public String getSoapActionHeader(String soapAction) {
        return null;
    }

    public String getContentType() {
        return "application/soap+xml";
    }

    public QName getBodyQName() {
        return bodyQName;
    }

    public QName getEnvelopeQName() {
        return envelopeQName;
    }

    public QName getHeaderQName() {
        return headerQName;
    }

    protected SchemaTypeLoader getSoapEnvelopeSchemaLoader() {
        return this.soapSchema;
    }

    public static QName getFaultQName() {
        return faultQName;
    }

    public SchemaType getFaultType() {
        return FaultDocument.type;
    }

    public String getName() {
        return "SOAP 1.2";
    }

    public String getFaultDetailNamespace() {
        return this.getEnvelopeNamespace();
    }
}

