/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.StringUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocket;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.ssl.KeyMaterial;

public class SoapUIEasySSLProtocolSocketFactory
extends EasySSLProtocolSocketFactory {
    private Map<String, EasySSLProtocolSocketFactory> factoryMap = new HashMap<String, EasySSLProtocolSocketFactory>();

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException {
        String sslConfig = (String)params.getParameter("soapui.sslConfig");
        if (StringUtils.isNullOrEmpty(sslConfig)) {
            return this.enableSocket((SSLSocket)super.createSocket(host, port, localAddress, localPort, params));
        }
        EasySSLProtocolSocketFactory factory = this.factoryMap.get(sslConfig);
        if (factory != null) {
            return this.enableSocket((SSLSocket)factory.createSocket(host, port, localAddress, localPort, params));
        }
        try {
            factory = new EasySSLProtocolSocketFactory();
            int ix = sslConfig.lastIndexOf(32);
            String keyStore = sslConfig.substring(0, ix);
            String pwd = sslConfig.substring(ix + 1);
            factory.setKeyMaterial(new KeyMaterial(keyStore, pwd.toCharArray()));
            this.factoryMap.put(sslConfig, factory);
            return this.enableSocket((SSLSocket)factory.createSocket(host, port, localAddress, localPort, params));
        }
        catch (Exception gse) {
            SoapUI.logError(gse);
            return this.enableSocket((SSLSocket)super.createSocket(host, port, localAddress, localPort, params));
        }
    }

    private Socket enableSocket(SSLSocket socket) {
        socket.setEnabledProtocols(socket.getSupportedProtocols());
        socket.setEnabledCipherSuites(socket.getSupportedCipherSuites());
        return socket;
    }
}

