/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.http.SoapUIEasySSLProtocolSocketFactory;
import com.eviware.soapui.impl.wsdl.support.http.SoapUIMultiThreadedHttpConnectionManager;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.settings.SSLSettings;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.log4j.Logger;

public class HttpClientSupport {
    private static final Helper helper = new Helper();

    public static HttpClient getHttpClient() {
        return helper.getHttpClient();
    }

    public static void applyHttpSettings(HttpMethod httpMethod, Settings settings) {
        String userAgent = settings.getString(HttpSettings.USER_AGENT, null);
        if (userAgent != null && userAgent.length() > 0) {
            httpMethod.setRequestHeader("User-Agent", userAgent);
        }
        long timeout = settings.getLong(HttpSettings.SOCKET_TIMEOUT, 60000L);
        httpMethod.getParams().setSoTimeout((int)timeout);
    }

    public static String getResponseCompressionType(HttpMethod method) {
        String compressionAlg;
        Header contentType = method.getResponseHeader("Content-Type");
        Header contentEncoding = method.getResponseHeader("Content-Encoding");
        String string = compressionAlg = contentType == null ? null : CompressionSupport.getAvailableAlgorithm(contentType.getValue());
        if (compressionAlg != null) {
            return compressionAlg;
        }
        if (contentEncoding == null) {
            return null;
        }
        return CompressionSupport.getAvailableAlgorithm(contentEncoding.getValue());
    }

    private static class Helper {
        private HttpClient httpClient;
        private static final Logger log = Logger.getLogger(Helper.class);
        private SoapUIEasySSLProtocolSocketFactory easySSL;
        private SoapUIMultiThreadedHttpConnectionManager connectionManager;

        public Helper() {
            try {
                this.easySSL = new SoapUIEasySSLProtocolSocketFactory();
                this.initSSL(this.easySSL);
                Protocol easyhttps = new Protocol("https", (ProtocolSocketFactory)this.easySSL, 443);
                Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
            Settings settings = SoapUI.getSettings();
            this.connectionManager = new SoapUIMultiThreadedHttpConnectionManager();
            this.connectionManager.getParams().setDefaultMaxConnectionsPerHost((int)settings.getLong(HttpSettings.MAX_CONNECTIONS_PER_HOST, 500L));
            this.connectionManager.getParams().setMaxTotalConnections((int)settings.getLong(HttpSettings.MAX_TOTAL_CONNECTIONS, 2000L));
            this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
            settings.addSettingsListener(new SettingsListener(){

                public void settingChanged(String name, String newValue, String oldValue) {
                    if (newValue == null) {
                        return;
                    }
                    if (name.equals(SSLSettings.KEYSTORE) || name.equals(SSLSettings.KEYSTORE_PASSWORD)) {
                        try {
                            log.info((Object)"Updating keyStore..");
                            Helper.this.initKeyMaterial(Helper.this.easySSL);
                        }
                        catch (Throwable e) {
                            SoapUI.logError(e);
                        }
                    } else if (name.equals(HttpSettings.MAX_CONNECTIONS_PER_HOST)) {
                        log.info((Object)("Updating max connections per host to " + newValue));
                        Helper.this.connectionManager.getParams().setDefaultMaxConnectionsPerHost(Integer.parseInt(newValue));
                    } else if (name.equals(HttpSettings.MAX_TOTAL_CONNECTIONS)) {
                        log.info((Object)("Updating max total connections host to " + newValue));
                        Helper.this.connectionManager.getParams().setMaxTotalConnections(Integer.parseInt(newValue));
                    }
                }
            });
        }

        private void initSSL(EasySSLProtocolSocketFactory easySSL) throws IOException, GeneralSecurityException {
            this.initKeyMaterial(easySSL);
        }

        private void initKeyMaterial(EasySSLProtocolSocketFactory easySSL) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, CertificateException {
            Settings settings = SoapUI.getSettings();
            String keyStore = settings.getString(SSLSettings.KEYSTORE, null);
            keyStore = keyStore != null ? keyStore.trim() : "";
            String pass = settings.getString(SSLSettings.KEYSTORE_PASSWORD, "");
            char[] pwd = pass.toCharArray();
            if (!"".equals(keyStore)) {
                log.info((Object)"Initializing KeyStore");
                File f = new File(keyStore);
                if (f.exists()) {
                    KeyMaterial km = null;
                    try {
                        km = new KeyMaterial(keyStore, pwd);
                        log.info((Object)("Set KeyMaterial from file [" + keyStore + "]"));
                    }
                    catch (GeneralSecurityException gse) {
                        SoapUI.logError(gse);
                    }
                    if (km != null) {
                        easySSL.setKeyMaterial(km);
                    }
                }
            } else {
                easySSL.setKeyMaterial(null);
            }
        }

        public HttpClient getHttpClient() {
            return this.httpClient;
        }
    }
}

