/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.support.AbstractAnimatableModelItem;
import com.eviware.soapui.support.UISupport;
import java.util.concurrent.Future;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelItemIconAnimator<T extends AbstractAnimatableModelItem<?>>
implements Runnable {
    private final T target;
    private int index = 0;
    private boolean stopped = true;
    private boolean enabled = true;
    private ImageIcon baseIcon;
    private ImageIcon[] animateIcons;
    private Future<?> future;

    public ModelItemIconAnimator(T target, String baseIcon, String animationBaseIcon, int num, String type) {
        this.target = target;
        this.baseIcon = UISupport.createImageIcon(baseIcon);
        this.animateIcons = new ImageIcon[num];
        for (int c = 0; c < this.animateIcons.length; ++c) {
            this.animateIcons[c] = UISupport.createImageIcon(animationBaseIcon + "_" + (c + 1) + "." + type);
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void start() {
        if (!this.enabled || this.future != null) {
            return;
        }
        this.stopped = false;
        this.future = SoapUI.getThreadPool().submit(this);
    }

    public ImageIcon getBaseIcon() {
        return this.baseIcon;
    }

    public ImageIcon getIcon() {
        if (!this.isStopped()) {
            return this.animateIcons[this.getIndex()];
        }
        return this.baseIcon;
    }

    @Override
    public void run() {
        if (this.future != null && System.getProperty("soapui.enablenamedthreads") != null) {
            Thread.currentThread().setName("ModelItemIconAnimator for " + this.target.getName());
        }
        while (!this.stopped) {
            try {
                if (this.stopped) break;
                this.index = this.index >= this.animateIcons.length - 1 ? 0 : this.index + 1;
                ((AbstractAnimatableModelItem)this.target).setIcon(this.getIcon());
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                SoapUI.logError(e);
            }
        }
        ((AbstractAnimatableModelItem)this.target).setIcon(this.getIcon());
        this.future = null;
    }

    public T getTarget() {
        return this.target;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!this.stopped) {
            this.stopped = enabled;
        }
    }
}

