/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.CompressedStringConfig;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.Tools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class CompressedStringSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(CompressedStringConfig compressedStringConfig) {
        CompressedStringConfig compressedStringConfig2 = compressedStringConfig;
        synchronized (compressedStringConfig2) {
            String compression = compressedStringConfig.getCompression();
            if ("gzip".equals(compression)) {
                try {
                    BASE64Decoder decoder = new BASE64Decoder();
                    byte[] bytes = decoder.decodeBuffer(compressedStringConfig.getStringValue());
                    GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));
                    return Tools.readAll(in, -1L).toString();
                }
                catch (IOException e) {
                    SoapUI.logError(e);
                }
            }
            return compressedStringConfig.getStringValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setString(CompressedStringConfig compressedStringConfig, String value) {
        CompressedStringConfig compressedStringConfig2 = compressedStringConfig;
        synchronized (compressedStringConfig2) {
            long limit = SoapUI.getSettings().getLong(WsdlSettings.COMPRESSION_LIMIT, 0L);
            if (limit > 0L && (long)value.length() >= limit) {
                try {
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    GZIPOutputStream out = new GZIPOutputStream(byteOut);
                    out.write(value.getBytes());
                    out.finish();
                    BASE64Encoder encoder = new BASE64Encoder();
                    value = encoder.encode(byteOut.toByteArray());
                    compressedStringConfig.setCompression("gzip");
                }
                catch (IOException e) {
                    SoapUI.logError(e);
                    compressedStringConfig.unsetCompression();
                }
            } else if (compressedStringConfig.isSetCompression()) {
                compressedStringConfig.unsetCompression();
            }
            compressedStringConfig.setStringValue(value);
        }
    }
}

