/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.support;

import com.eviware.soapui.StandaloneSoapUICore;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.xml.JXEditTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.Document;

public class LineNumbersPanel
extends JPanel {
    private JXEditTextArea editArea;
    private JTable lineNumberTable;

    public LineNumbersPanel(JXEditTextArea editArea) {
        super(new BorderLayout());
        this.editArea = editArea;
        this.lineNumberTable = new JTable(new LineNumberTableModel());
        this.lineNumberTable.setBackground(StandaloneSoapUICore.SoapUITheme.BACKGROUND_COLOR);
        this.lineNumberTable.setRowHeight(editArea.getLineHeight());
        this.lineNumberTable.getColumnModel().getColumn(0).setWidth(30);
        this.lineNumberTable.setPreferredSize(new Dimension(30, 0));
        this.lineNumberTable.setSelectionMode(0);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(2, 2, 0, 1)));
        this.add((Component)this.lineNumberTable, "Center");
        this.lineNumberTable.getColumnModel().getColumn(0).setCellRenderer(new LineNumberCellRenderer());
        this.lineNumberTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int row = LineNumbersPanel.this.lineNumberTable.getSelectedRow();
                if (row != -1) {
                    LineNumbersPanel.this.editArea.setCaretPosition(LineNumbersPanel.this.editArea.getLineStartOffset(row));
                    LineNumbersPanel.this.editArea.requestFocusInWindow();
                }
            }
        });
    }

    private class LineNumberTableModel
    extends AbstractTableModel {
        private int lastLineCount;

        public LineNumberTableModel() {
            LineNumbersPanel.this.editArea.getDocument().addDocumentListener(new DocumentListenerAdapter(){

                public void update(Document document) {
                    if (LineNumberTableModel.this.lastLineCount != LineNumbersPanel.this.editArea.getLineCount()) {
                        LineNumberTableModel.this.fireTableDataChanged();
                    }
                }
            });
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            this.lastLineCount = LineNumbersPanel.this.editArea.getLineCount();
            return this.lastLineCount;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return String.valueOf(rowIndex + 1);
        }
    }

    private class LineNumberCellRenderer
    extends DefaultTableCellRenderer {
        public LineNumberCellRenderer() {
            this.setForeground(Color.DARK_GRAY);
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setValue(value);
            return this;
        }
    }
}

