/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.support;

import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTableModel;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringList;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertyTableHolderModel
extends AbstractTableModel
implements PropertyHolderTableModel {
    private StringList names = new StringList();
    private final TestPropertyHolder holder;

    public DefaultPropertyTableHolderModel(TestPropertyHolder holder) {
        this.holder = holder;
        this.names = new StringList(this.getPropertyNames());
    }

    public String[] getPropertyNames() {
        return this.holder.getPropertyNames();
    }

    @Override
    public int getRowCount() {
        return this.names.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public void fireTableDataChanged() {
        this.names = new StringList(this.getPropertyNames());
        super.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Value";
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.holder instanceof MutableTestPropertyHolder;
        }
        return !this.holder.getProperty((String)this.names.get(rowIndex)).isReadOnly();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        TestProperty property = this.holder.getProperty((String)this.names.get(rowIndex));
        switch (columnIndex) {
            case 0: {
                if (!(this.holder instanceof MutableTestPropertyHolder)) break;
                TestProperty prop = this.holder.getProperty(aValue.toString());
                if (prop != null && prop != property) {
                    UISupport.showErrorMessage("Property name exists!");
                    return;
                }
                ((MutableTestPropertyHolder)this.holder).renameProperty(property.getName(), aValue.toString());
                break;
            }
            case 1: {
                property.setValue(aValue.toString());
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public TestProperty getPropertyAtRow(int rowIndex) {
        return this.holder.getProperty((String)this.names.get(rowIndex));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TestProperty property = this.holder.getProperty((String)this.names.get(rowIndex));
        if (property == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return property.getName();
            }
            case 1: {
                return property.getValue();
            }
        }
        return null;
    }
}

