/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.support.TestRunComponentEnabler;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GotoTestStepsComboBoxModel;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlGotoTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.SamplerTestStep;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.log.JLogList;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GotoStepDesktopPanel
extends ModelItemDesktopPanel<WsdlGotoTestStep> {
    private final WsdlGotoTestStep gotoStep;
    private DefaultListModel listModel;
    private JList conditionList;
    private JTextArea expressionArea;
    private JButton copyButton;
    private JButton deleteButton;
    private JButton declareButton;
    private GotoTestStepsComboBoxModel testStepsModel;
    private JComboBox testStepsCombo;
    private JButton testConditionButton;
    private TestRunComponentEnabler componentEnabler;
    private WsdlGotoTestStep.GotoCondition currentCondition;
    private JButton renameButton;
    private JButton runButton;
    private JButton addButton;
    private JLogList logList;
    private InternalTestRunListener testRunListener = new InternalTestRunListener();
    private JInspectorPanel inspectorPanel;

    public GotoStepDesktopPanel(WsdlGotoTestStep testStep) {
        super(testStep);
        this.gotoStep = testStep;
        this.componentEnabler = new TestRunComponentEnabler(testStep.getTestCase());
        this.gotoStep.getTestCase().addTestRunListener(this.testRunListener);
        this.buildUI();
    }

    public TestRunComponentEnabler getComponentEnabler() {
        return this.componentEnabler;
    }

    public JList getConditionList() {
        return this.conditionList;
    }

    public JButton getCopyButton() {
        return this.copyButton;
    }

    public JButton getDeclareButton() {
        return this.declareButton;
    }

    public JButton getDeleteButton() {
        return this.deleteButton;
    }

    public JTextArea getExpressionArea() {
        return this.expressionArea;
    }

    public WsdlGotoTestStep getGotoStep() {
        return this.gotoStep;
    }

    public DefaultListModel getListModel() {
        return this.listModel;
    }

    public JButton getTestConditionButton() {
        return this.testConditionButton;
    }

    public JComboBox getTestStepsCombo() {
        return this.testStepsCombo;
    }

    public GotoTestStepsComboBoxModel getTestStepsModel() {
        return this.testStepsModel;
    }

    private void buildUI() {
        JSplitPane splitPane = UISupport.createHorizontalSplit();
        splitPane.setLeftComponent(this.buildConditionList());
        splitPane.setRightComponent(this.buildExpressionArea());
        splitPane.setResizeWeight(0.1);
        splitPane.setDividerLocation(120);
        this.inspectorPanel = JInspectorPanelFactory.build(splitPane);
        this.inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildLog(), "Log", "A log of evaluated conditions", true));
        this.add((Component)this.inspectorPanel.getComponent(), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setPreferredSize(new Dimension(550, 300));
        if (this.listModel.getSize() > 0) {
            this.conditionList.setSelectedIndex(0);
        }
        this.componentEnabler.add(this.conditionList);
        this.componentEnabler.add(this.expressionArea);
        this.componentEnabler.add(this.testStepsCombo);
        this.componentEnabler.add(this.testConditionButton);
        this.componentEnabler.add(this.copyButton);
        this.componentEnabler.add(this.declareButton);
        this.componentEnabler.add(this.deleteButton);
        this.componentEnabler.add(this.addButton);
        this.componentEnabler.add(this.runButton);
        this.componentEnabler.add(this.renameButton);
    }

    private JComponent buildLog() {
        this.logList = new JLogList("Condition Log for [" + ((WsdlGotoTestStep)this.getModelItem()).getName() + "]");
        return this.logList;
    }

    private JPanel buildExpressionArea() {
        this.expressionArea = new JUndoableTextArea();
        this.expressionArea.setEnabled(false);
        this.expressionArea.getDocument().addDocumentListener(new SourceAreaDocumentListener());
        JPanel expressionPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.expressionArea);
        UISupport.addTitledBorder(scrollPane, "Condition XPath Expression");
        expressionPanel.add((Component)scrollPane, "Center");
        expressionPanel.add(this.buildConditionToolbar(), "North");
        expressionPanel.add((Component)this.buildTargetToolbar(), "South");
        return expressionPanel;
    }

    private JPanel buildConditionList() {
        this.listModel = new DefaultListModel();
        for (int c = 0; c < this.gotoStep.getConditionCount(); ++c) {
            this.listModel.addElement(this.gotoStep.getConditionAt(c).getName());
        }
        this.conditionList = new JList(this.listModel);
        this.conditionList.setSelectionMode(0);
        this.conditionList.addListSelectionListener(new ConditionListSelectionListener());
        JScrollPane listScrollPane = new JScrollPane(this.conditionList);
        UISupport.addTitledBorder(listScrollPane, "Conditions");
        JPanel p = new JPanel(new BorderLayout());
        p.add(this.buildConditionListToolbar(), "North");
        p.add((Component)listScrollPane, "Center");
        return p;
    }

    private Component buildConditionListToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        this.addButton = UISupport.createToolbarButton(new AddAction());
        toolbar.addFixed(this.addButton);
        this.copyButton = UISupport.createToolbarButton(new CopyAction());
        this.copyButton.setEnabled(false);
        toolbar.addFixed(this.copyButton);
        this.deleteButton = UISupport.createToolbarButton(new DeleteAction());
        this.deleteButton.setEnabled(false);
        toolbar.addFixed(this.deleteButton);
        this.renameButton = UISupport.createToolbarButton(new RenameAction());
        this.renameButton.setEnabled(false);
        toolbar.addFixed(this.renameButton);
        return toolbar;
    }

    private Component buildConditionToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        this.declareButton = UISupport.createToolbarButton(new DeclareNamespacesAction());
        this.declareButton.setEnabled(false);
        toolbar.addFixed(this.declareButton);
        this.runButton = UISupport.createToolbarButton(new RunAction());
        toolbar.addFixed(this.runButton);
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/gotostep.html#The_Conditional_Goto_Editor")));
        return toolbar;
    }

    protected JXToolBar buildTargetToolbar() {
        JXToolBar builder = UISupport.createSmallToolbar();
        this.testStepsModel = new GotoTestStepsComboBoxModel(this.gotoStep.getTestCase(), null);
        this.testStepsCombo = new JComboBox(this.testStepsModel);
        this.testStepsCombo.setToolTipText("The step the test case will go to if the current condition is true");
        this.testStepsCombo.setEnabled(false);
        builder.addFixed(new JLabel("<html><b>Target step:</b></html>"));
        builder.addRelatedGap();
        builder.addFixed(this.testStepsCombo);
        builder.addGlue();
        this.testConditionButton = new JButton(new TestConditionAction());
        this.testConditionButton.setEnabled(false);
        builder.addFixed(this.testConditionButton);
        builder.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return builder;
    }

    @Override
    public boolean onClose(boolean canCancel) {
        super.release();
        this.componentEnabler.release();
        this.gotoStep.getTestCase().removeTestRunListener(this.testRunListener);
        this.testStepsModel.release();
        this.inspectorPanel.release();
        return true;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.gotoStep || modelItem == this.gotoStep.getTestCase() || modelItem == this.gotoStep.getTestCase().getTestSuite() || modelItem == this.gotoStep.getTestCase().getTestSuite().getProject();
    }

    public WsdlGotoTestStep.GotoCondition getCurrentCondition() {
        return this.currentCondition;
    }

    protected void enableEditComponents(boolean b) {
        this.expressionArea.setEnabled(b);
        this.testStepsCombo.setEnabled(b);
        this.copyButton.setEnabled(b);
        this.deleteButton.setEnabled(b);
        this.declareButton.setEnabled(b);
        this.testConditionButton.setEnabled(b);
        this.renameButton.setEnabled(b);
    }

    private class InternalTestRunListener
    extends TestRunListenerAdapter {
        private InternalTestRunListener() {
        }

        public void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult result) {
            if (result.getTestStep() == GotoStepDesktopPanel.this.gotoStep) {
                GotoStepDesktopPanel.this.logList.addLine(new Date(result.getTimeStamp()).toString() + ": " + result.getMessages()[0]);
                GotoStepDesktopPanel.this.inspectorPanel.setCurrentInspector("Log");
            }
        }
    }

    private final class TestConditionAction
    extends AbstractAction {
        public TestConditionAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run.gif"));
            this.putValue("ShortDescription", "Runs the current condition against the previous response and shows the result");
        }

        public void actionPerformed(ActionEvent e) {
            SamplerTestStep previousStep = GotoStepDesktopPanel.this.gotoStep.getTestCase().findPreviousStepOfType(GotoStepDesktopPanel.this.gotoStep, SamplerTestStep.class);
            if (previousStep == null) {
                UISupport.showErrorMessage("Missing previous request step");
            } else {
                if (previousStep.getTestRequest().getResponse() == null || !XmlUtils.seemsToBeXml(previousStep.getTestRequest().getResponse().getContentAsXml())) {
                    UISupport.showErrorMessage("Missing response in previous request step [" + previousStep.getName() + "]");
                    return;
                }
                try {
                    WsdlGotoTestStep.GotoCondition condition = GotoStepDesktopPanel.this.gotoStep.getConditionAt(GotoStepDesktopPanel.this.conditionList.getSelectedIndex());
                    WsdlTestRunContext context = new WsdlTestRunContext(GotoStepDesktopPanel.this.gotoStep);
                    boolean evaluate = condition.evaluate(previousStep, context);
                    if (!evaluate) {
                        UISupport.showInfoMessage("Condition not true for current response in [" + previousStep.getName() + "]");
                    } else {
                        UISupport.showInfoMessage("Condition true for current response in [" + previousStep.getName() + "]");
                    }
                }
                catch (Exception e1) {
                    UISupport.showErrorMessage("Error checking condition: " + e1.getMessage());
                }
            }
        }
    }

    private final class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_all.gif"));
            this.putValue("ShortDescription", "Runs the current conditions against the previous response");
        }

        public void actionPerformed(ActionEvent e) {
            if (GotoStepDesktopPanel.this.listModel.getSize() == 0) {
                UISupport.showErrorMessage("Missing conditions!");
                return;
            }
            SamplerTestStep previousStep = GotoStepDesktopPanel.this.gotoStep.getTestCase().findPreviousStepOfType(GotoStepDesktopPanel.this.gotoStep, SamplerTestStep.class);
            if (previousStep == null) {
                UISupport.showErrorMessage("Missing previous request step");
            } else {
                if (previousStep.getTestRequest().getResponse() == null || !XmlUtils.seemsToBeXml(previousStep.getTestRequest().getResponse().getContentAsXml())) {
                    UISupport.showErrorMessage("Missing response in previous message");
                    return;
                }
                WsdlTestRunContext context = new WsdlTestRunContext(GotoStepDesktopPanel.this.gotoStep);
                WsdlGotoTestStep.GotoCondition target = GotoStepDesktopPanel.this.gotoStep.runConditions(previousStep, context);
                if (target == null) {
                    GotoStepDesktopPanel.this.logList.addLine("No condition true for current response in [" + previousStep.getName() + "]");
                } else {
                    GotoStepDesktopPanel.this.logList.addLine("Condition triggered for go to [" + target.getTargetStep() + "]");
                }
                GotoStepDesktopPanel.this.inspectorPanel.setCurrentInspector("Log");
            }
        }
    }

    private final class DeclareNamespacesAction
    extends AbstractAction {
        public DeclareNamespacesAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/declareNs.gif"));
            this.putValue("ShortDescription", "Declare available response namespaces in condition expression");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SamplerTestStep previousStep = GotoStepDesktopPanel.this.gotoStep.getTestCase().findPreviousStepOfType(GotoStepDesktopPanel.this.gotoStep, SamplerTestStep.class);
                if (previousStep != null) {
                    String xml;
                    Response response = previousStep.getTestRequest().getResponse();
                    String string = xml = response == null ? null : response.getContentAsString();
                    if (XmlUtils.seemsToBeXml(xml)) {
                        GotoStepDesktopPanel.this.expressionArea.setText(XmlUtils.declareXPathNamespaces(xml) + GotoStepDesktopPanel.this.expressionArea.getText());
                    } else {
                        UISupport.showErrorMessage("Missing response in previous request step [" + previousStep.getName() + "]");
                    }
                } else {
                    UISupport.showErrorMessage("Missing previous request step");
                }
            }
            catch (Exception e1) {
                SoapUI.logError(e1);
            }
        }
    }

    private final class RenameAction
    extends AbstractAction {
        public RenameAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/rename.gif"));
            this.putValue("ShortDescription", "Renames the selected Condition");
        }

        public void actionPerformed(ActionEvent e) {
            int ix = GotoStepDesktopPanel.this.conditionList.getSelectedIndex();
            WsdlGotoTestStep.GotoCondition config = GotoStepDesktopPanel.this.gotoStep.getConditionAt(ix);
            String name = UISupport.prompt("Specify name for condition", "Copy Condition", config.getName());
            if (name == null || name.trim().length() == 0) {
                return;
            }
            config.setName(name);
            GotoStepDesktopPanel.this.listModel.setElementAt(name, ix);
        }
    }

    private final class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Deletes the selected Condition");
        }

        public void actionPerformed(ActionEvent e) {
            if (UISupport.confirm("Delete selected condition", "Delete Condition")) {
                int ix = GotoStepDesktopPanel.this.conditionList.getSelectedIndex();
                GotoStepDesktopPanel.this.conditionList.setSelectedIndex(-1);
                GotoStepDesktopPanel.this.gotoStep.removeConditionAt(ix);
                GotoStepDesktopPanel.this.listModel.remove(ix);
                if (GotoStepDesktopPanel.this.listModel.getSize() > 0) {
                    GotoStepDesktopPanel.this.conditionList.setSelectedIndex(ix > GotoStepDesktopPanel.this.listModel.getSize() - 1 ? GotoStepDesktopPanel.this.listModel.getSize() - 1 : ix);
                }
            }
        }
    }

    private final class CopyAction
    extends AbstractAction {
        public CopyAction() {
            this.putValue("ShortDescription", "Copies the selected Condition");
            this.putValue("SmallIcon", UISupport.createImageIcon("/clone_request.gif"));
        }

        public void actionPerformed(ActionEvent e) {
            int ix = GotoStepDesktopPanel.this.conditionList.getSelectedIndex();
            WsdlGotoTestStep.GotoCondition config = GotoStepDesktopPanel.this.gotoStep.getConditionAt(ix);
            String name = UISupport.prompt("Specify name for condition", "Copy Condition", config.getName());
            if (name == null || name.trim().length() == 0) {
                return;
            }
            WsdlGotoTestStep.GotoCondition condition = GotoStepDesktopPanel.this.gotoStep.addCondition(name);
            condition.setExpression(config.getExpression());
            condition.setTargetStep(config.getTargetStep());
            condition.setType(config.getType());
            GotoStepDesktopPanel.this.listModel.addElement(name);
            GotoStepDesktopPanel.this.conditionList.setSelectedIndex(GotoStepDesktopPanel.this.listModel.getSize() - 1);
        }
    }

    private final class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("ShortDescription", "Adds a new Condition");
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
        }

        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify name for condition", "Add Condition", "Condition " + (GotoStepDesktopPanel.this.gotoStep.getConditionCount() + 1));
            if (name == null || name.trim().length() == 0) {
                return;
            }
            GotoStepDesktopPanel.this.gotoStep.addCondition(name);
            GotoStepDesktopPanel.this.listModel.addElement(name);
            GotoStepDesktopPanel.this.conditionList.setSelectedIndex(GotoStepDesktopPanel.this.listModel.getSize() - 1);
        }
    }

    private final class ConditionListSelectionListener
    implements ListSelectionListener {
        private ConditionListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int ix = GotoStepDesktopPanel.this.conditionList.getSelectedIndex();
            if (ix == -1) {
                GotoStepDesktopPanel.this.expressionArea.setText("");
                GotoStepDesktopPanel.this.testStepsModel.setCondition(null);
                GotoStepDesktopPanel.this.currentCondition = null;
            } else {
                GotoStepDesktopPanel.this.currentCondition = GotoStepDesktopPanel.this.gotoStep.getConditionAt(ix);
                GotoStepDesktopPanel.this.expressionArea.setText(GotoStepDesktopPanel.this.currentCondition.getExpression());
                GotoStepDesktopPanel.this.testStepsModel.setCondition(GotoStepDesktopPanel.this.currentCondition);
            }
            boolean b = ix != -1;
            GotoStepDesktopPanel.this.enableEditComponents(b);
        }
    }

    private final class SourceAreaDocumentListener
    extends DocumentListenerAdapter {
        private SourceAreaDocumentListener() {
        }

        public void update(Document document) {
            int ix = GotoStepDesktopPanel.this.conditionList.getSelectedIndex();
            if (ix != -1) {
                GotoStepDesktopPanel.this.gotoStep.getConditionAt(ix).setExpression(GotoStepDesktopPanel.this.expressionArea.getText());
            }
        }
    }
}

