/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.request;

import com.eviware.soapui.support.types.StringToStringMap;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToStringMapTableModel
extends AbstractTableModel
implements TableModel {
    private StringToStringMap data;
    private final String keyCaption;
    private final String valueCaption;
    private List<String> keyList;
    private final boolean editable;

    public StringToStringMapTableModel(StringToStringMap data, String keyCaption, String valueCaption, boolean editable) {
        this.data = data;
        this.keyCaption = keyCaption;
        this.valueCaption = valueCaption;
        this.editable = editable;
        this.keyList = data == null ? new ArrayList<String>() : new ArrayList(data.keySet());
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int arg0) {
        return arg0 == 0 ? this.keyCaption : this.valueCaption;
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return this.editable;
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return String.class;
    }

    @Override
    public void setValueAt(Object arg0, int arg1, int arg2) {
        String oldKey = this.keyList.get(arg1);
        if (arg2 == 0) {
            String value = (String)this.data.get(oldKey);
            this.data.remove(oldKey);
            this.data.put(arg0.toString(), value);
            this.keyList.set(arg1, arg0.toString());
        } else {
            this.data.put(oldKey, arg0.toString());
        }
        this.fireTableCellUpdated(arg1, arg2);
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public Object getValueAt(int arg0, int arg1) {
        String str = this.keyList.get(arg0);
        return arg1 == 0 ? str : (String)this.data.get(str);
    }

    public void add(String key, String value) {
        if (this.keyList.contains(key)) {
            this.data.put(key, value);
            this.fireTableCellUpdated(this.keyList.indexOf(key), 1);
        } else {
            this.data.put(key, value);
            this.keyList.add(key);
            this.fireTableRowsInserted(this.keyList.size() - 1, this.keyList.size() - 1);
        }
    }

    public void remove(int row) {
        String key = this.keyList.get(row);
        this.keyList.remove(row);
        this.data.remove(key);
        this.fireTableRowsDeleted(row, row);
    }

    public StringToStringMap getData() {
        return new StringToStringMap(this.data);
    }

    public void setData(StringToStringMap data) {
        this.data = data == null ? new StringToStringMap() : data;
        this.keyList = new ArrayList(this.data.keySet());
        this.fireTableDataChanged();
    }
}

