/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.project;

import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.panels.project.JProjectTestSuiteList;
import com.eviware.soapui.impl.wsdl.panels.project.TestRunLogTestSuiteRunListener;
import com.eviware.soapui.impl.wsdl.panels.support.MockProjectRunner;
import com.eviware.soapui.impl.wsdl.panels.testcase.JTestRunLog;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.AbstractGroovyEditorModel;
import com.eviware.soapui.impl.wsdl.support.HelpUrls;
import com.eviware.soapui.impl.wsdl.testcase.WsdlProjectRunner;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.testsuite.ProjectRunContext;
import com.eviware.soapui.model.testsuite.ProjectRunListener;
import com.eviware.soapui.model.testsuite.ProjectRunner;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.testsuite.TestSuiteRunner;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.GroovyEditorComponent;
import com.eviware.soapui.support.components.GroovyEditorInspector;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;

public class WsdlProjectTestSuitesTabPanel
extends JPanel {
    private final WsdlProject project;
    private JProgressBar progressBar;
    private JProjectTestSuiteList testSuiteList;
    private RunAction runAction = new RunAction();
    private CancelAction cancelAction = new CancelAction();
    private JToggleButton sequentialButton;
    private JToggleButton parallellButton;
    private final InternalProjectListener testSuiteListener = new InternalProjectListener();
    private final InternalTestSuiteRunListener testSuiteRunListener = new InternalTestSuiteRunListener();
    private JTestRunLog testRunLog;
    private GroovyEditorComponent tearDownGroovyEditor;
    private GroovyEditorComponent setupGroovyEditor;
    private JInspectorPanel testSuiteListInspectorPanel;
    private JInspectorPanel inspectorPanel;
    private WsdlProjectRunner projectRunner;

    public WsdlProjectTestSuitesTabPanel(WsdlProject project) {
        super(new BorderLayout());
        this.project = project;
        this.buildUI();
        project.addProjectRunListener(this.testSuiteRunListener);
        project.addProjectListener(this.testSuiteListener);
    }

    public WsdlProject getProject() {
        return this.project;
    }

    private void buildUI() {
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.buildContent(), "Center");
        this.setPreferredSize(new Dimension(500, 500));
    }

    private JComponent buildContent() {
        this.inspectorPanel = JInspectorPanelFactory.build(this.buildTabs());
        this.addInspectors(this.inspectorPanel);
        return this.inspectorPanel.getComponent();
    }

    protected void addInspectors(JInspectorPanel inspectorPanel) {
        inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildRunLog(), "TestSuite Log", "Log of executed TestSuites, TestCases and TestSteps", true));
    }

    private JComponent buildRunLog() {
        this.testRunLog = new JTestRunLog(this.project.getSettings());
        return this.testRunLog;
    }

    protected JProjectTestSuiteList getTestSuiteList() {
        return this.testSuiteList;
    }

    private JComponent buildToolbar() {
        this.cancelAction.setEnabled(false);
        this.runAction.setEnabled(this.project.getTestSuiteCount() > 0);
        JXToolBar toolbar = UISupport.createToolbar();
        this.addToolbarActions(toolbar);
        toolbar.addGlue();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/testsuites.html")));
        this.progressBar = new JProgressBar(0, this.project.getTestSuiteCount());
        JPanel progressPanel = UISupport.createProgressBarPanel(this.progressBar, 10, false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolbar, "First");
        panel.add((Component)progressPanel, "Center");
        return panel;
    }

    protected void addToolbarActions(JXToolBar toolbar) {
        toolbar.add(UISupport.createToolbarButton(this.runAction));
        toolbar.add(UISupport.createToolbarButton(this.cancelAction));
        toolbar.addRelatedGap();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.sequentialButton = new JToggleButton(UISupport.createImageIcon("/sequential.gif"), true);
        this.sequentialButton.setToolTipText("The selected TestCases are run in sequence");
        this.sequentialButton.setPreferredSize(UISupport.getPreferredButtonSize());
        this.sequentialButton.setSelected(this.project.getRunType() == TestSuite.TestSuiteRunType.SEQUENTIAL);
        this.sequentialButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WsdlProjectTestSuitesTabPanel.this.project.setRunType(TestSuite.TestSuiteRunType.SEQUENTIAL);
            }
        });
        buttonGroup.add(this.sequentialButton);
        this.parallellButton = new JToggleButton(UISupport.createImageIcon("/parallell.gif"));
        this.parallellButton.setToolTipText("The selected TestCases are run in parallel");
        this.parallellButton.setPreferredSize(UISupport.getPreferredButtonSize());
        this.parallellButton.setSelected(this.project.getRunType() == TestSuite.TestSuiteRunType.PARALLEL);
        this.parallellButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WsdlProjectTestSuitesTabPanel.this.project.setRunType(TestSuite.TestSuiteRunType.PARALLEL);
            }
        });
        buttonGroup.add(this.parallellButton);
        toolbar.addUnrelatedGap();
        toolbar.add(this.sequentialButton);
        toolbar.addRelatedGap();
        toolbar.add(this.parallellButton);
    }

    private JComponent buildTabs() {
        JTabbedPane tabs = new JTabbedPane(1);
        this.testSuiteListInspectorPanel = JInspectorPanelFactory.build(this.buildTestSuiteList(this.project));
        tabs.addTab("TestSuites", this.testSuiteListInspectorPanel.getComponent());
        this.addTabs(tabs, this.testSuiteListInspectorPanel);
        tabs.setTabLayoutPolicy(1);
        return UISupport.createTabPanel(tabs, true);
    }

    protected void addTabs(JTabbedPane tabs, JInspectorPanel inspectorPanel) {
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildSetupScriptPanel(), "Setup Script", "Script to run before running TestSuites"));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildTearDownScriptPanel(), "TearDown Script", "Script to run after running TestSuites"));
    }

    protected GroovyEditorComponent buildTearDownScriptPanel() {
        this.tearDownGroovyEditor = new GroovyEditorComponent(new TearDownScriptGroovyEditorModel(), null);
        return this.tearDownGroovyEditor;
    }

    protected GroovyEditorComponent buildSetupScriptPanel() {
        this.setupGroovyEditor = new GroovyEditorComponent(new SetupScriptGroovyEditorModel(), null);
        return this.setupGroovyEditor;
    }

    protected JComponent buildTestSuiteList(WsdlProject testSuite) {
        this.testSuiteList = new JProjectTestSuiteList(testSuite);
        JPanel p = new JPanel(new BorderLayout());
        p.add(this.buildTestCaseListToolbar(), "North");
        p.add((Component)new JScrollPane(this.testSuiteList), "Center");
        return p;
    }

    private Component buildTestCaseListToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.add(UISupport.createToolbarButton(SwingActionDelegate.createDelegate("AddNewTestSuiteAction", this.project, null, "/testSuite.gif")));
        toolbar.addGlue();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction(HelpUrls.TESTSUITELIST_HELP_URL)));
        return toolbar;
    }

    public void release() {
        this.inspectorPanel.release();
        this.testSuiteListInspectorPanel.release();
        this.setupGroovyEditor.release();
        this.tearDownGroovyEditor.release();
        this.testRunLog.release();
        this.project.removeProjectRunListener(this.testSuiteRunListener);
        this.project.removeProjectListener(this.testSuiteListener);
    }

    protected void runProject() {
        this.projectRunner = this.project.run(new StringToObjectMap(), true);
    }

    protected void beforeRun() {
        this.runAction.setEnabled(false);
        this.cancelAction.setEnabled(true);
        this.testSuiteList.setEnabled(false);
        this.progressBar.setForeground(Color.GREEN.darker());
    }

    protected void afterRun() {
        this.runAction.setEnabled(true);
        this.cancelAction.setEnabled(false);
        this.testSuiteList.setEnabled(true);
        this.progressBar.setString(this.projectRunner.getStatus().toString());
        this.progressBar.setForeground(this.projectRunner.isFailed() ? Color.RED : Color.GREEN.darker());
    }

    private class InternalTestSuiteRunListener
    implements ProjectRunListener {
        private TestRunLogTestSuiteRunListener runLogListener;
        private int finishCount;

        private InternalTestSuiteRunListener() {
        }

        public void afterRun(ProjectRunner testScenarioRunner, ProjectRunContext runContext) {
            if (testScenarioRunner != WsdlProjectTestSuitesTabPanel.this.projectRunner) {
                return;
            }
            WsdlProjectTestSuitesTabPanel.this.afterRun();
        }

        public void afterTestSuite(ProjectRunner testScenarioRunner, ProjectRunContext runContext, TestSuiteRunner testRunner) {
            if (testScenarioRunner != WsdlProjectTestSuitesTabPanel.this.projectRunner) {
                return;
            }
            WsdlProjectTestSuitesTabPanel.this.progressBar.setValue(++this.finishCount);
            if (WsdlProjectTestSuitesTabPanel.this.project.getRunType() == TestSuite.TestSuiteRunType.SEQUENTIAL) {
                testRunner.getTestSuite().removeTestSuiteRunListener(this.runLogListener);
            }
        }

        public void beforeRun(ProjectRunner testScenarioRunner, ProjectRunContext runContext) {
            if (testScenarioRunner != WsdlProjectTestSuitesTabPanel.this.projectRunner) {
                return;
            }
            WsdlProjectTestSuitesTabPanel.this.beforeRun();
            WsdlProjectTestSuitesTabPanel.this.testSuiteList.reset();
            WsdlProjectTestSuitesTabPanel.this.progressBar.setMaximum(WsdlProjectTestSuitesTabPanel.this.project.getTestSuiteCount());
            WsdlProjectTestSuitesTabPanel.this.progressBar.setValue(0);
            WsdlProjectTestSuitesTabPanel.this.progressBar.setString("");
            this.finishCount = 0;
            if (this.runLogListener == null) {
                this.runLogListener = new TestRunLogTestSuiteRunListener(WsdlProjectTestSuitesTabPanel.this.testRunLog, false);
            }
            WsdlProjectTestSuitesTabPanel.this.testRunLog.clear();
            if (WsdlProjectTestSuitesTabPanel.this.project.getRunType() == TestSuite.TestSuiteRunType.PARALLEL) {
                WsdlProjectTestSuitesTabPanel.this.testRunLog.addText("<log disabled during parallell execution>");
            }
        }

        public void beforeTestSuite(ProjectRunner testScenarioRunner, ProjectRunContext runContext, TestSuite testRunnable) {
            if (testScenarioRunner != WsdlProjectTestSuitesTabPanel.this.projectRunner) {
                return;
            }
            WsdlProjectTestSuitesTabPanel.this.progressBar.setString("Running " + testRunnable.getName());
            if (WsdlProjectTestSuitesTabPanel.this.project.getRunType() == TestSuite.TestSuiteRunType.SEQUENTIAL) {
                testRunnable.addTestSuiteRunListener(this.runLogListener);
            }
        }
    }

    private class TearDownScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public TearDownScriptGroovyEditorModel() {
            super(new String[]{"log", "runner", "context", "project"}, WsdlProjectTestSuitesTabPanel.this.project, "TearDown");
        }

        public String getScript() {
            return WsdlProjectTestSuitesTabPanel.this.project.getAfterRunScript();
        }

        public void setScript(String text) {
            WsdlProjectTestSuitesTabPanel.this.project.setAfterRunScript(text);
        }

        public Action createRunAction() {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MockProjectRunner runner = new MockProjectRunner(WsdlProjectTestSuitesTabPanel.this.project);
                        WsdlProjectTestSuitesTabPanel.this.project.runAfterRunScript((ProjectRunContext)runner.getRunContext(), runner);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }
    }

    private class SetupScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public SetupScriptGroovyEditorModel() {
            super(new String[]{"log", "runner", "context", "project"}, WsdlProjectTestSuitesTabPanel.this.project, "Setup");
        }

        public String getScript() {
            return WsdlProjectTestSuitesTabPanel.this.project.getBeforeRunScript();
        }

        public void setScript(String text) {
            WsdlProjectTestSuitesTabPanel.this.project.setBeforeRunScript(text);
        }

        public Action createRunAction() {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MockProjectRunner runner = new MockProjectRunner(WsdlProjectTestSuitesTabPanel.this.project);
                        WsdlProjectTestSuitesTabPanel.this.project.runBeforeRunScript((ProjectRunContext)runner.getRunContext(), runner);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/stop_testcase.gif"));
            this.putValue("ShortDescription", "Cancels ongoing TestCase runs");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlProjectTestSuitesTabPanel.this.projectRunner.cancel("Cancelled from UI");
        }
    }

    private class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_testcase.gif"));
            this.putValue("ShortDescription", "Runs the selected TestCases");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlProjectTestSuitesTabPanel.this.runProject();
        }
    }

    private final class InternalProjectListener
    extends ProjectListenerAdapter {
        private InternalProjectListener() {
        }

        public void testSuiteAdded(TestSuite testSuite) {
            WsdlProjectTestSuitesTabPanel.this.runAction.setEnabled(WsdlProjectTestSuitesTabPanel.this.project.getTestSuiteCount() > 0);
        }

        public void testSuiteRemoved(TestSuite testSuite) {
            WsdlProjectTestSuitesTabPanel.this.runAction.setEnabled(WsdlProjectTestSuitesTabPanel.this.project.getTestSuiteCount() > 0);
        }
    }
}

