/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation;

import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatchRegistry;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatcher;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockServiceListener;
import com.eviware.soapui.model.support.InterfaceListenerAdapter;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.util.ModelItemNames;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.swing.ExtendedComboBoxModel;
import com.eviware.soapui.support.swing.ModelItemListKeyListener;
import com.eviware.soapui.support.swing.ModelItemListMouseListener;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMockOperationDesktopPanel
extends ModelItemDesktopPanel<WsdlMockOperation> {
    private JList responseList;
    private JComboBox interfaceCombo;
    private JComboBox operationCombo;
    private JComboBox dispatchCombo;
    private JPanel dispatchPanel;
    private InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private InternalProjectListener projectListener = new InternalProjectListener();
    private WsdlInterface currentInterface;
    private JComboBox defaultResponseCombo;
    private ResponseListModel responseListModel;
    private JComponentInspector<JComponent> dispatchInspector;
    private JInspectorPanel inspectorPanel;
    private MockOperationDispatcher dispatcher;

    public WsdlMockOperationDesktopPanel(WsdlMockOperation mockOperation) {
        super(mockOperation);
        this.buildUI();
        this.setPreferredSize(new Dimension(600, 440));
        mockOperation.getMockService().getProject().addProjectListener(this.projectListener);
        WsdlOperation operation = ((WsdlMockOperation)this.getModelItem()).getOperation();
        if (operation != null) {
            this.currentInterface = operation.getInterface();
            this.currentInterface.addInterfaceListener(this.interfaceListener);
        }
    }

    private void buildUI() {
        this.add(this.buildToolbar(), "North");
        this.inspectorPanel = JInspectorPanelFactory.build(this.buildResponseList());
        this.inspectorPanel.setDefaultDividerLocation(0.5f);
        this.dispatchInspector = new JComponentInspector<JComponent>(this.buildDispatchEditor(), "Dispatch (" + ((WsdlMockOperation)this.getModelItem()).getDispatchStyle().toString() + ")", "Configures current dispatch style", true);
        this.inspectorPanel.addInspector(this.dispatchInspector);
        this.inspectorPanel.activate(this.dispatchInspector);
        this.add((Component)this.inspectorPanel.getComponent(), "Center");
    }

    private JComponent buildResponseList() {
        this.responseListModel = new ResponseListModel();
        this.responseList = new JList(this.responseListModel);
        this.responseList.addKeyListener(new ModelItemListKeyListener(){

            public ModelItem getModelItemAt(int ix) {
                return ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockResponseAt(ix);
            }
        });
        this.responseList.addMouseListener(new ModelItemListMouseListener(){
            private DefaultActionList defaultActions;

            protected ActionList getActionsForRow(JList list, int row) {
                ActionList actions = super.getActionsForRow(list, row);
                actions.insertAction(SwingActionDelegate.createDelegate("NewMockResponseAction", WsdlMockOperationDesktopPanel.this.getModelItem(), null, "/addToMockService.gif"), 0);
                actions.insertAction(SwingActionDelegate.createDelegate("OpenRequestForMockOperationAction", WsdlMockOperationDesktopPanel.this.getModelItem(), null, "/open_request.gif"), 1);
                if (actions.getActionCount() > 2) {
                    actions.insertAction(ActionSupport.SEPARATOR_ACTION, 2);
                }
                return actions;
            }

            protected ActionList getDefaultActions() {
                if (this.defaultActions == null) {
                    this.defaultActions = new DefaultActionList();
                    this.defaultActions.addAction(SwingActionDelegate.createDelegate("NewMockResponseAction", WsdlMockOperationDesktopPanel.this.getModelItem(), null, "/addToMockService.gif"));
                }
                return this.defaultActions;
            }
        });
        this.responseList.setCellRenderer(new ResponseListCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.responseList);
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("MockResponses", UISupport.buildPanelWithToolbar(this.buildMockResponseListToolbar(), scrollPane));
        return UISupport.createTabPanel(tabs, true);
    }

    private JComponent buildMockResponseListToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.add(UISupport.createToolbarButton(SwingActionDelegate.createDelegate("NewMockResponseAction", this.getModelItem(), null, "/mockResponse.gif")));
        return toolbar;
    }

    private JComponent buildDispatchEditor() {
        this.dispatchPanel = new JPanel(new BorderLayout());
        this.dispatchPanel.setOpaque(true);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JLabel("Dispatch: "));
        builder.addRelatedGap();
        this.dispatchCombo = new JComboBox<String>(MockOperationDispatchRegistry.getDispatchTypes());
        this.dispatchCombo.setSelectedItem(null);
        this.dispatchCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (WsdlMockOperationDesktopPanel.this.dispatchPanel.getComponentCount() > 1) {
                    WsdlMockOperationDesktopPanel.this.dispatchPanel.remove(1);
                }
                String item = (String)WsdlMockOperationDesktopPanel.this.dispatchCombo.getSelectedItem();
                WsdlMockOperationDesktopPanel.this.dispatcher = ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setDispatchStyle(item);
                WsdlMockOperationDesktopPanel.this.dispatchPanel.add((Component)WsdlMockOperationDesktopPanel.this.dispatcher.getEditorComponent(), "Center");
                WsdlMockOperationDesktopPanel.this.dispatchPanel.revalidate();
                WsdlMockOperationDesktopPanel.this.dispatchPanel.repaint();
                if (WsdlMockOperationDesktopPanel.this.dispatchInspector != null && item != null) {
                    WsdlMockOperationDesktopPanel.this.dispatchInspector.setTitle("Dispatch (" + item + ")");
                }
            }
        });
        builder.addFixed((JComponent)this.dispatchCombo);
        builder.addUnrelatedGap();
        builder.addFixed((JComponent)new JLabel("Default Response: "));
        builder.addRelatedGap();
        ModelItemNames<MockResponse> names = new ModelItemNames<MockResponse>(((WsdlMockOperation)this.getModelItem()).getMockResponses());
        this.defaultResponseCombo = new JComboBox(new ExtendedComboBoxModel(names.getNames()));
        this.defaultResponseCombo.setPreferredSize(new Dimension(150, 20));
        this.defaultResponseCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Object selectedItem = WsdlMockOperationDesktopPanel.this.defaultResponseCombo.getSelectedItem();
                ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setDefaultResponse((String)selectedItem);
            }
        });
        builder.addFixed((JComponent)this.defaultResponseCombo);
        builder.setBorder(BorderFactory.createEmptyBorder(2, 3, 3, 3));
        this.dispatchPanel.add((Component)builder.getPanel(), "North");
        this.defaultResponseCombo.setSelectedItem(((WsdlMockOperation)this.getModelItem()).getDefaultResponse());
        this.dispatchCombo.setSelectedItem(((WsdlMockOperation)this.getModelItem()).getDispatchStyle());
        return this.dispatchPanel;
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(3);
        toolbar.addFixed(UISupport.createToolbarButton(SwingActionDelegate.createDelegate("NewMockResponseAction", this.getModelItem(), null, "/addToMockService.gif")));
        toolbar.addFixed(UISupport.createToolbarButton(SwingActionDelegate.createDelegate("OpenRequestForMockOperationAction", this.getModelItem(), null, "/open_request.gif")));
        toolbar.addUnrelatedGap();
        ModelItemNames<WsdlInterface> names = new ModelItemNames<WsdlInterface>(ModelSupport.getChildren(((WsdlMockOperation)this.getModelItem()).getMockService().getProject(), WsdlInterface.class));
        this.interfaceCombo = new JComboBox<String>(names.getNames());
        this.interfaceCombo.setSelectedIndex(-1);
        this.interfaceCombo.addItemListener(new InterfaceComboListener());
        toolbar.addLabeledFixed("Interface", this.interfaceCombo);
        toolbar.addUnrelatedGap();
        this.operationCombo = new JComboBox(new ExtendedComboBoxModel());
        this.operationCombo.setPreferredSize(new Dimension(150, 20));
        this.operationCombo.addItemListener(new OperationComboListener());
        toolbar.addLabeledFixed("Operation", this.operationCombo);
        WsdlOperation operation = ((WsdlMockOperation)this.getModelItem()).getOperation();
        this.interfaceCombo.setSelectedItem(operation == null ? null : operation.getInterface().getName());
        this.operationCombo.setSelectedItem(operation == null ? null : operation.getName());
        toolbar.addGlue();
        toolbar.addFixed(WsdlMockOperationDesktopPanel.createActionButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/mock/operations.html"), true));
        return toolbar;
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (this.currentInterface != null) {
            this.currentInterface.removeInterfaceListener(this.interfaceListener);
        }
        ((WsdlMockOperation)this.getModelItem()).getMockService().getProject().removeProjectListener(this.projectListener);
        this.responseListModel.release();
        this.inspectorPanel.release();
        if (this.dispatcher != null) {
            this.dispatcher.releaseEditorComponent();
        }
        return this.release();
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((WsdlMockOperation)this.getModelItem()).getMockService() || modelItem == ((WsdlMockOperation)this.getModelItem()).getMockService().getProject();
    }

    private static final class ResponseListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ResponseListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MockResponse testStep = (MockResponse)value;
            this.setText(testStep.getName());
            this.setIcon(testStep.getIcon());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            return this;
        }
    }

    public class ResponseListModel
    extends AbstractListModel
    implements ListModel,
    MockServiceListener,
    PropertyChangeListener {
        private List<WsdlMockResponse> responses = new ArrayList<WsdlMockResponse>();

        public ResponseListModel() {
            for (int c = 0; c < ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockResponseCount(); ++c) {
                WsdlMockResponse mockResponse = ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockResponseAt(c);
                mockResponse.addPropertyChangeListener(this);
                this.responses.add(mockResponse);
            }
            ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockService().addMockServiceListener(this);
        }

        public Object getElementAt(int arg0) {
            return this.responses.get(arg0);
        }

        public int getSize() {
            return this.responses.size();
        }

        public void mockOperationAdded(MockOperation operation) {
        }

        public void mockOperationRemoved(MockOperation operation) {
        }

        public void mockResponseAdded(MockResponse response) {
            if (response.getMockOperation() != WsdlMockOperationDesktopPanel.this.getModelItem()) {
                return;
            }
            this.responses.add((WsdlMockResponse)response);
            response.addPropertyChangeListener(this);
            this.fireIntervalAdded(this, this.responses.size() - 1, this.responses.size() - 1);
            WsdlMockOperationDesktopPanel.this.defaultResponseCombo.addItem(response.getName());
        }

        public void mockResponseRemoved(MockResponse response) {
            if (response.getMockOperation() != WsdlMockOperationDesktopPanel.this.getModelItem()) {
                return;
            }
            int ix = this.responses.indexOf(response);
            this.responses.remove(ix);
            response.removePropertyChangeListener(this);
            this.fireIntervalRemoved(this, ix, ix);
            WsdlMockOperationDesktopPanel.this.defaultResponseCombo.removeItem(response.getName());
        }

        public void propertyChange(PropertyChangeEvent arg0) {
            if (arg0.getPropertyName().equals(WsdlMockOperation.NAME_PROPERTY)) {
                int ix = this.responses.indexOf(arg0.getSource());
                this.fireContentsChanged(this, ix, ix);
                ExtendedComboBoxModel model = (ExtendedComboBoxModel)WsdlMockOperationDesktopPanel.this.defaultResponseCombo.getModel();
                model.setElementAt(arg0.getNewValue(), ix);
                if (model.getSelectedItem().equals(arg0.getOldValue())) {
                    model.setSelectedItem(arg0.getNewValue());
                }
            }
        }

        public void release() {
            for (WsdlMockResponse operation : this.responses) {
                operation.removePropertyChangeListener(this);
            }
            ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockService().removeMockServiceListener(this);
        }
    }

    private final class InternalInterfaceListener
    extends InterfaceListenerAdapter {
        private InternalInterfaceListener() {
        }

        public void operationAdded(Operation operation) {
            WsdlMockOperationDesktopPanel.this.operationCombo.addItem(operation.getName());
        }

        public void operationRemoved(Operation operation) {
            Object selectedItem = WsdlMockOperationDesktopPanel.this.operationCombo.getSelectedItem();
            WsdlMockOperationDesktopPanel.this.operationCombo.removeItem(operation.getName());
            if (selectedItem.equals(operation.getName())) {
                ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setOperation(null);
                WsdlMockOperationDesktopPanel.this.interfaceCombo.setSelectedIndex(-1);
            }
        }

        public void operationUpdated(Operation operation) {
            ExtendedComboBoxModel model = (ExtendedComboBoxModel)WsdlMockOperationDesktopPanel.this.operationCombo.getModel();
            int ix = model.getIndexOf(operation.getName());
            if (ix != -1) {
                model.setElementAt(operation.getName(), ix);
            }
        }
    }

    private final class InternalProjectListener
    extends ProjectListenerAdapter {
        private InternalProjectListener() {
        }

        public void interfaceAdded(Interface iface) {
            WsdlMockOperationDesktopPanel.this.interfaceCombo.addItem(iface.getName());
        }

        public void interfaceRemoved(Interface iface) {
            if (WsdlMockOperationDesktopPanel.this.interfaceCombo.getSelectedItem().equals(iface.getName())) {
                ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setOperation(null);
            }
        }
    }

    private final class InterfaceComboListener
    implements ItemListener {
        private InterfaceComboListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            Object selectedItem;
            if (WsdlMockOperationDesktopPanel.this.currentInterface != null) {
                WsdlMockOperationDesktopPanel.this.currentInterface.removeInterfaceListener(WsdlMockOperationDesktopPanel.this.interfaceListener);
            }
            if ((selectedItem = WsdlMockOperationDesktopPanel.this.interfaceCombo.getSelectedItem()) == null) {
                WsdlMockOperationDesktopPanel.this.operationCombo.setModel(new ExtendedComboBoxModel());
                WsdlMockOperationDesktopPanel.this.currentInterface = null;
            } else {
                WsdlMockOperationDesktopPanel.this.currentInterface = (WsdlInterface)((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockService().getProject().getInterfaceByName(selectedItem.toString());
                ModelItemNames<Operation> names = new ModelItemNames<Operation>(WsdlMockOperationDesktopPanel.this.currentInterface.getOperationList());
                WsdlMockOperationDesktopPanel.this.operationCombo.setModel(new ExtendedComboBoxModel(names.getNames()));
                WsdlMockOperationDesktopPanel.this.currentInterface.addInterfaceListener(WsdlMockOperationDesktopPanel.this.interfaceListener);
            }
        }
    }

    private final class OperationComboListener
    implements ItemListener {
        private OperationComboListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            WsdlInterface iface = (WsdlInterface)((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockService().getProject().getInterfaceByName(WsdlMockOperationDesktopPanel.this.interfaceCombo.getSelectedItem().toString());
            WsdlOperation operation = iface.getOperationByName(WsdlMockOperationDesktopPanel.this.operationCombo.getSelectedItem().toString());
            ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setOperation(operation);
        }
    }
}

