/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.editor.xml.support.AbstractXmlDocument;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;

public class MockRequestXmlDocument
extends AbstractXmlDocument
implements XmlDocument {
    private final WsdlMockResponse mockResponse;

    public MockRequestXmlDocument(WsdlMockResponse response) {
        this.mockResponse = response;
    }

    public SchemaTypeSystem getTypeSystem() {
        try {
            WsdlOperation operation = this.mockResponse.getMockOperation().getOperation();
            if (operation != null) {
                WsdlInterface iface = operation.getInterface();
                WsdlContext wsdlContext = iface.getWsdlContext();
                return wsdlContext.getSchemaTypeSystem();
            }
        }
        catch (Exception e1) {
            SoapUI.logError(e1);
        }
        return XmlBeans.getBuiltinTypeSystem();
    }

    public String getXml() {
        WsdlMockResult mockResult = this.mockResponse.getMockResult();
        return mockResult == null ? null : mockResult.getMockRequest().getRequestContent();
    }

    public void setXml(String xml) {
        WsdlMockResult mockResult = this.mockResponse.getMockResult();
        if (mockResult != null) {
            String oldXml = this.getXml();
            mockResult.getMockRequest().setRequestContent(xml);
            oldXml = "";
            this.fireXmlChanged(oldXml, xml);
        } else {
            this.fireXmlChanged(null, xml);
        }
    }
}

