/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.support.components.ModelItemXmlEditor;
import com.eviware.soapui.impl.support.components.RequestMessageXmlEditor;
import com.eviware.soapui.impl.support.components.ResponseMessageXmlEditor;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.MockRequestXmlDocument;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.MockResponseXmlDocument;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.CreateEmptyMockResponseAction;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.CreateFaultMockResponseAction;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.RecreateMockResponseAction;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.WSIValidateResponseAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.support.AbstractModelItem;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.actions.ChangeSplitPaneOrientationAction;
import com.eviware.soapui.support.components.JEditorStatusBarWithProgress;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.views.xml.source.XmlSourceEditorView;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.swing.SoapUISplitPaneUI;
import com.eviware.soapui.support.xml.JXEditTextArea;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractWsdlMockResponseDesktopPanel<T extends ModelItem, T2 extends WsdlMockResponse>
extends ModelItemDesktopPanel<T> {
    private JEditorStatusBarWithProgress statusBar;
    private JButton splitButton;
    private MockRunner mockRunner;
    private JButton recreateButton;
    private JButton createEmptyButton;
    private JSplitPane requestSplitPane;
    private MoveFocusAction moveFocusAction;
    private ClosePanelAction closePanelAction = new ClosePanelAction();
    private ModelItemXmlEditor<?, ?> requestEditor;
    private ModelItemXmlEditor<?, ?> responseEditor;
    public AbstractAction wsiValidateAction;
    private JTabbedPane requestTabs;
    private JPanel requestTabPanel;
    private JToggleButton tabsButton;
    public boolean responseHasFocus;
    private InternalPropertyChangeListener propertyChangeListener = new InternalPropertyChangeListener();
    private JButton createFaultButton;
    private T2 mockResponse;
    private JButton openRequestButton;

    public AbstractWsdlMockResponseDesktopPanel(T modelItem) {
        super(modelItem);
    }

    protected void init(T2 mockResponse) {
        this.mockResponse = mockResponse;
        this.add((Component)this.buildContent(), "Center");
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.buildStatusLabel(), "South");
        this.setPreferredSize(new Dimension(600, 500));
        ((AbstractModelItem)mockResponse).addPropertyChangeListener(this.propertyChangeListener);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (AbstractWsdlMockResponseDesktopPanel.this.requestTabs.getSelectedIndex() == 1 || AbstractWsdlMockResponseDesktopPanel.this.responseHasFocus) {
                    AbstractWsdlMockResponseDesktopPanel.this.responseEditor.requestFocus();
                } else {
                    AbstractWsdlMockResponseDesktopPanel.this.requestEditor.requestFocus();
                }
            }
        });
        try {
            if (((WsdlMockResponse)mockResponse).getAttachmentCount() > 0) {
                ((WsdlMockResponse)mockResponse).getOperation().getInterface().getDefinitionContext().loadIfNecessary();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected WsdlMockResponse getMockResponse() {
        return this.mockResponse;
    }

    public final ModelItemXmlEditor<?, ?> getRequestEditor() {
        return this.requestEditor;
    }

    public final ModelItemXmlEditor<?, ?> getResponseEditor() {
        return this.responseEditor;
    }

    public MockRunner getSubmit() {
        return this.mockRunner;
    }

    protected JComponent buildStatusLabel() {
        this.statusBar = new JEditorStatusBarWithProgress();
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        return this.statusBar;
    }

    public JEditorStatusBarWithProgress getStatusBar() {
        return this.statusBar;
    }

    protected JComponent buildContent() {
        this.requestSplitPane = UISupport.createHorizontalSplit();
        this.requestSplitPane.setResizeWeight(0.5);
        this.requestSplitPane.setBorder(null);
        this.splitButton = AbstractWsdlMockResponseDesktopPanel.createActionButton(new ChangeSplitPaneOrientationAction(this.requestSplitPane), true);
        this.tabsButton = new JToggleButton(new ChangeToTabsAction());
        this.tabsButton.setPreferredSize(UISupport.TOOLBAR_BUTTON_DIMENSION);
        this.openRequestButton = AbstractWsdlMockResponseDesktopPanel.createActionButton(SwingActionDelegate.createDelegate("OpenRequestForMockResponseAction", this.mockResponse, null, "/open_request.gif"), true);
        boolean bidirectional = ((WsdlMockResponse)this.mockResponse).getMockOperation().getOperation().isBidirectional();
        this.recreateButton = AbstractWsdlMockResponseDesktopPanel.createActionButton(new RecreateMockResponseAction((WsdlMockResponse)this.mockResponse), bidirectional);
        this.createEmptyButton = AbstractWsdlMockResponseDesktopPanel.createActionButton(new CreateEmptyMockResponseAction((WsdlMockResponse)this.mockResponse), bidirectional);
        this.createFaultButton = AbstractWsdlMockResponseDesktopPanel.createActionButton(new CreateFaultMockResponseAction((WsdlMockResponse)this.mockResponse), bidirectional);
        this.moveFocusAction = new MoveFocusAction();
        this.wsiValidateAction = SwingActionDelegate.createDelegate(new WSIValidateResponseAction(), this.mockResponse, "alt W");
        this.requestEditor = this.buildRequestEditor();
        this.responseEditor = this.buildResponseEditor();
        this.requestTabs = new JTabbedPane();
        this.requestTabPanel = UISupport.createTabPanel(this.requestTabs, true);
        JComponent component = null;
        if (((AbstractWsdlModelItem)this.mockResponse).getSettings().getBoolean(UISettings.START_WITH_REQUEST_TABS)) {
            this.requestTabs.addTab("Last Request", this.requestEditor);
            this.requestTabs.addTab("Mock Response", this.responseEditor);
            this.splitButton.setEnabled(false);
            this.tabsButton.setSelected(true);
            component = this.requestTabPanel;
            this.requestTabs.setSelectedIndex(1);
        } else {
            this.requestSplitPane.setTopComponent(this.requestEditor);
            this.requestSplitPane.setBottomComponent(this.responseEditor);
            this.requestSplitPane.setDividerLocation(0.5);
            component = this.requestSplitPane;
        }
        return component;
    }

    protected ModelItemXmlEditor<?, ?> buildResponseEditor() {
        return new WsdlMockResponseMessageEditor(new MockResponseXmlDocument((WsdlMockResponse)this.mockResponse));
    }

    protected ModelItemXmlEditor<?, ?> buildRequestEditor() {
        return new WsdlMockRequestMessageEditor(new MockRequestXmlDocument((WsdlMockResponse)this.mockResponse));
    }

    protected JComponent buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.add(this.openRequestButton);
        toolbar.addUnrelatedGap();
        toolbar.add(this.recreateButton);
        toolbar.add(this.createEmptyButton);
        toolbar.add(this.createFaultButton);
        this.createToolbar(toolbar);
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.tabsButton);
        toolbar.add(this.splitButton);
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction(this.getHelpUrl())));
        return toolbar;
    }

    protected void createToolbar(JXToolBar toolbar) {
    }

    protected String getHelpUrl() {
        return "http://www.soapui.org/userguide/requests.html#The_Request_Editor";
    }

    protected void insertButtons(JToolBar toolbar) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.requestEditor.getSourceEditor().setEditable(enabled);
        this.responseEditor.getSourceEditor().setEditable(enabled);
        this.recreateButton.setEnabled(enabled);
        this.createEmptyButton.setEnabled(enabled);
        this.statusBar.setIndeterminate(!enabled);
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((WsdlMockResponse)this.mockResponse).getMockOperation() || modelItem == ((WsdlMockResponse)this.mockResponse).getMockOperation().getMockService() || modelItem == ((WsdlMockResponse)this.mockResponse).getMockOperation().getMockService().getProject();
    }

    public void setContent(JComponent content) {
        this.add((Component)content, "Center");
    }

    public void removeContent(JComponent content) {
        this.remove(content);
    }

    @Override
    public boolean onClose(boolean canCancel) {
        ((AbstractModelItem)this.mockResponse).removePropertyChangeListener(this.propertyChangeListener);
        this.requestEditor.release();
        this.responseEditor.release();
        this.responseEditor.getParent().remove(this.responseEditor);
        this.responseEditor = null;
        this.requestEditor.getParent().remove(this.requestEditor);
        this.requestEditor = null;
        return this.release();
    }

    private final class ChangeToTabsAction
    extends AbstractAction {
        public ChangeToTabsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/toggle_tabs.gif"));
            this.putValue("ShortDescription", "Toggles to tab-based layout");
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractWsdlMockResponseDesktopPanel.this.splitButton.isEnabled()) {
                AbstractWsdlMockResponseDesktopPanel.this.splitButton.setEnabled(false);
                AbstractWsdlMockResponseDesktopPanel.this.removeContent(AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane);
                AbstractWsdlMockResponseDesktopPanel.this.setContent(AbstractWsdlMockResponseDesktopPanel.this.requestTabPanel);
                AbstractWsdlMockResponseDesktopPanel.this.requestTabs.addTab("Last Request", AbstractWsdlMockResponseDesktopPanel.this.requestEditor);
                AbstractWsdlMockResponseDesktopPanel.this.requestTabs.addTab("Mock Response", AbstractWsdlMockResponseDesktopPanel.this.responseEditor);
            } else {
                int selectedIndex = AbstractWsdlMockResponseDesktopPanel.this.requestTabs.getSelectedIndex();
                AbstractWsdlMockResponseDesktopPanel.this.splitButton.setEnabled(true);
                AbstractWsdlMockResponseDesktopPanel.this.removeContent(AbstractWsdlMockResponseDesktopPanel.this.requestTabPanel);
                AbstractWsdlMockResponseDesktopPanel.this.setContent(AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane);
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setTopComponent(AbstractWsdlMockResponseDesktopPanel.this.requestEditor);
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setBottomComponent(AbstractWsdlMockResponseDesktopPanel.this.responseEditor);
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(0.5);
                if (selectedIndex == 0) {
                    AbstractWsdlMockResponseDesktopPanel.this.requestEditor.requestFocus();
                } else {
                    AbstractWsdlMockResponseDesktopPanel.this.responseEditor.requestFocus();
                }
            }
            AbstractWsdlMockResponseDesktopPanel.this.revalidate();
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private MoveFocusAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractWsdlMockResponseDesktopPanel.this.requestEditor.hasFocus()) {
                AbstractWsdlMockResponseDesktopPanel.this.responseEditor.requestFocus();
            } else {
                AbstractWsdlMockResponseDesktopPanel.this.requestEditor.requestFocus();
            }
        }
    }

    private class ClosePanelAction
    extends AbstractAction {
        private ClosePanelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.getDesktop().closeDesktopPanel((ModelItem)AbstractWsdlMockResponseDesktopPanel.this.getModelItem());
        }
    }

    protected final class ResultAreaFocusListener
    implements FocusListener {
        protected ResultAreaFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            int maximumDividerLocation;
            AbstractWsdlMockResponseDesktopPanel.this.responseHasFocus = true;
            AbstractWsdlMockResponseDesktopPanel.this.statusBar.setTarget(AbstractWsdlMockResponseDesktopPanel.this.responseEditor.getSourceEditor().getInputArea());
            if (!AbstractWsdlMockResponseDesktopPanel.this.splitButton.isEnabled()) {
                AbstractWsdlMockResponseDesktopPanel.this.requestTabs.setSelectedIndex(1);
                return;
            }
            if (AbstractWsdlMockResponseDesktopPanel.this.getModelItem().getSettings().getBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR)) {
                return;
            }
            if (((SoapUISplitPaneUI)AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.getUI()).hasBeenDragged()) {
                return;
            }
            int pos = AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.getDividerLocation();
            if (pos + 600 < (maximumDividerLocation = AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.getMaximumDividerLocation())) {
                return;
            }
            if (maximumDividerLocation > 700) {
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(maximumDividerLocation - 600);
            } else {
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(0.2);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    protected final class InputAreaFocusListener
    implements FocusListener {
        protected InputAreaFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            AbstractWsdlMockResponseDesktopPanel.this.responseHasFocus = false;
            AbstractWsdlMockResponseDesktopPanel.this.statusBar.setTarget(AbstractWsdlMockResponseDesktopPanel.this.requestEditor.getSourceEditor().getInputArea());
            if (!AbstractWsdlMockResponseDesktopPanel.this.splitButton.isEnabled()) {
                AbstractWsdlMockResponseDesktopPanel.this.requestTabs.setSelectedIndex(0);
                return;
            }
            if (AbstractWsdlMockResponseDesktopPanel.this.getModelItem().getSettings().getBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR)) {
                return;
            }
            if (((SoapUISplitPaneUI)AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.getUI()).hasBeenDragged()) {
                return;
            }
            int pos = AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.getDividerLocation();
            if (pos >= 600) {
                return;
            }
            if (AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.getMaximumDividerLocation() > 700) {
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(600);
            } else {
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(0.8);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WsdlMockResponseMessageEditor
    extends ResponseMessageXmlEditor<WsdlMockResponse, XmlDocument> {
        public WsdlMockResponseMessageEditor(XmlDocument document) {
            super(document, AbstractWsdlMockResponseDesktopPanel.this.mockResponse);
            XmlSourceEditorView editor = this.getSourceEditor();
            if (((WsdlMockResponse)this.getModelItem()).getMockOperation().isBidirectional()) {
                JXEditTextArea inputArea = editor.getInputArea();
                inputArea.addFocusListener(new ResultAreaFocusListener());
                inputArea.getInputHandler().addKeyBinding("AC+TAB", AbstractWsdlMockResponseDesktopPanel.this.moveFocusAction);
                inputArea.getInputHandler().addKeyBinding("C+F4", AbstractWsdlMockResponseDesktopPanel.this.closePanelAction);
                JPopupMenu inputPopup = editor.getEditorPopup();
                inputPopup.insert(new JSeparator(), 2);
                inputPopup.insert(AbstractWsdlMockResponseDesktopPanel.this.wsiValidateAction, 3);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WsdlMockRequestMessageEditor
    extends RequestMessageXmlEditor<WsdlMockResponse, XmlDocument> {
        public WsdlMockRequestMessageEditor(XmlDocument document) {
            super(document, AbstractWsdlMockResponseDesktopPanel.this.mockResponse);
        }

        protected XmlSourceEditorView<?> buildSourceEditor() {
            XmlSourceEditorView editor = this.getSourceEditor();
            JXEditTextArea inputArea = editor.getInputArea();
            inputArea.addFocusListener(new InputAreaFocusListener());
            inputArea.getInputHandler().addKeyBinding("AC+TAB", AbstractWsdlMockResponseDesktopPanel.this.moveFocusAction);
            inputArea.getInputHandler().addKeyBinding("F5", AbstractWsdlMockResponseDesktopPanel.this.recreateButton.getAction());
            inputArea.getInputHandler().addKeyBinding("C+F4", AbstractWsdlMockResponseDesktopPanel.this.closePanelAction);
            return editor;
        }
    }

    private final class InternalPropertyChangeListener
    implements PropertyChangeListener {
        private InternalPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(WsdlMockResponse.MOCKRESULT_PROPERTY)) {
                WsdlMockResult mockResult = AbstractWsdlMockResponseDesktopPanel.this.mockResponse.getMockResult();
                WsdlMockRequest mockRequest = mockResult == null ? null : mockResult.getMockRequest();
                ((XmlDocument)AbstractWsdlMockResponseDesktopPanel.this.requestEditor.getDocument()).setXml(mockRequest == null ? "" : mockRequest.getRequestContent());
                boolean bidirectional = AbstractWsdlMockResponseDesktopPanel.this.mockResponse.getMockOperation().getOperation().isBidirectional();
                AbstractWsdlMockResponseDesktopPanel.this.wsiValidateAction.setEnabled(bidirectional);
            }
        }
    }
}

