/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor.jettyproxy;

import com.eviware.soapui.impl.wsdl.monitor.JProxyServletWsdlMonitorMessageExchange;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitor;
import com.eviware.soapui.impl.wsdl.monitor.jettyproxy.CaptureInputStream;
import com.eviware.soapui.impl.wsdl.monitor.jettyproxy.ProxyServlet;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedGetMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPostMethod;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.mortbay.util.IO;

public class TunnelServlet
extends ProxyServlet {
    private String sslEndPoint;
    private int sslPort = 443;
    private String prot = "https://";

    public TunnelServlet(SoapMonitor soapMonitor, String sslEndpoint) {
        super(soapMonitor);
        int prefix;
        int c;
        if (!sslEndpoint.startsWith("https")) {
            this.prot = "http://";
        }
        if ((c = sslEndpoint.indexOf(prefix = sslEndpoint.indexOf("://"), 58)) > 0) {
            this.sslPort = Integer.parseInt(sslEndpoint.substring(c + 1));
            this.sslEndPoint = sslEndpoint.substring(prefix, c);
        } else if (prefix > 0) {
            this.sslEndPoint = sslEndpoint.substring(prefix + 3);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.context = config.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.monitor.fireOnRequest(request, response);
        if (response.isCommitted()) {
            return;
        }
        InetSocketAddress inetAddress = new InetSocketAddress(this.sslEndPoint, this.sslPort);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ExtendedHttpMethod postMethod = httpRequest.getMethod().equals("GET") ? new ExtendedGetMethod() : new ExtendedPostMethod();
        JProxyServletWsdlMonitorMessageExchange capturedData = new JProxyServletWsdlMonitorMessageExchange(this.project);
        capturedData.setRequestHost(httpRequest.getRemoteHost());
        capturedData.setRequestHeader(httpRequest);
        capturedData.setTargetURL(this.prot + inetAddress.getHostName());
        CaptureInputStream capture = new CaptureInputStream((InputStream)httpRequest.getInputStream());
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String val;
            Enumeration vals;
            String hdr = (String)headerNames.nextElement();
            String lhdr = hdr.toLowerCase();
            if ("host".equals(lhdr)) {
                vals = httpRequest.getHeaders(hdr);
                while (vals.hasMoreElements()) {
                    val = (String)vals.nextElement();
                    if (!val.startsWith("127.0.0.1")) continue;
                    postMethod.addRequestHeader(hdr, this.sslEndPoint);
                }
                continue;
            }
            vals = httpRequest.getHeaders(hdr);
            while (vals.hasMoreElements()) {
                val = (String)vals.nextElement();
                if (val == null) continue;
                postMethod.addRequestHeader(hdr, val);
            }
        }
        if (postMethod instanceof ExtendedPostMethod) {
            ((ExtendedPostMethod)postMethod).setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)capture, request.getContentType()));
        }
        HostConfiguration hostConfiguration = new HostConfiguration();
        httpRequest.getProtocol();
        hostConfiguration.getParams().setParameter("soapui.sslConfig", (Object)(this.settings.getString("HTTP tunnel - Set SSL Client Key Store path", "") + " " + this.settings.getString("HTTP tunnel - Set SSL Client Key Store Password", "")));
        hostConfiguration.setHost(new URI(this.prot + this.sslEndPoint, true));
        hostConfiguration = ProxyUtils.initProxySettings(this.settings, this.httpState, hostConfiguration, this.prot + this.sslEndPoint, new DefaultPropertyExpansionContext(this.project));
        if (this.sslEndPoint.indexOf("/") < 0) {
            postMethod.setPath("/");
        } else {
            postMethod.setPath(this.sslEndPoint.substring(this.sslEndPoint.indexOf("/"), this.sslEndPoint.length()));
        }
        this.monitor.fireBeforeProxy(request, response, postMethod, hostConfiguration);
        if (this.settings.getBoolean("Reuse request state")) {
            if (this.httpState == null) {
                this.httpState = new HttpState();
            }
            HttpClientSupport.getHttpClient().executeMethod(hostConfiguration, (HttpMethod)postMethod, this.httpState);
        } else {
            HttpClientSupport.getHttpClient().executeMethod(hostConfiguration, (HttpMethod)postMethod);
        }
        capturedData.stopCapture();
        capturedData.setRequest(capture.getCapturedData());
        capturedData.setRawResponseBody(postMethod.getResponseBody());
        capturedData.setResponseHeader((HttpMethodBase)postMethod);
        capturedData.setRawRequestData(this.getRequestToBytes(request.toString(), (HttpMethodBase)postMethod, capture));
        capturedData.setRawResponseData(this.getResponseToBytes(response.toString(), (HttpMethodBase)postMethod, capturedData.getRawResponseBody()));
        this.monitor.fireAfterProxy(request, response, postMethod, capturedData);
        StringToStringMap responseHeaders = capturedData.getResponseHeaders();
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        for (String name : responseHeaders.keySet()) {
            String header = (String)responseHeaders.get(name);
            httpResponse.addHeader(name, header);
        }
        IO.copy((InputStream)new ByteArrayInputStream(capturedData.getRawResponseBody()), (OutputStream)httpResponse.getOutputStream());
        postMethod.releaseConnection();
        TunnelServlet tunnelServlet = this;
        synchronized (tunnelServlet) {
            this.monitor.addMessageExchange(capturedData);
        }
        capturedData = null;
    }

    private byte[] getResponseToBytes(String footer, HttpMethodBase postMethod, byte[] res) {
        Header[] headers;
        String response = footer;
        for (Header header : headers = postMethod.getResponseHeaders()) {
            response = response + header.toString();
        }
        response = response + "\n";
        response = response + XmlUtils.prettyPrintXml(new String(res));
        return response.getBytes();
    }

    private byte[] getRequestToBytes(String footer, HttpMethodBase postMethod, CaptureInputStream capture) {
        String request = footer;
        request = request + "\n";
        request = request + XmlUtils.prettyPrintXml(new String(capture.getCapturedData()));
        return request.getBytes();
    }
}

