/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.monitor.Connection;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitor;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitorEngine;
import com.eviware.soapui.impl.wsdl.monitor.SocketWaiter;
import java.util.Vector;

public class TcpMonMonitorEngine
implements SoapMonitorEngine {
    private SocketWaiter sw;
    private final Vector connections = new Vector();
    private int localPort;

    public void start(SoapMonitor monitor, int localPort) {
        this.localPort = localPort;
        this.sw = new SocketWaiter("Monitor on port " + localPort, monitor, localPort);
    }

    public void stop() {
        if (this.sw.isAlive()) {
            try {
                for (int i = 0; i < this.connections.size(); ++i) {
                    Connection conn = (Connection)this.connections.get(i);
                    conn.halt();
                }
                this.sw.halt();
            }
            catch (Throwable e) {
                SoapUI.log.info((Object)("Error stopping monitor: " + e.toString()));
            }
            SoapUI.log.info((Object)("Stopped SOAP Monitor on local port " + this.getLocalPort()));
        }
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public boolean isRunning() {
        return this.sw != null && this.sw.isAlive();
    }

    public boolean isProxy() {
        return true;
    }
}

