/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor;

import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitor;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitorEngine;
import com.eviware.soapui.impl.wsdl.monitor.jettyproxy.ProxyServlet;
import com.eviware.soapui.impl.wsdl.monitor.jettyproxy.Server;
import com.eviware.soapui.impl.wsdl.monitor.jettyproxy.TunnelServlet;
import com.eviware.soapui.support.UISupport;
import javax.servlet.Servlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

public class SoapMonitorEngineImpl
implements SoapMonitorEngine {
    private static final String ROOT = "/";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    Server server = new Server();
    SocketConnector connector = new SocketConnector();
    private SslSocketConnector sslConnector;
    private String sslEndpoint = null;
    private boolean proxyOrTunnel = true;

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public void start(SoapMonitor soapMonitor, int localPort) {
        XmlBeansSettingsImpl settings = soapMonitor.getProject().getSettings();
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(100);
        this.server.setThreadPool((ThreadPool)threadPool);
        Context context = new Context((HandlerContainer)this.server, ROOT, 0);
        if (this.sslEndpoint != null) {
            if (this.sslEndpoint.startsWith(HTTPS)) {
                this.sslConnector = new SslSocketConnector();
                this.sslConnector.setKeystore(settings.getString("HTTP tunnel - KeyStore", "JKS"));
                this.sslConnector.setPassword(settings.getString("HTTP tunnel - Password", ""));
                this.sslConnector.setKeyPassword(settings.getString("HTTP tunnel - KeyPassword", ""));
                this.sslConnector.setTruststore(settings.getString("HTTP tunnel - TrustStore", "JKS"));
                this.sslConnector.setTrustPassword(settings.getString("HTTP tunnel - TrustStore Password", ""));
                this.sslConnector.setNeedClientAuth(false);
                this.sslConnector.setMaxIdleTime(30000);
                this.sslConnector.setPort(localPort);
                this.server.addConnector((Connector)this.sslConnector);
                context.addServlet(new ServletHolder((Servlet)new TunnelServlet(soapMonitor, this.sslEndpoint)), ROOT);
            } else if (this.sslEndpoint.startsWith(HTTP)) {
                this.connector.setPort(localPort);
                this.server.addConnector((Connector)this.connector);
                context.addServlet(new ServletHolder((Servlet)new TunnelServlet(soapMonitor, this.sslEndpoint)), ROOT);
            } else {
                UISupport.showErrorMessage("Unsupported/unknown protocol tunnel will not start");
                return;
            }
            this.proxyOrTunnel = false;
        } else {
            this.proxyOrTunnel = true;
            this.connector.setPort(localPort);
            this.server.addConnector((Connector)this.connector);
            context.addServlet(new ServletHolder((Servlet)new ProxyServlet(soapMonitor)), ROOT);
        }
        try {
            this.server.start();
        }
        catch (Exception e) {
            UISupport.showErrorMessage("Error starting monitor: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        try {
            block4: {
                try {
                    if (this.server == null) break block4;
                    this.server.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var3_2 = null;
                    if (this.server == null) return;
                    this.server.destroy();
                    return;
                }
            }
            Object var3_1 = null;
            if (this.server == null) return;
            this.server.destroy();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.server == null) throw throwable;
            this.server.destroy();
            throw throwable;
        }
    }

    protected void setSslEndpoint(String sslEndpoint) {
        this.sslEndpoint = sslEndpoint;
    }

    public boolean isProxy() {
        return this.proxyOrTunnel;
    }
}

