/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock.dispatch;

import com.eviware.soapui.config.MockOperationDispatchStyleConfig;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatchFactory;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.mock.dispatch.QueryMatchMockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.mock.dispatch.RandomMockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.mock.dispatch.ScriptMockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.mock.dispatch.SequenceMockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.mock.dispatch.XPathMockOperationDispatcher;
import java.util.HashMap;
import java.util.Map;

public class MockOperationDispatchRegistry {
    private static Map<String, MockOperationDispatchFactory> factories = new HashMap<String, MockOperationDispatchFactory>();

    public static void putFactory(String type, MockOperationDispatchFactory factory) {
        factories.put(type, factory);
    }

    public static String[] getDispatchTypes() {
        return factories.keySet().toArray(new String[factories.size()]);
    }

    public static MockOperationDispatcher buildDispatcher(String type, WsdlMockOperation mockOperation) {
        return factories.get(type).build(mockOperation);
    }

    static {
        MockOperationDispatchRegistry.putFactory(MockOperationDispatchStyleConfig.SEQUENCE.toString(), new SequenceMockOperationDispatcher.Factory());
        MockOperationDispatchRegistry.putFactory(MockOperationDispatchStyleConfig.RANDOM.toString(), new RandomMockOperationDispatcher.Factory());
        MockOperationDispatchRegistry.putFactory(MockOperationDispatchStyleConfig.SCRIPT.toString(), new ScriptMockOperationDispatcher.Factory());
        MockOperationDispatchRegistry.putFactory(MockOperationDispatchStyleConfig.XPATH.toString(), new XPathMockOperationDispatcher.Factory());
        MockOperationDispatchRegistry.putFactory(MockOperationDispatchStyleConfig.QUERY_MATCH.toString(), new QueryMatchMockOperationDispatcher.Factory());
    }
}

