/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.MockOperationConfig;
import com.eviware.soapui.config.MockOperationDispatchStyleConfig;
import com.eviware.soapui.config.MockResponseConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatchRegistry;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.support.CompressedStringSupport;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.support.InterfaceListenerAdapter;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMockOperation
extends AbstractWsdlModelItem<MockOperationConfig>
implements MockOperation,
PropertyChangeListener {
    private static final Logger log = Logger.getLogger(WsdlMockOperation.class);
    public static final String DISPATCH_STYLE_PROPERTY = WsdlMockOperation.class.getName() + "@dispatchstyle";
    public static final String DEFAULT_RESPONSE_PROPERTY = WsdlMockOperation.class.getName() + "@defaultresponse";
    public static final String DISPATCH_PATH_PROPERTY = WsdlMockOperation.class.getName() + "@dispatchpath";
    public static final String OPERATION_PROPERTY = WsdlMockOperation.class.getName() + "@operation";
    private WsdlOperation operation;
    private MockOperationDispatcher dispatcher;
    private List<WsdlMockResponse> responses = new ArrayList<WsdlMockResponse>();
    private InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private InternalProjectListener projectListener = new InternalProjectListener();
    private ImageIcon oneWayIcon;
    private ImageIcon notificationIcon;
    private ImageIcon solicitResponseIcon;

    public WsdlMockOperation(WsdlMockService mockService, MockOperationConfig config) {
        super(config, mockService, "/mockOperation.gif");
        Interface iface = mockService.getProject().getInterfaceByName(config.getInterface());
        if (iface == null) {
            SoapUI.log.warn((Object)("Missing interface [" + config.getInterface() + "] for MockOperation in project"));
        } else {
            this.operation = (WsdlOperation)iface.getOperationByName(config.getOperation());
        }
        List responseConfigs = config.getResponseList();
        for (MockResponseConfig responseConfig : responseConfigs) {
            WsdlMockResponse wsdlMockResponse = new WsdlMockResponse(this, responseConfig);
            wsdlMockResponse.addPropertyChangeListener(this);
            this.responses.add(wsdlMockResponse);
        }
        this.initData(config);
    }

    private void initData(MockOperationConfig config) {
        if (!config.isSetName()) {
            config.setName(this.operation == null ? "<missing operation>" : this.operation.getName());
        }
        if (!config.isSetDefaultResponse() && this.responses.size() > 0) {
            this.setDefaultResponse(this.responses.get(0).getName());
        }
        if (!config.isSetDispatchStyle()) {
            config.setDispatchStyle(MockOperationDispatchStyleConfig.SEQUENCE);
        }
        if (!((MockOperationConfig)this.getConfig()).isSetDispatchConfig()) {
            ((MockOperationConfig)this.getConfig()).addNewDispatchConfig();
        }
        this.dispatcher = MockOperationDispatchRegistry.buildDispatcher(config.getDispatchStyle().toString(), this);
        if (this.operation != null) {
            this.operation.getInterface().getProject().addProjectListener(this.projectListener);
            this.operation.getInterface().addInterfaceListener(this.interfaceListener);
            this.operation.getInterface().addPropertyChangeListener(WsdlInterface.NAME_PROPERTY, this);
        }
        this.oneWayIcon = UISupport.createImageIcon("/onewaymockoperation.gif");
        this.notificationIcon = UISupport.createImageIcon("/mocknotificationoperation.gif");
        this.solicitResponseIcon = UISupport.createImageIcon("/mocksolicitresponseoperation.gif");
    }

    public WsdlMockOperation(WsdlMockService mockService, MockOperationConfig config, WsdlOperation operation) {
        super(config, mockService, "/mockOperation.gif");
        this.operation = operation;
        config.setInterface(operation.getInterface().getName());
        config.setOperation(operation.getName());
        this.initData(config);
        this.interfaceListener = new InternalInterfaceListener();
    }

    @Override
    public ImageIcon getIcon() {
        if (this.operation != null) {
            if (this.isOneWay()) {
                return this.oneWayIcon;
            }
            if (this.isNotification()) {
                return this.notificationIcon;
            }
            if (this.isSolicitResponse()) {
                return this.solicitResponseIcon;
            }
        }
        return super.getIcon();
    }

    @Override
    public WsdlMockService getMockService() {
        return (WsdlMockService)this.getParent();
    }

    @Override
    public WsdlMockResponse getMockResponseAt(int index) {
        return this.responses.get(index);
    }

    @Override
    public WsdlOperation getOperation() {
        return this.operation;
    }

    @Override
    public WsdlMockResponse getMockResponseByName(String name) {
        return (WsdlMockResponse)this.getWsdlModelItemByName(this.responses, name);
    }

    @Override
    public int getMockResponseCount() {
        return this.responses.size();
    }

    public WsdlMockResponse addNewMockResponse(MockResponseConfig responseConfig) {
        WsdlMockResponse mockResponse = new WsdlMockResponse(this, responseConfig);
        this.responses.add(mockResponse);
        if (this.responses.size() == 1) {
            this.setDefaultResponse(mockResponse.getName());
        }
        WsdlUtils.setDefaultWsaAction(mockResponse.getWsaConfig(), true);
        this.getMockService().fireMockResponseAdded(mockResponse);
        this.notifyPropertyChanged("mockResponses", null, mockResponse);
        return mockResponse;
    }

    public WsdlMockResponse addNewMockResponse(String name, boolean createResponse) {
        MockResponseConfig responseConfig = ((MockOperationConfig)this.getConfig()).addNewResponse();
        responseConfig.setName(name);
        responseConfig.addNewResponseContent();
        if (createResponse && this.getOperation() != null && this.getOperation().isBidirectional()) {
            boolean createOptional = SoapUI.getSettings().getBoolean(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS);
            CompressedStringSupport.setString(responseConfig.getResponseContent(), this.getOperation().createResponse(createOptional));
        }
        return this.addNewMockResponse(responseConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMockResponse(WsdlMockResponse mockResponse) {
        int ix = this.responses.indexOf(mockResponse);
        this.responses.remove(ix);
        mockResponse.removePropertyChangeListener(this);
        try {
            this.getMockService().fireMockResponseRemoved(mockResponse);
            Object var4_3 = null;
            mockResponse.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            mockResponse.release();
            ((MockOperationConfig)this.getConfig()).removeResponse(ix);
            throw throwable;
        }
        ((MockOperationConfig)this.getConfig()).removeResponse(ix);
    }

    public WsdlMockResult dispatchRequest(WsdlMockRequest request) throws DispatchException {
        try {
            request.setOperation(this.getOperation());
            WsdlMockResult result = new WsdlMockResult(request);
            if (this.getMockResponseCount() == 0) {
                throw new DispatchException("Missing MockResponse(s) in MockOperation [" + this.getName() + "]");
            }
            result.setMockOperation(this);
            WsdlMockResponse response = this.dispatcher.selectMockResponse(request, result);
            if (response == null) {
                response = this.getMockResponseByName(this.getDefaultResponse());
            }
            if (response == null) {
                throw new DispatchException("Failed to find MockResponse");
            }
            result.setMockResponse(response);
            response.execute(request, result);
            return result;
        }
        catch (Throwable e) {
            if (e instanceof DispatchException) {
                throw (DispatchException)e;
            }
            throw new DispatchException(e);
        }
    }

    @Override
    public void release() {
        super.release();
        if (this.dispatcher != null) {
            this.dispatcher.release();
        }
        for (WsdlMockResponse response : this.responses) {
            response.removePropertyChangeListener(this);
            response.release();
        }
        if (this.operation != null) {
            this.operation.getInterface().getProject().removeProjectListener(this.projectListener);
            this.operation.getInterface().removeInterfaceListener(this.interfaceListener);
            this.operation.getInterface().removePropertyChangeListener(WsdlInterface.NAME_PROPERTY, this);
        }
    }

    public String getDispatchStyle() {
        return String.valueOf(((MockOperationConfig)this.getConfig()).isSetDispatchStyle() ? ((MockOperationConfig)this.getConfig()).getDispatchStyle() : MockOperationDispatchStyleConfig.SEQUENCE);
    }

    public MockOperationDispatcher setDispatchStyle(String dispatchStyle) {
        String old = this.getDispatchStyle();
        if (this.dispatcher != null && dispatchStyle.equals(old)) {
            return this.dispatcher;
        }
        ((MockOperationConfig)this.getConfig()).setDispatchStyle(MockOperationDispatchStyleConfig.Enum.forString((String)dispatchStyle));
        if (this.dispatcher != null) {
            this.dispatcher.release();
        }
        if (!((MockOperationConfig)this.getConfig()).isSetDispatchConfig()) {
            ((MockOperationConfig)this.getConfig()).addNewDispatchConfig();
        }
        this.dispatcher = MockOperationDispatchRegistry.buildDispatcher(dispatchStyle, this);
        this.notifyPropertyChanged(DISPATCH_STYLE_PROPERTY, old, dispatchStyle);
        return this.dispatcher;
    }

    public String getDispatchPath() {
        return ((MockOperationConfig)this.getConfig()).getDispatchPath();
    }

    public void setDispatchPath(String dispatchPath) {
        String old = this.getDispatchPath();
        ((MockOperationConfig)this.getConfig()).setDispatchPath(dispatchPath);
        this.notifyPropertyChanged(DISPATCH_PATH_PROPERTY, old, dispatchPath);
    }

    public String getWsdlOperationName() {
        return this.operation == null ? null : this.operation.getName();
    }

    public String getDefaultResponse() {
        return ((MockOperationConfig)this.getConfig()).getDefaultResponse();
    }

    public void setDefaultResponse(String defaultResponse) {
        String old = this.getDefaultResponse();
        ((MockOperationConfig)this.getConfig()).setDefaultResponse(defaultResponse);
        this.notifyPropertyChanged(DEFAULT_RESPONSE_PROPERTY, old, defaultResponse);
    }

    @Override
    public List<MockResponse> getMockResponses() {
        return new ArrayList<MockResponse>(this.responses);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getPropertyName().equals(WsdlMockResponse.NAME_PROPERTY)) {
            if (arg0.getOldValue().equals(this.getDefaultResponse())) {
                this.setDefaultResponse(arg0.getNewValue().toString());
            }
        } else if (arg0.getPropertyName().equals(WsdlInterface.NAME_PROPERTY)) {
            ((MockOperationConfig)this.getConfig()).setInterface(arg0.getNewValue().toString());
        }
    }

    @Override
    public WsdlMockResult getLastMockResult() {
        WsdlMockResult result = null;
        for (WsdlMockResponse response : this.responses) {
            WsdlMockResult mockResult = response.getMockResult();
            if (mockResult == null || result != null && result.getTimestamp() <= mockResult.getTimestamp()) continue;
            result = mockResult;
        }
        return result;
    }

    public void setOperation(WsdlOperation operation) {
        WsdlOperation oldOperation = this.getOperation();
        if (operation == null) {
            ((MockOperationConfig)this.getConfig()).unsetInterface();
            ((MockOperationConfig)this.getConfig()).unsetOperation();
        } else {
            ((MockOperationConfig)this.getConfig()).setInterface(operation.getInterface().getName());
            ((MockOperationConfig)this.getConfig()).setOperation(operation.getName());
        }
        this.operation = operation;
        this.notifyPropertyChanged(OPERATION_PROPERTY, oldOperation, operation);
    }

    public MockOperationDispatcher getMockOperationDispatcher() {
        return this.dispatcher;
    }

    public boolean isOneWay() {
        return this.operation == null ? false : this.operation.isOneWay();
    }

    public boolean isNotification() {
        return this.operation == null ? false : this.operation.isNotification();
    }

    public boolean isSolicitResponse() {
        return this.operation == null ? false : this.operation.isSolicitResponse();
    }

    public boolean isUnidirectional() {
        return this.operation == null ? false : this.operation.isUnidirectional();
    }

    public boolean isBidirectional() {
        return !this.isUnidirectional();
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.responses;
    }

    public void exportMockOperation(File file) {
        try {
            ((MockOperationConfig)this.getConfig()).newCursor().save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class InternalProjectListener
    extends ProjectListenerAdapter {
        private InternalProjectListener() {
        }

        public void interfaceRemoved(Interface iface) {
            if (WsdlMockOperation.this.operation.getInterface() == iface) {
                WsdlMockOperation.this.getMockService().removeMockOperation(WsdlMockOperation.this);
            }
        }

        public void interfaceUpdated(Interface iface) {
            if (WsdlMockOperation.this.operation.getInterface() == iface) {
                ((MockOperationConfig)WsdlMockOperation.this.getConfig()).setInterface(iface.getName());
            }
        }
    }

    private class InternalInterfaceListener
    extends InterfaceListenerAdapter {
        private InternalInterfaceListener() {
        }

        public void operationUpdated(Operation operation) {
            if (operation == WsdlMockOperation.this.operation) {
                ((MockOperationConfig)WsdlMockOperation.this.getConfig()).setOperation(operation.getName());
            }
        }

        public void operationRemoved(Operation operation) {
            if (operation == WsdlMockOperation.this.operation) {
                WsdlMockOperation.this.getMockService().removeMockOperation(WsdlMockOperation.this);
            }
        }
    }
}

