/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.endpoint;

import com.eviware.soapui.config.EndpointConfig;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.support.http.HttpRequestTestStep;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.endpoint.DefaultEndpointStrategy;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainer;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.MetricsPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class DefaultEndpointStrategyConfigurationPanel
extends JPanel
implements PropertyChangeListener {
    private EndpointsTableModel tableModel;
    private JTable table;
    private JButton deleteButton;
    private JButton assignButton;
    private Interface iface;
    private final DefaultEndpointStrategy strategy;

    public DefaultEndpointStrategyConfigurationPanel(Interface iface, DefaultEndpointStrategy strategy) {
        super(new BorderLayout());
        this.iface = iface;
        this.strategy = strategy;
        this.buildUI();
        this.enableButtons();
    }

    private void buildUI() {
        this.tableModel = this.iface instanceof WsdlInterface ? new WsdlEndpointsTableModel() : new RestEndpointsTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DefaultEndpointStrategyConfigurationPanel.this.enableButtons();
            }
        });
        for (int c = 0; c < this.table.getColumnCount(); ++c) {
            this.table.getColumnModel().getColumn(c).setHeaderRenderer(new MetricsPanel.InternalHeaderRenderer(this.getBackground()));
        }
        this.table.getColumnModel().getColumn(0).setPreferredWidth(250);
        if (this.iface instanceof WsdlInterface) {
            JComboBox<String> wssTypeCombo = new JComboBox<String>(new String[]{"None", "PasswordText", "PasswordDigest"});
            wssTypeCombo.setEditable(true);
            this.table.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(wssTypeCombo));
            this.table.getColumnModel().getColumn(6).setCellEditor(new OutgoingWssCellEditor(((WsdlInterface)this.iface).getProject().getWssContainer()));
            this.table.getColumnModel().getColumn(7).setCellEditor(new IncomingWssCellEditor(((WsdlInterface)this.iface).getProject().getWssContainer()));
            this.table.getColumnModel().getColumn(8).setCellEditor(new DefaultCellEditor(new JComboBox<String>(new String[]{EndpointConfig.Mode.OVERRIDE.toString(), EndpointConfig.Mode.COMPLEMENT.toString(), EndpointConfig.Mode.COPY.toString()})));
        }
        this.table.getTableHeader().setReorderingAllowed(false);
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setBackground(Color.WHITE);
        this.add((Component)scrollPane, "Center");
        this.add(this.createButtons(), "North");
        this.iface.addPropertyChangeListener("endpoints", this);
    }

    protected void enableButtons() {
        this.deleteButton.setEnabled(this.table.getSelectedRow() != -1);
        this.assignButton.setEnabled(this.table.getSelectedRow() != -1);
    }

    private Component createButtons() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new AddAction()));
        this.deleteButton = UISupport.createToolbarButton(new DeleteAction());
        toolbar.addFixed(this.deleteButton);
        toolbar.addRelatedGap();
        this.assignButton = new JButton(new AssignAction());
        toolbar.addFixed(this.assignButton);
        toolbar.addGlue();
        ShowOnlineHelpAction showOnlineHelpAction = new ShowOnlineHelpAction("http://www.soapui.org/userguide/interfaces/endpoints.html");
        toolbar.addFixed(UISupport.createToolbarButton(showOnlineHelpAction));
        return toolbar;
    }

    public void release() {
        this.iface.removePropertyChangeListener("endpoints", this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.tableModel.refresh();
    }

    private static class OutgoingWssCellEditor
    extends DefaultCellEditor {
        private final WssContainer wssContainer;

        public OutgoingWssCellEditor(WssContainer wssContainer) {
            super(new JComboBox());
            this.wssContainer = wssContainer;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox comboBox = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(this.wssContainer.getOutgoingWssNames());
            model.addElement("");
            comboBox.setModel(model);
            return comboBox;
        }
    }

    private static class IncomingWssCellEditor
    extends DefaultCellEditor {
        private final WssContainer wssContainer;

        public IncomingWssCellEditor(WssContainer wssContainer) {
            super(new JComboBox());
            this.wssContainer = wssContainer;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox comboBox = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(this.wssContainer.getIncomingWssNames());
            model.addElement("");
            comboBox.setModel(model);
            return comboBox;
        }
    }

    private class WsdlEndpointsTableModel
    extends EndpointsTableModel {
        private WsdlEndpointsTableModel() {
        }

        public int getColumnCount() {
            return 9;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Endpoint";
                }
                case 1: {
                    return "Username";
                }
                case 2: {
                    return "Password";
                }
                case 3: {
                    return "Domain";
                }
                case 4: {
                    return "WSS-Type";
                }
                case 5: {
                    return "WSS-TimeToLive";
                }
                case 6: {
                    return "Outgoing WSS";
                }
                case 7: {
                    return "Incoming WSS";
                }
                case 8: {
                    return "Mode";
                }
            }
            return null;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            String endpoint = this.getEndpointAt(rowIndex);
            DefaultEndpointStrategy.EndpointDefaults defaults = DefaultEndpointStrategyConfigurationPanel.this.strategy.getEndpointDefaults(endpoint);
            switch (columnIndex) {
                case 0: {
                    return endpoint;
                }
                case 1: {
                    return defaults.getUsername();
                }
                case 2: {
                    return defaults.getPassword();
                }
                case 3: {
                    return defaults.getDomain();
                }
                case 4: {
                    return defaults.getWssType();
                }
                case 5: {
                    return defaults.getWssTimeToLive();
                }
                case 6: {
                    return defaults.getOutgoingWss();
                }
                case 7: {
                    return defaults.getIncomingWss();
                }
                case 8: {
                    return defaults.getMode();
                }
            }
            return null;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            String endpoint = this.getEndpointAt(rowIndex);
            DefaultEndpointStrategy.EndpointDefaults defaults = DefaultEndpointStrategyConfigurationPanel.this.strategy.getEndpointDefaults(endpoint);
            if (aValue == null) {
                aValue = "";
            }
            switch (columnIndex) {
                case 0: {
                    DefaultEndpointStrategyConfigurationPanel.this.iface.changeEndpoint(endpoint, aValue.toString());
                    break;
                }
                case 1: {
                    defaults.setUsername(aValue.toString());
                    break;
                }
                case 2: {
                    defaults.setPassword(aValue.toString());
                    break;
                }
                case 3: {
                    defaults.setDomain(aValue.toString());
                    break;
                }
                case 4: {
                    defaults.setWssType(aValue.toString());
                    break;
                }
                case 5: {
                    defaults.setWssTimeToLive(aValue.toString());
                    break;
                }
                case 6: {
                    defaults.setOutgoingWss(aValue.toString());
                    break;
                }
                case 7: {
                    defaults.setIncomingWss(aValue.toString());
                    break;
                }
                case 8: {
                    defaults.setMode(EndpointConfig.Mode.Enum.forString((String)aValue.toString()));
                }
            }
        }
    }

    private class RestEndpointsTableModel
    extends EndpointsTableModel {
        private RestEndpointsTableModel() {
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Endpoint";
                }
                case 1: {
                    return "Username";
                }
                case 2: {
                    return "Password";
                }
                case 3: {
                    return "Domain";
                }
                case 4: {
                    return "Mode";
                }
            }
            return null;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            String endpoint = this.getEndpointAt(rowIndex);
            DefaultEndpointStrategy.EndpointDefaults defaults = DefaultEndpointStrategyConfigurationPanel.this.strategy.getEndpointDefaults(endpoint);
            switch (columnIndex) {
                case 0: {
                    return endpoint;
                }
                case 1: {
                    return defaults.getUsername();
                }
                case 2: {
                    return defaults.getPassword();
                }
                case 3: {
                    return defaults.getDomain();
                }
                case 4: {
                    return defaults.getMode();
                }
            }
            return null;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            String endpoint = this.getEndpointAt(rowIndex);
            DefaultEndpointStrategy.EndpointDefaults defaults = DefaultEndpointStrategyConfigurationPanel.this.strategy.getEndpointDefaults(endpoint);
            if (aValue == null) {
                aValue = "";
            }
            switch (columnIndex) {
                case 0: {
                    DefaultEndpointStrategyConfigurationPanel.this.iface.changeEndpoint(endpoint, aValue.toString());
                    break;
                }
                case 1: {
                    defaults.setUsername(aValue.toString());
                    break;
                }
                case 2: {
                    defaults.setPassword(aValue.toString());
                    break;
                }
                case 3: {
                    defaults.setDomain(aValue.toString());
                    break;
                }
                case 4: {
                    defaults.setMode(EndpointConfig.Mode.Enum.forString((String)aValue.toString()));
                }
            }
        }
    }

    private abstract class EndpointsTableModel
    extends AbstractTableModel {
        private EndpointsTableModel() {
        }

        public String getEndpointAt(int selectedIndex) {
            return DefaultEndpointStrategyConfigurationPanel.this.iface.getEndpoints()[selectedIndex];
        }

        public DefaultEndpointStrategy.EndpointDefaults getDefaultsAt(int selectedIndex) {
            String endpoint = this.getEndpointAt(selectedIndex);
            return DefaultEndpointStrategyConfigurationPanel.this.strategy.getEndpointDefaults(endpoint);
        }

        public void addEndpoint(String endpoint) {
            int rowCount = this.getRowCount();
            DefaultEndpointStrategyConfigurationPanel.this.iface.addEndpoint(endpoint);
            this.fireTableRowsInserted(rowCount, rowCount);
        }

        public void removeEndpoint(int index) {
            String ep = this.getEndpointAt(index);
            DefaultEndpointStrategyConfigurationPanel.this.iface.removeEndpoint(ep);
            this.fireTableRowsDeleted(index, index);
        }

        public int getRowCount() {
            return DefaultEndpointStrategyConfigurationPanel.this.iface == null ? 0 : DefaultEndpointStrategyConfigurationPanel.this.iface.getEndpoints().length;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public void refresh() {
            this.fireTableDataChanged();
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Deletes the selected endpoint from the list");
        }

        public void actionPerformed(ActionEvent e) {
            int index = DefaultEndpointStrategyConfigurationPanel.this.table.getSelectedRow();
            if (index == -1) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (UISupport.confirm("Delete selected endpoint?", "Delete Endpoint")) {
                DefaultEndpointStrategyConfigurationPanel.this.tableModel.removeEndpoint(index);
            }
        }
    }

    private class AssignAction
    extends AbstractAction {
        private static final String ALL_REQUESTS = "- All Requests -";
        private static final String ALL_TEST_REQUESTS = "- All Test Requests -";
        private static final String ALL_REQUESTS_AND_TEST_REQUESTS = "- All Requests and TestRequests -";
        private static final String ALL_REQUESTS_WITH_NO_ENDPOINT = "- All Requests with no endpoint -";

        public AssignAction() {
            super("Assign");
            this.putValue("ShortDescription", "Assigns the selected endpoint to Requests/TestRequests for this Interface");
        }

        public void actionPerformed(ActionEvent e) {
            int selectedIndex = DefaultEndpointStrategyConfigurationPanel.this.table.getSelectedRow();
            if (selectedIndex == -1) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String selectedEndpoint = DefaultEndpointStrategyConfigurationPanel.this.tableModel.getEndpointAt(selectedIndex);
            DefaultEndpointStrategy.EndpointDefaults defaults = DefaultEndpointStrategyConfigurationPanel.this.tableModel.getDefaultsAt(selectedIndex);
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(DefaultEndpointStrategyConfigurationPanel.this.iface.getEndpoints()));
            list.add(0, ALL_REQUESTS);
            list.add(1, ALL_TEST_REQUESTS);
            list.add(2, ALL_REQUESTS_AND_TEST_REQUESTS);
            list.add(3, ALL_REQUESTS_WITH_NO_ENDPOINT);
            Object endpoint = UISupport.prompt("Assign selected endpoint and authorization to..", "Assign Endpoint", list.toArray(), ALL_REQUESTS_WITH_NO_ENDPOINT);
            if (endpoint == null) {
                return;
            }
            if (endpoint.equals(ALL_REQUESTS) || endpoint.equals(ALL_REQUESTS_WITH_NO_ENDPOINT) || endpoint.equals(ALL_REQUESTS_AND_TEST_REQUESTS)) {
                for (Operation operation : DefaultEndpointStrategyConfigurationPanel.this.iface.getAllOperations()) {
                    for (int i = 0; i < operation.getRequestCount(); ++i) {
                        AbstractHttpRequest request = (AbstractHttpRequest)operation.getRequestAt(i);
                        String ep = request.getEndpoint();
                        if (!endpoint.equals(ALL_REQUESTS) && !endpoint.equals(ALL_REQUESTS_AND_TEST_REQUESTS) && (!endpoint.equals(ALL_REQUESTS_WITH_NO_ENDPOINT) || ep != null) && !ep.equals(endpoint)) continue;
                        request.setEndpoint(selectedEndpoint);
                        request.setUsername(defaults.getUsername());
                        request.setPassword(defaults.getPassword());
                        request.setDomain(defaults.getDomain());
                        if (!(request instanceof WsdlRequest)) continue;
                        ((WsdlRequest)request).setWssPasswordType(defaults.getWssType());
                        ((WsdlRequest)request).setWssTimeToLive(defaults.getWssTimeToLive());
                        ((WsdlRequest)request).setOutgoingWss(defaults.getOutgoingWss());
                        ((WsdlRequest)request).setIncomingWss(defaults.getIncomingWss());
                    }
                }
            }
            if (endpoint.equals(ALL_REQUESTS_AND_TEST_REQUESTS) || endpoint.equals(ALL_TEST_REQUESTS)) {
                for (TestSuite testSuite : DefaultEndpointStrategyConfigurationPanel.this.iface.getProject().getTestSuiteList()) {
                    for (TestCase testCase : testSuite.getTestCaseList()) {
                        for (TestStep testStep : testCase.getTestStepList()) {
                            AbstractHttpRequest<?> httpRequest;
                            if (!(testStep instanceof HttpRequestTestStep) || (httpRequest = ((HttpRequestTestStep)testStep).getHttpRequest()).getOperation() == null || httpRequest.getOperation().getInterface() != DefaultEndpointStrategyConfigurationPanel.this.iface) continue;
                            httpRequest.setEndpoint(selectedEndpoint);
                            httpRequest.setUsername(defaults.getUsername());
                            httpRequest.setPassword(defaults.getPassword());
                            httpRequest.setDomain(defaults.getDomain());
                            if (!(httpRequest instanceof WsdlRequest)) continue;
                            WsdlTestRequest testRequest = (WsdlTestRequest)httpRequest;
                            testRequest.setWssPasswordType(defaults.getWssType());
                            testRequest.setWssTimeToLive(defaults.getWssTimeToLive());
                            testRequest.setOutgoingWss(defaults.getOutgoingWss());
                            testRequest.setIncomingWss(defaults.getIncomingWss());
                        }
                    }
                }
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a new endpoint to the list");
        }

        public void actionPerformed(ActionEvent e) {
            String endpoint = UISupport.prompt("Enter new endpoint URL", "Add Endpoint", "");
            if (endpoint == null) {
                return;
            }
            DefaultEndpointStrategyConfigurationPanel.this.tableModel.addEndpoint(endpoint);
        }
    }
}

