/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.teststep;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneTestStepAction
extends AbstractSoapUIAction<WsdlTestStep> {
    private static final String CREATE_NEW_OPTION = "<Create New>";
    private XFormDialog dialog;

    public CloneTestStepAction() {
        super("Clone TestStep", "Clones this TestStep");
    }

    @Override
    public void perform(WsdlTestStep testStep, Object param) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.getFormField("Target Project").addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    if (newValue.equals(CloneTestStepAction.CREATE_NEW_OPTION)) {
                        CloneTestStepAction.this.dialog.setOptions("Target TestSuite", new String[]{CloneTestStepAction.CREATE_NEW_OPTION});
                        CloneTestStepAction.this.dialog.setOptions("Target TestCase", new String[]{CloneTestStepAction.CREATE_NEW_OPTION});
                    } else {
                        Project project = SoapUI.getWorkspace().getProjectByName(newValue);
                        Object[] names = ModelSupport.getNames(project.getTestSuiteList(), new String[]{CloneTestStepAction.CREATE_NEW_OPTION});
                        CloneTestStepAction.this.dialog.setOptions("Target TestSuite", names);
                        CloneTestStepAction.this.dialog.setValue("Target TestSuite", (String)names[0]);
                        if (names.length > 1) {
                            TestSuite testSuite = project.getTestSuiteByName((String)names[0]);
                            CloneTestStepAction.this.dialog.setOptions("Target TestCase", ModelSupport.getNames(testSuite.getTestCaseList(), new String[]{CloneTestStepAction.CREATE_NEW_OPTION}));
                        } else {
                            CloneTestStepAction.this.dialog.setOptions("Target TestCase", new String[]{CloneTestStepAction.CREATE_NEW_OPTION});
                        }
                    }
                }
            });
            this.dialog.getFormField("Target TestSuite").addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    if (newValue.equals(CloneTestStepAction.CREATE_NEW_OPTION)) {
                        CloneTestStepAction.this.dialog.setOptions("Target TestCase", new String[]{CloneTestStepAction.CREATE_NEW_OPTION});
                    } else {
                        Object[] objectArray;
                        String projectName = CloneTestStepAction.this.dialog.getValue("Target Project");
                        Project project = SoapUI.getWorkspace().getProjectByName(projectName);
                        TestSuite testSuite = project.getTestSuiteByName(newValue);
                        XFormDialog xFormDialog = CloneTestStepAction.this.dialog;
                        if (testSuite == null) {
                            Object[] objectArray2 = new String[1];
                            objectArray = objectArray2;
                            objectArray2[0] = CloneTestStepAction.CREATE_NEW_OPTION;
                        } else {
                            objectArray = ModelSupport.getNames(testSuite.getTestCaseList(), new String[]{CloneTestStepAction.CREATE_NEW_OPTION});
                        }
                        xFormDialog.setOptions("Target TestCase", objectArray);
                    }
                }
            });
        }
        this.dialog.setBooleanValue("Move Instead", false);
        this.dialog.setValue("TestStep Name", "Copy of " + testStep.getName());
        WorkspaceImpl workspace = testStep.getTestCase().getTestSuite().getProject().getWorkspace();
        this.dialog.setOptions("Target Project", ModelSupport.getNames(workspace.getOpenProjectList(), new String[]{CREATE_NEW_OPTION}));
        this.dialog.setValue("Target Project", testStep.getTestCase().getTestSuite().getProject().getName());
        this.dialog.setOptions("Target TestSuite", ModelSupport.getNames(testStep.getTestCase().getTestSuite().getProject().getTestSuiteList(), new String[]{CREATE_NEW_OPTION}));
        this.dialog.setValue("Target TestSuite", testStep.getTestCase().getTestSuite().getName());
        this.dialog.setOptions("Target TestCase", ModelSupport.getNames(testStep.getTestCase().getTestSuite().getTestCaseList(), new String[]{CREATE_NEW_OPTION}));
        this.dialog.setValue("Target TestCase", testStep.getTestCase().getName());
        if (this.dialog.show()) {
            boolean move;
            WsdlTestStep newTestStep;
            String targetProjectName = this.dialog.getValue("Target Project");
            String targetTestSuiteName = this.dialog.getValue("Target TestSuite");
            String targetTestCaseName = this.dialog.getValue("Target TestCase");
            String name = this.dialog.getValue("TestStep Name");
            WsdlProject project = testStep.getTestCase().getTestSuite().getProject();
            WsdlTestSuite targetTestSuite = null;
            WsdlTestCase targetTestCase = null;
            HashSet<Interface> requiredInterfaces = new HashSet<Interface>();
            if (!targetProjectName.equals(project.getName())) {
                requiredInterfaces.addAll(testStep.getRequiredInterfaces());
                project = (WsdlProject)workspace.getProjectByName(targetProjectName);
                if (project == null) {
                    targetProjectName = UISupport.prompt("Enter name for new Project", "Clone TestStep", "");
                    if (targetProjectName == null) {
                        return;
                    }
                    try {
                        project = workspace.createProject(targetProjectName, null);
                    }
                    catch (SoapUIException e) {
                        UISupport.showErrorMessage(e);
                    }
                    if (project == null) {
                        return;
                    }
                }
                if (requiredInterfaces.size() > 0 && project.getInterfaceCount() > 0) {
                    HashMap<String, Interface> bindings = new HashMap<String, Interface>();
                    for (Interface iface : requiredInterfaces) {
                        bindings.put(iface.getTechnicalId(), iface);
                    }
                    for (Interface iface : project.getInterfaceList()) {
                        bindings.remove(iface.getTechnicalId());
                    }
                    requiredInterfaces.retainAll(bindings.values());
                }
                if (requiredInterfaces.size() > 0) {
                    String msg = "Target project [" + targetProjectName + "] is missing required Interfaces;\r\n\r\n";
                    for (Interface iface : requiredInterfaces) {
                        msg = msg + iface.getName() + " [" + iface.getTechnicalId() + "]\r\n";
                    }
                    if (!UISupport.confirm(msg = msg + "\r\nThese will be cloned to the targetProject as well", "Clone TestStep")) {
                        return;
                    }
                    for (Interface iface : requiredInterfaces) {
                        project.importInterface((AbstractInterface)iface, true, true);
                    }
                }
            }
            if ((targetTestSuite = project.getTestSuiteByName(targetTestSuiteName)) == null) {
                targetTestSuiteName = UISupport.prompt("Specify name for new TestSuite", "Clone TestStep", "Copy of " + testStep.getTestCase().getTestSuite().getName());
                if (targetTestSuiteName == null) {
                    return;
                }
                targetTestSuite = project.addNewTestSuite(targetTestSuiteName);
            }
            if ((targetTestCase = targetTestSuite.getTestCaseByName(targetTestCaseName)) == null) {
                targetTestCaseName = UISupport.prompt("Specify name for new TestCase", "Clone TestStep", "Copy of " + testStep.getTestCase().getName());
                if (targetTestCaseName == null) {
                    return;
                }
                targetTestCase = targetTestSuite.addNewTestCase(targetTestCaseName);
            }
            if ((newTestStep = targetTestCase.importTestStep(testStep, name, -1, !(move = this.dialog.getBooleanValue("Move Instead")))) == null) {
                return;
            }
            if (this.dialog.getBooleanValue("Open Editor")) {
                UISupport.selectAndShow(newTestStep);
            } else {
                UISupport.select(newTestStep);
            }
            if (move) {
                testStep.getTestCase().removeTestStep(testStep);
            }
        }
    }

    @AForm(description="Specify target Project/TestSuite/TestCase and name of cloned TestStep", name="Clone TestStep", helpUrl="http://www.soapui.org/userguide/functional/testcases.html#Clone_TestSteps", icon="/applications-system.png")
    protected static interface Form {
        @AField(name="TestStep Name", description="The name of the cloned TestStep", type=AField.AFieldType.STRING)
        public static final String NAME = "TestStep Name";
        @AField(name="Target TestCase", description="The target TestCase for the cloned TestStep", type=AField.AFieldType.ENUMERATION)
        public static final String TESTCASE = "Target TestCase";
        @AField(name="Target TestSuite", description="The target TestSuite for the cloned TestStep", type=AField.AFieldType.ENUMERATION)
        public static final String TESTSUITE = "Target TestSuite";
        @AField(name="Target Project", description="The target Project for the cloned TestStep", type=AField.AFieldType.ENUMERATION)
        public static final String PROJECT = "Target Project";
        @AField(name="Move Instead", description="Moves the selected TestStep instead of copying", type=AField.AFieldType.BOOLEAN)
        public static final String MOVE = "Move Instead";
        @AField(name="Open Editor", description="Opens the editor for the cloned TestStep", type=AField.AFieldType.BOOLEAN)
        public static final String OPEN = "Open Editor";
    }
}

