/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.support.WadlImporter;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddWadlAction
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "NewWsdlProjectAction";
    private XFormDialog dialog;
    public static final MessageSupport messages = MessageSupport.getMessages(AddWadlAction.class);

    public AddWadlAction() {
        super(messages.get("Title"), messages.get("Description"));
    }

    @Override
    public void perform(WsdlProject project, Object param) {
        DefaultPropertyExpansionContext context = new DefaultPropertyExpansionContext(project.getModelItem());
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.getFormField(Form.INITIALWSDL).addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    String value = newValue.toLowerCase().trim();
                    AddWadlAction.this.dialog.getFormField(Form.GENERATETESTSUITE).setEnabled(newValue.trim().length() > 0);
                }
            });
        } else {
            this.dialog.setValue(Form.INITIALWSDL, "");
            this.dialog.getFormField(Form.GENERATETESTSUITE).setEnabled(false);
        }
        while (this.dialog.show()) {
            try {
                String url = this.dialog.getValue(Form.INITIALWSDL).trim();
                if (!StringUtils.hasContent(url)) continue;
                String expUrl = PathUtils.expandPath(url, project);
                if (new File(expUrl).exists()) {
                    expUrl = new File(expUrl).toURI().toURL().toString();
                }
                RestService result = this.importWadl(project, expUrl);
                if (url.equals(expUrl) || result == null) break;
                result.setWadlUrl(url);
                break;
            }
            catch (Exception ex) {
                UISupport.showErrorMessage(ex);
            }
        }
    }

    private RestService importWadl(WsdlProject project, String url) {
        RestService restService = (RestService)project.addNewInterface(project.getName(), "rest");
        UISupport.select(restService);
        try {
            new WadlImporter(restService).initFromWadl(url);
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
        return restService;
    }

    @AForm(name="Form.Title", description="Form.Description", helpUrl="http://www.soapui.org/userguide/projects/index.html#Creating_a_WSDL_Projects", icon="/applications-system.png")
    public static interface Form {
        @AField(description="Form.InitialWadl.Description", type=AField.AFieldType.FILE)
        public static final String INITIALWSDL = messages.get("Form.InitialWadl.Label");
        @AField(description="Form.GenerateTestSuite.Description", type=AField.AFieldType.BOOLEAN, enabled=false)
        public static final String GENERATETESTSUITE = messages.get("Form.GenerateTestSuite.Label");
    }
}

