/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.mockresponse;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.support.AbstractAddToTestCaseAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestRequestStepFactory;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTestRequestForMockResponseAction
extends AbstractAddToTestCaseAction<WsdlMockResponse> {
    public static final String SOAPUI_ACTION_ID = "CreateTestRequestForMockResponseAction";
    private static final String STEP_NAME = "Name";
    private static final String ADD_SOAP_FAULT_ASSERTION = "Add Not SOAP Fault Assertion";
    private static final String ADD_SOAP_RESPONSE_ASSERTION = "Add SOAP Response Assertion";
    private static final String ADD_SCHEMA_ASSERTION = "Add Schema Assertion";
    private XFormDialog dialog;
    private StringToStringMap dialogValues = new StringToStringMap();

    public CreateTestRequestForMockResponseAction() {
        super("Create TestRequest", "Creates a TestRequest for this MockResponse in a TestCase");
    }

    @Override
    public void perform(WsdlMockResponse mockResponse, Object param) {
        WsdlProject project = (WsdlProject)ModelSupport.getModelItemProject(mockResponse);
        WsdlTestCase testCase = this.getTargetTestCase(project);
        if (testCase != null) {
            this.addRequest(testCase, mockResponse, -1);
        }
    }

    public WsdlTestRequestStep addRequest(WsdlTestCase testCase, WsdlMockResponse mockResponse, int position) {
        if (this.dialog == null) {
            this.buildDialog();
        }
        this.dialogValues.put(STEP_NAME, mockResponse.getMockOperation().getName() + " - " + mockResponse.getName());
        boolean enabled = mockResponse.getMockOperation().getOperation().isBidirectional();
        this.dialog.getFormField(ADD_SCHEMA_ASSERTION).setEnabled(enabled);
        this.dialog.getFormField(ADD_SOAP_FAULT_ASSERTION).setEnabled(enabled);
        this.dialog.getFormField(ADD_SOAP_RESPONSE_ASSERTION).setEnabled(enabled);
        this.dialogValues = this.dialog.show(this.dialogValues);
        if (this.dialog.getReturnValue() != 1) {
            return null;
        }
        String name = (String)this.dialogValues.get(STEP_NAME);
        WsdlTestRequestStep testStep = (WsdlTestRequestStep)testCase.insertTestStep(WsdlTestRequestStepFactory.createConfig(mockResponse.getMockOperation().getOperation(), name), position);
        if (testStep == null) {
            return null;
        }
        if (enabled) {
            if (this.dialogValues.getBoolean(ADD_SOAP_RESPONSE_ASSERTION)) {
                testStep.getTestRequest().addAssertion("SOAP Response");
            }
            if (this.dialogValues.getBoolean(ADD_SCHEMA_ASSERTION)) {
                testStep.getTestRequest().addAssertion("Schema Compliance");
            }
            if (this.dialogValues.getBoolean(ADD_SOAP_FAULT_ASSERTION)) {
                testStep.getTestRequest().addAssertion("Not SOAP Fault");
            }
        }
        testStep.getTestRequest().setEndpoint(mockResponse.getMockOperation().getMockService().getLocalEndpoint());
        UISupport.selectAndShow(testStep);
        return testStep;
    }

    private void buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Create TestRequest");
        XForm mainForm = builder.createForm("Basic");
        mainForm.addTextField(STEP_NAME, "Name of TestRequest Step", XForm.FieldType.URL).setWidth(30);
        mainForm.addCheckBox(ADD_SOAP_RESPONSE_ASSERTION, "(adds validation that response is a SOAP message)");
        mainForm.addCheckBox(ADD_SCHEMA_ASSERTION, "(adds validation that response complies with its schema)");
        mainForm.addCheckBox(ADD_SOAP_FAULT_ASSERTION, "(adds validation that response is not a SOAP Fault)");
        this.dialog = builder.buildDialog(builder.buildOkCancelActions(), "Specify options for creating the TestRequest", UISupport.OPTIONS_ICON);
        this.dialogValues.put(ADD_SOAP_RESPONSE_ASSERTION, Boolean.TRUE.toString());
    }
}

