/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.oracle;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ProcessToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.settings.ToolsSettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleWsaGenProxyAction
extends AbstractToolsAction<Interface> {
    private static final String OUTPUT = "Output Directory";
    private static final String PACKAGE = "Destination Package";
    public static final String SOAPUI_ACTION_ID = "OracleWsaGenProxyAction";

    public OracleWsaGenProxyAction() {
        super("Oracle Proxy Artifacts", "Generates Oracle Proxy artifacts using the wsa.jar utility");
    }

    @Override
    protected XFormDialog buildDialog(Interface modelItem) {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Oracle Artifacts");
        XForm mainForm = builder.createForm("Basic");
        this.addWSDLFields(mainForm, modelItem);
        mainForm.addTextField(OUTPUT, "The root directory for all emitted files.", XForm.FieldType.PROJECT_FOLDER);
        mainForm.addTextField(PACKAGE, "The target package for generated classes", XForm.FieldType.JAVA_PACKAGE);
        this.buildArgsForm(builder, true, "wsa");
        ActionList actions = this.buildDefaultActions("http://www.soapui.org/userguide/tools/topdown.html#Oracle_WSA", modelItem);
        return builder.buildDialog(actions, "Specify arguments for Oracle wsa.jar genProxy functionality", UISupport.TOOL_ICON);
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost, Interface modelItem) throws Exception {
        String wsaDir = SoapUI.getSettings().getString(ToolsSettings.ORACLE_WSA_LOCATION, null);
        if (Tools.isEmpty(wsaDir)) {
            UISupport.showErrorMessage("wsa.jar directory must be set in global preferences");
            return;
        }
        File wsaFile = new File(wsaDir + File.separatorChar + "wsa.jar");
        if (!wsaFile.exists()) {
            UISupport.showErrorMessage("Could not find wsa.jar at [" + wsaFile + "]");
            return;
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ArgumentBuilder args = this.buildArgs(modelItem);
        builder.command(args.getArgs());
        builder.directory(new File(wsaDir));
        toolHost.run(new ProcessToolRunner(builder, "Oracle wsa.jar", (ModelItem)modelItem));
    }

    private ArgumentBuilder buildArgs(Interface modelItem) throws IOException {
        StringToStringMap values = this.dialog.getValues();
        values.put(OUTPUT, Tools.ensureDir((String)values.get(OUTPUT), ""));
        ArgumentBuilder builder = new ArgumentBuilder(values);
        builder.addArgs("java", "-jar", "wsa.jar", "-genProxy");
        this.addJavaArgs(values, builder);
        builder.addArgs("-wsdl", this.getWsdlUrl(values, modelItem));
        builder.addString(OUTPUT, "-output");
        builder.addString(PACKAGE, "-packageName");
        this.addToolArgs(values, builder);
        return builder;
    }
}

