/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AnonymousTypeConfig;
import com.eviware.soapui.config.OperationConfig;
import com.eviware.soapui.config.OperationTypesConfig;
import com.eviware.soapui.config.PartsConfig;
import com.eviware.soapui.config.WsaVersionTypeConfig;
import com.eviware.soapui.config.WsdlRequestConfig;
import com.eviware.soapui.impl.support.AbstractHttpOperation;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlContentPart;
import com.eviware.soapui.impl.wsdl.WsdlHeaderPart;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapMessageBuilder;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.support.UISupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlOperation
extends AbstractWsdlModelItem<OperationConfig>
implements AbstractHttpOperation {
    public static final String STYLE_DOCUMENT = "Document";
    public static final String STYLE_RPC = "RPC";
    public static final String ONE_WAY = "One-Way";
    public static final String NOTIFICATION = "Notification";
    public static final String REQUEST_RESPONSE = "Request-Response";
    public static final String SOLICIT_RESPONSE = "Solicit-Response";
    public static final Logger log = Logger.getLogger(WsdlOperation.class);
    private List<WsdlRequest> requests = new ArrayList<WsdlRequest>();
    private WsdlInterface iface;
    private ImageIcon oneWayIcon;
    private ImageIcon notificationIcon;
    private ImageIcon solicitResponseIcon;

    public WsdlOperation(WsdlInterface iface, OperationConfig operationConfig) {
        super(operationConfig, iface, "/operation.gif");
        this.iface = iface;
        if (!operationConfig.isSetIsOneWay()) {
            operationConfig.setIsOneWay(false);
        }
        List requestConfigs = ((OperationConfig)this.getConfig()).getCallList();
        for (WsdlRequestConfig config : requestConfigs) {
            this.requests.add(new WsdlRequest(this, config));
        }
        this.oneWayIcon = UISupport.createImageIcon("/onewayoperation.gif");
        this.notificationIcon = UISupport.createImageIcon("/notificationoperation.gif");
        this.solicitResponseIcon = UISupport.createImageIcon("/solicitresponseoperation.gif");
    }

    public String getAction() {
        String action = ((OperationConfig)this.getConfig()).getAction();
        return action == null ? "" : action;
    }

    @Override
    public WsdlRequest getRequestAt(int index) {
        return this.requests.get(index);
    }

    @Override
    public WsdlRequest getRequestByName(String requestName) {
        return (WsdlRequest)this.getWsdlModelItemByName(this.requests, requestName);
    }

    @Override
    public int getRequestCount() {
        return this.requests.size();
    }

    @Override
    public ImageIcon getIcon() {
        if (this.isOneWay()) {
            return this.oneWayIcon;
        }
        if (this.isSolicitResponse()) {
            return this.solicitResponseIcon;
        }
        if (this.isNotification()) {
            return this.notificationIcon;
        }
        return super.getIcon();
    }

    public WsdlRequest addNewRequest(String name) {
        WsdlRequest requestImpl = new WsdlRequest(this, ((OperationConfig)this.getConfig()).addNewCall());
        requestImpl.setName(name);
        this.requests.add(requestImpl);
        if (!this.getInterface().getWsaVersion().equals(WsaVersionTypeConfig.NONE.toString())) {
            requestImpl.setWsAddressing(true);
        }
        WsdlUtils.setDefaultWsaAction(requestImpl.getWsaConfig(), false);
        WsdlUtils.getAnonymous(this);
        this.getInterface().fireRequestAdded(requestImpl);
        return requestImpl;
    }

    @Override
    public WsdlInterface getInterface() {
        return this.iface;
    }

    public void setAction(String soapAction) {
        String old = this.getAction();
        ((OperationConfig)this.getConfig()).setAction(soapAction);
        this.notifyPropertyChanged(ACTION_PROPERTY, old, soapAction);
    }

    public String createRequest(boolean buildOptional) {
        if (this.iface.getBindingName() == null) {
            UISupport.showErrorMessage("Missing binding name, please try to refresh Interface\nfor request generation to work correctly");
            return null;
        }
        if (this.getBindingOperationName() == null) {
            UISupport.showErrorMessage("Missing bindingOperation name, please try to refresh Interface\nfor request generation to work correctly");
            return null;
        }
        try {
            SoapMessageBuilder builder = this.iface.getMessageBuilder();
            BindingOperation bindingOperation = this.findBindingOperation(this.iface.getWsdlContext().getDefinition());
            if (bindingOperation == null) {
                UISupport.showErrorMessage("Failed to find bindingOperation, please try to refresh Interface\nfor request generation to work correctly");
                return null;
            }
            OperationType type = bindingOperation.getOperation().getStyle();
            if (OperationType.ONE_WAY.equals(type) || OperationType.REQUEST_RESPONSE.equals(type)) {
                return builder.buildSoapMessageFromInput(bindingOperation, buildOptional);
            }
            return builder.buildSoapMessageFromOutput(bindingOperation, buildOptional);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    public String createResponse(boolean buildOptional) {
        if (this.isUnidirectional()) {
            return null;
        }
        if (this.iface.getBindingName() == null) {
            UISupport.showErrorMessage("Missing binding name, please try to refresh Interface\nfor request generation to work correctly");
            return null;
        }
        if (this.getBindingOperationName() == null) {
            UISupport.showErrorMessage("Missing bindingOperation name, please try to refresh Interface\nfor request generation to work correctly");
            return null;
        }
        try {
            SoapMessageBuilder builder = this.iface.getMessageBuilder();
            BindingOperation bindingOperation = this.findBindingOperation(this.iface.getWsdlContext().getDefinition());
            if (bindingOperation == null) {
                UISupport.showErrorMessage("Failed to find bindingOperation, please try to refresh Interface\nfor request generation to work correctly");
                return null;
            }
            if (this.isRequestResponse()) {
                return builder.buildSoapMessageFromOutput(bindingOperation, buildOptional);
            }
            return builder.buildSoapMessageFromInput(bindingOperation, buildOptional);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    public BindingOperation findBindingOperation(Definition definition) {
        String bindingOperationName = ((OperationConfig)this.getConfig()).getBindingOperationName();
        return this.iface.findBindingOperation(definition, bindingOperationName, this.getInputName(), this.getOutputName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(WsdlRequest request) {
        int ix = this.requests.indexOf(request);
        this.requests.remove(ix);
        try {
            this.getInterface().fireRequestRemoved(request);
            Object var4_3 = null;
            request.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            request.release();
            ((OperationConfig)this.getConfig()).removeCall(ix);
            throw throwable;
        }
        ((OperationConfig)this.getConfig()).removeCall(ix);
    }

    public OperationType getOperationType() {
        OperationConfig config = (OperationConfig)this.getConfig();
        if (!config.isSetType()) {
            if (config.getIsOneWay()) {
                config.setType(OperationTypesConfig.ONE_WAY);
                return OperationType.ONE_WAY;
            }
            config.setType(OperationTypesConfig.REQUEST_RESPONSE);
            return OperationType.REQUEST_RESPONSE;
        }
        OperationTypesConfig.Enum type = config.getType();
        if (OperationTypesConfig.ONE_WAY.equals(type)) {
            return OperationType.ONE_WAY;
        }
        if (OperationTypesConfig.NOTIFICATION.equals(type)) {
            return OperationType.NOTIFICATION;
        }
        if (OperationTypesConfig.SOLICIT_RESPONSE.equals(type)) {
            return OperationType.SOLICIT_RESPONSE;
        }
        return OperationType.REQUEST_RESPONSE;
    }

    public void setOperationType(OperationType type) {
        OperationConfig config = (OperationConfig)this.getConfig();
        if (type == null) {
            if (config.isSetType()) {
                config.unsetType();
            }
        } else if (OperationType.ONE_WAY.equals(type)) {
            config.setType(OperationTypesConfig.ONE_WAY);
        } else if (OperationType.NOTIFICATION.equals(type)) {
            config.setType(OperationTypesConfig.NOTIFICATION);
        } else if (OperationType.SOLICIT_RESPONSE.equals(type)) {
            config.setType(OperationTypesConfig.SOLICIT_RESPONSE);
        } else {
            config.setType(OperationTypesConfig.REQUEST_RESPONSE);
        }
    }

    public String getBindingOperationName() {
        return ((OperationConfig)this.getConfig()).getBindingOperationName();
    }

    public void setBindingOperationName(String name) {
        ((OperationConfig)this.getConfig()).setBindingOperationName(name);
    }

    public void setInputName(String name) {
        ((OperationConfig)this.getConfig()).setInputName(name);
    }

    public String getInputName() {
        String inputName = ((OperationConfig)this.getConfig()).getInputName();
        return inputName == null || inputName.trim().length() == 0 ? null : inputName;
    }

    public void setOutputName(String name) {
        if (name == null) {
            if (((OperationConfig)this.getConfig()).isSetOutputName()) {
                ((OperationConfig)this.getConfig()).unsetOutputName();
            }
        } else {
            ((OperationConfig)this.getConfig()).setOutputName(name);
        }
    }

    public String getOutputName() {
        String outputName = ((OperationConfig)this.getConfig()).getOutputName();
        return outputName == null || outputName.trim().length() == 0 ? null : outputName;
    }

    public String getAnonymous() {
        if (((OperationConfig)this.getConfig()).getAnonymous() != null) {
            if (((OperationConfig)this.getConfig()).getAnonymous().equals(AnonymousTypeConfig.PROHIBITED)) {
                return AnonymousTypeConfig.PROHIBITED.toString();
            }
            if (((OperationConfig)this.getConfig()).getAnonymous().equals(AnonymousTypeConfig.REQUIRED)) {
                return AnonymousTypeConfig.REQUIRED.toString();
            }
        }
        return AnonymousTypeConfig.OPTIONAL.toString();
    }

    public void setAnonymous(String anonymous) {
        if (anonymous.equals(AnonymousTypeConfig.REQUIRED.toString())) {
            ((OperationConfig)this.getConfig()).setAnonymous(AnonymousTypeConfig.REQUIRED);
        } else if (anonymous.equals(AnonymousTypeConfig.PROHIBITED.toString())) {
            ((OperationConfig)this.getConfig()).setAnonymous(AnonymousTypeConfig.PROHIBITED);
        } else {
            ((OperationConfig)this.getConfig()).setAnonymous(AnonymousTypeConfig.OPTIONAL);
        }
    }

    public boolean isOneWay() {
        return OperationType.ONE_WAY.equals(this.getOperationType());
    }

    public boolean isNotification() {
        return OperationType.NOTIFICATION.equals(this.getOperationType());
    }

    public boolean isSolicitResponse() {
        return OperationType.SOLICIT_RESPONSE.equals(this.getOperationType());
    }

    public boolean isRequestResponse() {
        return OperationType.REQUEST_RESPONSE.equals(this.getOperationType());
    }

    @Override
    public boolean isUnidirectional() {
        return this.isOneWay() || this.isNotification();
    }

    @Override
    public boolean isBidirectional() {
        return !this.isUnidirectional();
    }

    public void initFromBindingOperation(BindingOperation operation) {
        this.setAction(WsdlUtils.getSoapAction(operation));
        this.setName(operation.getOperation().getName());
        this.setBindingOperationName(operation.getName());
        this.setOperationType(operation.getOperation().getStyle());
        BindingInput bindingInput = operation.getBindingInput();
        BindingOutput bindingOutput = operation.getBindingOutput();
        this.setOutputName(bindingOutput != null ? bindingOutput.getName() : null);
        this.setInputName(bindingInput != null ? bindingInput.getName() : null);
        this.initAttachments(operation);
    }

    private void initAttachments(BindingOperation operation) {
        PartsConfig.Part part;
        List<MIMEContent> contentParts;
        int c;
        HashMap<String, PartsConfig.Part> partMap;
        List parts;
        if (((OperationConfig)this.getConfig()).isSetRequestParts()) {
            ((OperationConfig)this.getConfig()).unsetRequestParts();
        }
        if (((OperationConfig)this.getConfig()).isSetResponseParts()) {
            ((OperationConfig)this.getConfig()).unsetResponseParts();
        }
        BindingOutput bindingOutput = operation.getBindingOutput();
        BindingInput bindingInput = operation.getBindingInput();
        if (bindingOutput != null) {
            MIMEMultipartRelated multipartOutput = WsdlUtils.getExtensiblityElement(bindingOutput.getExtensibilityElements(), MIMEMultipartRelated.class);
            ((OperationConfig)this.getConfig()).setReceivesAttachments(multipartOutput != null);
            if (multipartOutput != null) {
                parts = multipartOutput.getMIMEParts();
                partMap = new HashMap<String, PartsConfig.Part>();
                for (c = 0; c < parts.size(); ++c) {
                    contentParts = WsdlUtils.getExtensiblityElements(((MIMEPart)parts.get(c)).getExtensibilityElements(), MIMEContent.class);
                    for (MIMEContent content : contentParts) {
                        part = (PartsConfig.Part)partMap.get(content.getPart());
                        if (part != null) {
                            if (part.getContentTypeList().contains(content.getType())) continue;
                            part.addContentType(content.getType());
                            continue;
                        }
                        if (!((OperationConfig)this.getConfig()).isSetResponseParts()) {
                            ((OperationConfig)this.getConfig()).addNewResponseParts();
                        }
                        PartsConfig.Part responsePart = ((OperationConfig)this.getConfig()).getResponseParts().addNewPart();
                        responsePart.addContentType(content.getType());
                        responsePart.setName(content.getPart());
                        partMap.put(responsePart.getName(), responsePart);
                    }
                }
            }
        }
        if (bindingInput != null) {
            MIMEMultipartRelated multipartInput = WsdlUtils.getExtensiblityElement(bindingInput.getExtensibilityElements(), MIMEMultipartRelated.class);
            ((OperationConfig)this.getConfig()).setSendsAttachments(multipartInput != null);
            if (multipartInput != null) {
                parts = multipartInput.getMIMEParts();
                partMap = new HashMap();
                for (c = 0; c < parts.size(); ++c) {
                    contentParts = WsdlUtils.getExtensiblityElements(((MIMEPart)parts.get(c)).getExtensibilityElements(), MIMEContent.class);
                    for (MIMEContent content : contentParts) {
                        part = (PartsConfig.Part)partMap.get(content.getPart());
                        if (part != null) {
                            if (part.getContentTypeList().contains(content.getType())) continue;
                            part.addContentType(content.getType());
                            continue;
                        }
                        if (!((OperationConfig)this.getConfig()).isSetRequestParts()) {
                            ((OperationConfig)this.getConfig()).addNewRequestParts();
                        }
                        PartsConfig.Part requestPart = ((OperationConfig)this.getConfig()).getRequestParts().addNewPart();
                        requestPart.addContentType(content.getType());
                        requestPart.setName(content.getPart());
                        partMap.put(requestPart.getName(), requestPart);
                    }
                }
            }
        }
    }

    public boolean getReceivesAttachments() {
        return ((OperationConfig)this.getConfig()).getReceivesAttachments();
    }

    public boolean getSendsAttachments() {
        return ((OperationConfig)this.getConfig()).getSendsAttachments();
    }

    public QName getRequestBodyElementQName() throws Exception {
        BindingOperation bindingOperation;
        WsdlInterface iface = this.getInterface();
        Definition definition = iface.getWsdlContext().getDefinition();
        if (WsdlUtils.isRpc(definition, bindingOperation = this.findBindingOperation(definition))) {
            BindingInput bindingInput = bindingOperation.getBindingInput();
            if (bindingInput == null) {
                return null;
            }
            String ns = WsdlUtils.getSoapBodyNamespace(bindingInput.getExtensibilityElements());
            if (ns == null) {
                ns = WsdlUtils.getTargetNamespace(definition);
            }
            return new QName(ns, bindingOperation.getName());
        }
        Message message = bindingOperation.getOperation().getInput().getMessage();
        List parts = message.getOrderedParts(null);
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        int ix = 0;
        Part part = (Part)parts.get(0);
        while (part != null && (WsdlUtils.isAttachmentInputPart(part, bindingOperation) || WsdlUtils.isHeaderInputPart(part, message, bindingOperation))) {
            if (++ix < parts.size()) {
                part = (Part)parts.get(ix);
                continue;
            }
            part = null;
        }
        if (part == null) {
            return null;
        }
        if (part.getElementName() != null) {
            return part.getElementName();
        }
        return new QName(part.getName());
    }

    public QName getResponseBodyElementQName() throws Exception {
        BindingOperation bindingOperation;
        if (this.isUnidirectional()) {
            return null;
        }
        WsdlInterface iface = this.getInterface();
        Definition definition = iface.getWsdlContext().getDefinition();
        if (WsdlUtils.isRpc(definition, bindingOperation = this.findBindingOperation(definition))) {
            String ns;
            BindingOutput bindingOutput = bindingOperation.getBindingOutput();
            String string = ns = bindingOutput == null ? null : WsdlUtils.getSoapBodyNamespace(bindingOutput.getExtensibilityElements());
            if (ns == null) {
                ns = WsdlUtils.getTargetNamespace(definition);
            }
            return new QName(ns, bindingOperation.getName() + "Response");
        }
        Message message = bindingOperation.getOperation().getOutput().getMessage();
        List parts = message.getOrderedParts(null);
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        int ix = 0;
        Part part = (Part)parts.get(0);
        while (part != null && (WsdlUtils.isAttachmentOutputPart(part, bindingOperation) || WsdlUtils.isHeaderOutputPart(part, message, bindingOperation))) {
            if (++ix < parts.size()) {
                part = (Part)parts.get(ix);
                continue;
            }
            part = null;
        }
        if (part == null) {
            return null;
        }
        if (part.getElementName() != null) {
            return part.getElementName();
        }
        return new QName(part.getName());
    }

    public String getStyle() {
        WsdlContext wsdlContext = this.iface.getWsdlContext();
        if (!wsdlContext.isLoaded()) {
            return "<not loaded>";
        }
        try {
            Definition definition = wsdlContext.getDefinition();
            BindingOperation bindingOperation = this.findBindingOperation(definition);
            if (bindingOperation == null) {
                return "<missing bindingOperation>";
            }
            if (WsdlUtils.isRpc(definition, bindingOperation)) {
                return STYLE_RPC;
            }
            return STYLE_DOCUMENT;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return "<error>";
        }
    }

    public String getType() {
        if (this.isOneWay()) {
            return ONE_WAY;
        }
        if (this.isNotification()) {
            return NOTIFICATION;
        }
        if (this.isSolicitResponse()) {
            return SOLICIT_RESPONSE;
        }
        return REQUEST_RESPONSE;
    }

    @Override
    public void release() {
        super.release();
        for (WsdlRequest request : this.requests) {
            request.release();
        }
    }

    public BindingOperation getBindingOperation() {
        try {
            return this.findBindingOperation(this.getInterface().getWsdlContext().getDefinition());
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    @Override
    public List<Request> getRequestList() {
        return new ArrayList<Request>(this.requests);
    }

    @Override
    public MessagePart[] getDefaultRequestParts() {
        try {
            ArrayList<MessagePart.ContentPart> result = new ArrayList<MessagePart.ContentPart>();
            WsdlContext wsdlContext = this.getInterface().getWsdlContext();
            BindingOperation bindingOperation = this.findBindingOperation(wsdlContext.getDefinition());
            if (bindingOperation == null) {
                return new MessagePart[0];
            }
            BindingInput bindingInput = bindingOperation.getBindingInput();
            if (bindingInput == null) {
                return new MessagePart[0];
            }
            List<WsdlUtils.SoapHeader> headers = WsdlUtils.getSoapHeaders(bindingInput.getExtensibilityElements());
            for (int i = 0; i < headers.size(); ++i) {
                WsdlUtils.SoapHeader header = headers.get(i);
                Message message = wsdlContext.getDefinition().getMessage(header.getMessage());
                if (message == null) {
                    log.error((Object)("Missing message for header: " + header.getMessage()));
                    continue;
                }
                Part part = message.getPart(header.getPart());
                if (part != null) {
                    SchemaType schemaType = WsdlUtils.getSchemaTypeForPart(wsdlContext, part);
                    SchemaGlobalElement schemaElement = WsdlUtils.getSchemaElementForPart(wsdlContext, part);
                    if (schemaType == null) continue;
                    result.add(new WsdlHeaderPart(part.getName(), schemaType, part.getElementName(), schemaElement));
                    continue;
                }
                log.error((Object)("Missing part for header; " + header.getPart()));
            }
            Part[] parts = WsdlUtils.getInputParts(bindingOperation);
            for (int i = 0; i < parts.length; ++i) {
                Part part = parts[i];
                if (WsdlUtils.isAttachmentInputPart(part, bindingOperation)) continue;
                SchemaType schemaType = WsdlUtils.getSchemaTypeForPart(wsdlContext, part);
                SchemaGlobalElement schemaElement = WsdlUtils.getSchemaElementForPart(wsdlContext, part);
                if (schemaType == null) continue;
                result.add(new WsdlContentPart(part.getName(), schemaType, part.getElementName(), schemaElement));
            }
            return result.toArray(new MessagePart[result.size()]);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return new MessagePart[0];
        }
    }

    @Override
    public MessagePart[] getDefaultResponseParts() {
        try {
            ArrayList<MessagePart.ContentPart> result = new ArrayList<MessagePart.ContentPart>();
            WsdlContext wsdlContext = this.getInterface().getWsdlContext();
            BindingOperation bindingOperation = this.findBindingOperation(wsdlContext.getDefinition());
            if (bindingOperation == null) {
                return new MessagePart[0];
            }
            BindingOutput bindingOutput = bindingOperation.getBindingOutput();
            if (bindingOutput == null) {
                return new MessagePart[0];
            }
            List<WsdlUtils.SoapHeader> headers = WsdlUtils.getSoapHeaders(bindingOutput.getExtensibilityElements());
            for (int i = 0; i < headers.size(); ++i) {
                WsdlUtils.SoapHeader header = headers.get(i);
                Message message = wsdlContext.getDefinition().getMessage(header.getMessage());
                if (message == null) {
                    log.error((Object)("Missing message for header: " + header.getMessage()));
                    continue;
                }
                Part part = message.getPart(header.getPart());
                if (part != null) {
                    SchemaType schemaType = WsdlUtils.getSchemaTypeForPart(wsdlContext, part);
                    SchemaGlobalElement schemaElement = WsdlUtils.getSchemaElementForPart(wsdlContext, part);
                    if (schemaType == null) continue;
                    result.add(new WsdlHeaderPart(part.getName(), schemaType, part.getElementName(), schemaElement));
                    continue;
                }
                log.error((Object)("Missing part for header; " + header.getPart()));
            }
            Part[] parts = WsdlUtils.getOutputParts(bindingOperation);
            for (int i = 0; i < parts.length; ++i) {
                Part part = parts[i];
                if (WsdlUtils.isAttachmentOutputPart(part, bindingOperation)) continue;
                SchemaType schemaType = WsdlUtils.getSchemaTypeForPart(wsdlContext, part);
                SchemaGlobalElement schemaElement = WsdlUtils.getSchemaElementForPart(wsdlContext, part);
                if (schemaType == null) continue;
                result.add(new WsdlContentPart(part.getName(), schemaType, part.getElementName(), schemaElement));
            }
            return result.toArray(new MessagePart[result.size()]);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return new MessagePart[0];
        }
    }

    public MessagePart.FaultPart[] getFaultParts() {
        BindingOperation bindingOperation = this.getBindingOperation();
        Map bindingFaults = bindingOperation.getBindingFaults();
        ArrayList<WsdlFaultPart> result = new ArrayList<WsdlFaultPart>();
        for (Object key : bindingFaults.keySet()) {
            result.add(new WsdlFaultPart((String)key));
        }
        return result.toArray(new MessagePart.FaultPart[result.size()]);
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.getRequestList();
    }

    @Override
    public Attachment.AttachmentEncoding getAttachmentEncoding(String part, boolean isRequest) {
        return AttachmentUtils.getAttachmentEncoding(this, part, !isRequest);
    }

    private class WsdlFaultPart
    extends MessagePart.FaultPart {
        private final String name;

        public WsdlFaultPart(String name) {
            this.name = name;
        }

        public Part[] getWsdlParts() {
            try {
                return WsdlUtils.getFaultParts(WsdlOperation.this.getBindingOperation(), this.name);
            }
            catch (Exception e) {
                log.error((Object)e.toString(), (Throwable)e);
                return new Part[0];
            }
        }

        public QName getPartElementName() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public SchemaType getSchemaType() {
            return null;
        }

        public SchemaGlobalElement getPartElement() {
            return null;
        }
    }
}

