/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.ModelItemConfig;
import com.eviware.soapui.config.PropertiesTypeConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.support.XmlBeansPropertiesTestPropertyHolder;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.support.StringUtils;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestPropertyHolderWsdlModelItem<T extends ModelItemConfig>
extends AbstractWsdlModelItem<T>
implements MutableTestPropertyHolder {
    private XmlBeansPropertiesTestPropertyHolder propertyHolderSupport;
    private static final Logger log = Logger.getLogger(AbstractTestPropertyHolderWsdlModelItem.class);

    protected AbstractTestPropertyHolderWsdlModelItem(T config, ModelItem parent, String icon) {
        super(config, parent, icon);
    }

    protected void setPropertiesConfig(PropertiesTypeConfig config) {
        if (this.propertyHolderSupport == null) {
            this.propertyHolderSupport = new XmlBeansPropertiesTestPropertyHolder(this, config);
        } else {
            this.propertyHolderSupport.resetPropertiesConfig(config);
        }
        String propertyName = this.createPropertyName(this.getName());
        if (StringUtils.hasContent(propertyName)) {
            int result;
            String propFileName = "soapui.properties." + propertyName;
            String propFile = System.getProperty(propFileName);
            if (!StringUtils.hasContent(propFile)) {
                propFile = SoapUI.getGlobalProperties().getPropertyValue(propFileName);
            }
            if (StringUtils.hasContent(propFile) && (result = this.propertyHolderSupport.addPropertiesFromFile(propFile)) > 0) {
                log.info((Object)("Overriding " + result + " properties from [" + propFile + "] in [" + this.getName() + "]"));
            }
        }
    }

    private String createPropertyName(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (char ch : str.toCharArray()) {
            if (!Character.isLetterOrDigit(ch)) continue;
            result.append(ch);
        }
        return result.toString();
    }

    public int addPropertiesFromFile(String propFile) {
        return this.propertyHolderSupport.addPropertiesFromFile(propFile);
    }

    @Override
    public TestProperty addProperty(String name) {
        return this.propertyHolderSupport.addProperty(name);
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolderSupport.addTestPropertyListener(listener);
    }

    @Override
    public TestProperty getProperty(String name) {
        return this.propertyHolderSupport.getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyHolderSupport.getPropertyNames();
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.propertyHolderSupport.getPropertyList();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.propertyHolderSupport.getPropertyValue(name);
    }

    @Override
    public TestProperty removeProperty(String propertyName) {
        return this.propertyHolderSupport.removeProperty(propertyName);
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolderSupport.removeTestPropertyListener(listener);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        this.propertyHolderSupport.setPropertyValue(name, value);
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        return PropertyExpansionUtils.renameProperty(this.propertyHolderSupport.getProperty(name), newName, this) != null;
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        return this.propertyHolderSupport.getProperties();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertyHolderSupport.hasProperty(name);
    }

    @Override
    public TestProperty getPropertyAt(int index) {
        return this.propertyHolderSupport.getPropertyAt(index);
    }

    @Override
    public int getPropertyCount() {
        return this.propertyHolderSupport.getPropertyCount();
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        this.propertyHolderSupport.moveProperty(propertyName, targetIndex);
    }

    @Override
    public ModelItem getModelItem() {
        return this;
    }

    @Override
    public String getPropertiesLabel() {
        return "Test Properties";
    }
}

