/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.schema;

import com.eviware.soapui.impl.wadl.inference.ConflictHandler;
import com.eviware.soapui.impl.wadl.inference.schema.Context;
import com.eviware.soapui.impl.wadl.inference.schema.Schema;
import com.eviware.soapui.impl.wadl.inference.schema.Type;
import com.eviware.soapui.inferredSchema.SchemaConfig;
import com.eviware.soapui.inferredSchema.SchemaSetConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaSystem {
    Map<String, Schema> schemas = new LinkedHashMap<String, Schema>();

    public SchemaSystem() {
    }

    public SchemaSystem(SchemaSetConfig xml) {
        for (SchemaConfig item : xml.getSchemaList()) {
            this.schemas.put(item.getNamespace(), new Schema(item, this));
        }
    }

    public void save(SchemaSetConfig xml) {
        for (Schema item : this.schemas.values()) {
            item.save(xml.addNewSchema());
        }
    }

    public Schema newSchema(String namespace) {
        Schema schema = new Schema(namespace, this);
        this.schemas.put(namespace, schema);
        return schema;
    }

    public Schema getSchemaForNamespace(String namespace) {
        return this.schemas.get(namespace);
    }

    public Type getType(QName qname) {
        return this.getSchemaForNamespace(qname.getNamespaceURI()).getType(qname.getLocalPart());
    }

    public void validate(XmlObject xmlo, ConflictHandler handler) throws XmlException {
        XmlCursor cursor = xmlo.newCursor();
        cursor.toFirstChild();
        Schema s = this.getSchemaForNamespace(cursor.getName().getNamespaceURI());
        boolean created = false;
        if (s == null) {
            s = this.newSchema(cursor.getName().getNamespaceURI());
            created = true;
        }
        Context context = new Context(this, handler, cursor);
        try {
            s.validate(context);
        }
        catch (XmlException e) {
            if (created) {
                this.schemas.remove(s.getNamespace());
            }
            throw e;
        }
    }

    public Set<String> getNamespaces() {
        return this.schemas.keySet();
    }

    public void deleteNamespace(String ns) {
        this.schemas.remove(ns);
    }
}

