/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.definition.export;

import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.support.definition.InterfaceDefinition;
import com.eviware.soapui.impl.support.definition.InterfaceDefinitionPart;
import com.eviware.soapui.impl.support.definition.export.AbstractDefinitionExporter;
import java.util.List;
import net.java.dev.wadl.x2009.x02.ApplicationDocument;
import net.java.dev.wadl.x2009.x02.MethodDocument;
import net.java.dev.wadl.x2009.x02.RepresentationDocument;
import net.java.dev.wadl.x2009.x02.ResourceDocument;
import net.java.dev.wadl.x2009.x02.ResourcesDocument;
import net.java.dev.wadl.x2009.x02.ResponseDocument;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlDefinitionExporter
extends AbstractDefinitionExporter<RestService> {
    public WadlDefinitionExporter(InterfaceDefinition<RestService> definition) {
        super(definition);
    }

    public WadlDefinitionExporter(RestService restService) throws Exception {
        this(restService.getDefinitionContext().getInterfaceDefinition());
    }

    @Override
    public String export(String folderName) throws Exception {
        if (((RestService)this.getDefinition().getInterface()).isGenerated()) {
            this.setDefinition(((RestService)this.getDefinition().getInterface()).getWadlContext().regenerateWadl());
        }
        return super.export(folderName);
    }

    @Override
    protected String[] getLocationXPathsToReplace() {
        return new String[]{"declare namespace s='" + ((RestService)this.getDefinition().getInterface()).getWadlVersion() + "' .//s:grammars/s:include/@href", "declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import/@schemaLocation", "declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include/@schemaLocation"};
    }

    @Override
    protected void postProcessing(XmlObject obj, InterfaceDefinitionPart part) {
        if (part.getType().equals("http://wadl.dev.java.net/2009/02")) {
            ApplicationDocument document = (ApplicationDocument)obj;
            for (ResourcesDocument.Resources resources : document.getApplication().getResourcesList()) {
                for (ResourceDocument.Resource resource : resources.getResourceList()) {
                    for (MethodDocument.Method method : resource.getMethodList()) {
                        this.fixRepresentations(method.getRequest().getRepresentationList());
                        for (ResponseDocument.Response response : method.getResponseList()) {
                            this.fixRepresentations(response.getRepresentationList());
                        }
                    }
                }
            }
        }
    }

    private void fixRepresentations(List<RepresentationDocument.Representation> representationList) {
        for (RepresentationDocument.Representation representation : representationList) {
            if ("text/xml".equals(representation.getMediaType()) || "application/xml".equals(representation.getMediaType()) || !representation.isSetElement()) continue;
            String prefix = representation.xgetElement().getDomNode().getNodeValue().split(":")[0];
            representation.unsetElement();
            ((Element)representation.getDomNode()).removeAttribute("xmlns:" + prefix);
        }
    }
}

