/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.views.html;

import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.BrowserComponent;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.inspectors.attachments.ContentTypeHandler;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHtmlResponseView
extends AbstractXmlEditorView<AbstractHttpXmlRequestDesktopPanel.HttpResponseDocument>
implements PropertyChangeListener {
    private final HttpRequestInterface<?> restRequest;
    private JPanel contentPanel;
    private JPanel panel;
    private JLabel statusLabel;
    private BrowserComponent browser;

    public HttpHtmlResponseView(AbstractHttpXmlRequestDesktopPanel.HttpResponseMessageEditor httpRequestMessageEditor, HttpRequestInterface<?> httpRequest) {
        super("HTML", httpRequestMessageEditor, "HTML Response");
        this.restRequest = httpRequest;
        httpRequest.addPropertyChangeListener(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.panel.add(this.buildToolbar(), "North");
            this.panel.add(this.buildContent(), "Center");
            this.panel.add(this.buildStatus(), "South");
        }
        return this.panel;
    }

    @Override
    public void release() {
        super.release();
        if (this.browser != null) {
            this.browser.release();
        }
        this.restRequest.removePropertyChangeListener(this);
    }

    private Component buildStatus() {
        this.statusLabel = new JLabel();
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return this.statusLabel;
    }

    private Component buildContent() {
        this.contentPanel = new JPanel(new BorderLayout());
        if (BrowserComponent.isJXBrowserDisabled()) {
            this.contentPanel.add(new JLabel("Browser Component is disabled"));
        } else {
            this.browser = new BrowserComponent(false);
            Component component = this.browser.getComponent();
            component.setMinimumSize(new Dimension(100, 100));
            this.contentPanel.add(component);
            HttpResponse response = this.restRequest.getResponse();
            if (response != null) {
                this.setEditorContent(response);
            }
        }
        return this.contentPanel;
    }

    protected void setEditorContent(HttpResponse httpResponse) {
        if (httpResponse != null && httpResponse.getContentType() != null) {
            String contentType = httpResponse.getContentType();
            if (contentType.contains("html") || contentType.contains("text")) {
                try {
                    String content = httpResponse.getContentAsString();
                    content = new String(content.getBytes("UTF-8"), "iso-8859-1");
                    this.browser.setContent(content, contentType, httpResponse.getURL().toURI().toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (!contentType.contains("xml")) {
                try {
                    String ext = ContentTypeHandler.getExtensionForContentType(contentType);
                    File temp = File.createTempFile("response", "." + ext);
                    FileOutputStream fileOutputStream = new FileOutputStream(temp);
                    this.writeHttpBody(httpResponse.getRawResponseData(), fileOutputStream);
                    fileOutputStream.close();
                    this.browser.navigate(temp.toURI().toURL().toString(), null);
                    temp.deleteOnExit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.browser.setContent("<missing content>", "text/plain");
        }
    }

    private void writeHttpBody(byte[] rawResponse, FileOutputStream out) throws IOException {
        byte[] divider = "\r\n\r\n".getBytes();
        for (int index = 0; index < rawResponse.length - divider.length; ++index) {
            int i;
            for (i = 0; i < divider.length && rawResponse[index + i] == divider[i]; ++i) {
            }
            if (i != divider.length) continue;
            out.write(rawResponse, index + divider.length, rawResponse.length - (index + divider.length));
            return;
        }
        out.write(rawResponse);
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        return toolbar;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(AbstractHttpRequestInterface.RESPONSE_PROPERTY) && this.browser != null) {
            this.setEditorContent((HttpResponse)evt.getNewValue());
        }
    }

    @Override
    public void setXml(String xml) {
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return false;
    }

    @Override
    public void setEditable(boolean enabled) {
    }
}

