/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.inspectors.representations;

import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRepresentation;
import com.eviware.soapui.impl.rest.panels.method.RestRepresentationsTable;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRestRepresentationsInspector
extends AbstractXmlInspector
implements PropertyChangeListener {
    private RestRepresentationsTable representationTable;
    private final RestMethod restMethod;
    private List<RestRepresentation.Type> types;

    protected AbstractRestRepresentationsInspector(RestMethod restMethod, String name, String description, RestRepresentation.Type[] types) {
        super(name, description, true, "Rep");
        this.restMethod = restMethod;
        this.types = Arrays.asList(types);
        restMethod.addPropertyChangeListener("representations", this);
        this.updateLabel();
    }

    @Override
    public JComponent getComponent() {
        if (this.representationTable == null) {
            this.buildUI();
        }
        return this.representationTable;
    }

    protected void addToToolbar(JXToolBar toolbar) {
    }

    protected void buildUI() {
        this.representationTable = new RestRepresentationsTable(this.restMethod, this.types.toArray(new RestRepresentation.Type[0]), true){

            protected JXToolBar buildToolbar() {
                JXToolBar toolbar = super.buildToolbar();
                AbstractRestRepresentationsInspector.this.addToToolbar(toolbar);
                return toolbar;
            }
        };
    }

    public RestMethod getMethod() {
        return this.restMethod;
    }

    @Override
    public boolean isEnabledFor(EditorView<XmlDocument> view) {
        return !view.getViewId().equals("Raw");
    }

    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        return true;
    }

    @Override
    public void release() {
        this.representationTable.release();
        this.restMethod.removePropertyChangeListener("representations", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateLabel();
    }

    private void updateLabel() {
        int cnt = 0;
        for (RestRepresentation representation : this.restMethod.getRepresentations()) {
            if (!this.types.contains((Object)representation.getType())) continue;
            ++cnt;
        }
        this.setTitle("Representations (" + cnt + ")");
    }
}

